/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.client.opers;

import netscape.ldap.ber.stream.BERBoolean;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEREnumerated;
import netscape.ldap.ber.stream.BERInteger;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.JDAPFilter;
import netscape.ldap.client.opers.JDAPBaseDNRequest;
import netscape.ldap.client.opers.JDAPProtocolOp;

public class JDAPSearchRequest
extends JDAPBaseDNRequest
implements JDAPProtocolOp {
    public static final int BASE_OBJECT = 0;
    public static final int SINGLE_LEVEL = 1;
    public static final int WHOLE_SUBTREE = 2;
    public static final int NEVER_DEREF_ALIASES = 0;
    public static final int DEREF_IN_SEARCHING = 1;
    public static final int DEREF_FINDING_BASE_OBJ = 2;
    public static final int DEREF_ALWAYS = 3;
    protected String m_base_dn;
    protected int m_scope;
    protected int m_deref;
    protected int m_size_limit;
    protected int m_time_limit;
    protected boolean m_attrs_only;
    protected String m_filter;
    protected String[] m_attrs;

    public JDAPSearchRequest(String base_dn, int scope, int deref, int size_limit, int time_limit, boolean attrs_only, String filter, String[] attrs) {
        this.m_base_dn = base_dn;
        this.m_scope = scope;
        this.m_deref = deref;
        this.m_size_limit = size_limit;
        this.m_time_limit = time_limit;
        this.m_attrs_only = attrs_only;
        this.m_filter = filter;
        this.m_attrs = attrs;
    }

    public int getType() {
        return 3;
    }

    public void setBaseDN(String basedn) {
        this.m_base_dn = basedn;
    }

    public String getBaseDN() {
        return this.m_base_dn;
    }

    public BERElement getBERElement() {
        BERSequence seq = new BERSequence();
        seq.addElement(new BEROctetString(this.m_base_dn));
        seq.addElement(new BEREnumerated(this.m_scope));
        seq.addElement(new BEREnumerated(this.m_deref));
        seq.addElement(new BERInteger(this.m_size_limit));
        seq.addElement(new BERInteger(this.m_time_limit));
        seq.addElement(new BERBoolean(this.m_attrs_only));
        JDAPFilter filter = JDAPFilter.getFilter(this.m_filter);
        if (filter == null) {
            return null;
        }
        seq.addElement(filter.getBERElement());
        BERSequence attr_type_list = new BERSequence();
        if (this.m_attrs != null) {
            int i = 0;
            while (i < this.m_attrs.length) {
                attr_type_list.addElement(new BEROctetString(this.m_attrs[i]));
                ++i;
            }
        }
        seq.addElement(attr_type_list);
        BERTag element = new BERTag(99, seq, true);
        return element;
    }

    public String toString() {
        String s = null;
        if (this.m_attrs != null) {
            int i = 0;
            while (i < this.m_attrs.length) {
                if (i != 0) {
                    s = String.valueOf(s) + "+";
                }
                s = String.valueOf(s) + this.m_attrs[i];
                ++i;
            }
        }
        return "JDAPSearchRequest {baseObject=" + this.m_base_dn + ", scope=" + this.m_scope + ", derefAliases=" + this.m_deref + ",sizeLimit=" + this.m_size_limit + ", timeLimit=" + this.m_time_limit + ", attrsOnly=" + this.m_attrs_only + ", filter=" + this.m_filter + ", attributes=" + s + "}";
    }
}

