/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPUrl;

public class LDAPReferralException
extends LDAPException {
    private String[] m_referrals;

    public LDAPReferralException() {
    }

    public LDAPReferralException(String message) {
        super(message);
    }

    public LDAPReferralException(String message, int resultCode, String serverErrorMessage) {
        super(message, resultCode, serverErrorMessage);
    }

    public LDAPReferralException(String message, int resultCode, String[] referrals) {
        super(message, resultCode, null);
        this.m_referrals = referrals;
    }

    public LDAPUrl[] getURLs() {
        if (this.getLDAPErrorMessage() == null) {
            return this.constructsURL(this.m_referrals);
        }
        return this.constructsURL(this.extractReferrals(this.getLDAPErrorMessage()));
    }

    private LDAPUrl[] constructsURL(String[] referrals) {
        if (referrals == null) {
            return null;
        }
        LDAPUrl[] u = new LDAPUrl[referrals.length];
        if (u == null) {
            return null;
        }
        int i = 0;
        while (i < referrals.length) {
            try {
                u[i] = new LDAPUrl(referrals[i]);
            }
            catch (Exception exception) {
                return null;
            }
            ++i;
        }
        return u;
    }

    private String[] extractReferrals(String error) {
        if (error == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(error, "\n");
        Vector<String> v = new Vector<String>();
        boolean referrals = false;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (referrals) {
                v.addElement(token);
                continue;
            }
            if (!token.startsWith("Referral:")) continue;
            referrals = true;
        }
        if (v.size() == 0) {
            return null;
        }
        String[] res = new String[v.size()];
        int i = 0;
        while (i < v.size()) {
            res[i] = (String)v.elementAt(i);
            ++i;
        }
        return res;
    }
}

