/*
 * Decompiled with CFR 0.152.
 */
package netscape.security;

import netscape.security.AppletSecurity;
import netscape.security.PrivilegeManager;
import netscape.security.Target;

public class AppletSecurityException
extends SecurityException {
    Target target;

    public AppletSecurityException(String name) {
        super(AppletSecurityException.getProperty(name));
        PrivilegeManager privMgr = AppletSecurity.getPrivilegeManager();
        if (privMgr.getBoolPref("signed.applets.verbose_security_exception")) {
            System.err.println("# Security Exception: " + name);
            this.printStackTrace();
        }
    }

    public AppletSecurityException(String name, String arg) {
        super(String.valueOf(AppletSecurityException.getProperty(name)) + ": " + arg);
        PrivilegeManager privMgr = AppletSecurity.getPrivilegeManager();
        if (privMgr.getBoolPref("signed.applets.verbose_security_exception")) {
            System.err.println("# Security Exception: " + name + ":" + arg);
            this.printStackTrace();
        }
    }

    public AppletSecurityException(String name, String arg, String arg2) {
        super(String.valueOf(AppletSecurityException.getProperty(name)) + ": " + arg);
        PrivilegeManager privMgr = AppletSecurity.getPrivilegeManager();
        if (privMgr.getBoolPref("signed.applets.verbose_security_exception")) {
            System.err.println("# Security Exception: " + name + ":" + arg + ":" + arg2);
            this.printStackTrace();
        }
    }

    private static String getProperty(String name) {
        String prop;
        try {
            SecurityManager.enablePrivilege((String)"UniversalPropertyRead");
            prop = System.getProperty("security." + name, "security." + name);
        }
        catch (Exception exception) {
            prop = "security." + name;
        }
        return prop;
    }

    public AppletSecurityException(Target requiredTarget, String name) {
        this(name);
        this.target = requiredTarget;
    }

    public AppletSecurityException(Target requiredTarget, String name, String arg) {
        this(name, arg);
        this.target = requiredTarget;
    }

    public AppletSecurityException(Target requiredTarget, String name, String arg, String arg2) {
        this(name, arg, arg2);
        this.target = requiredTarget;
    }

    public String toString() {
        PrivilegeManager privMgr;
        String msg = super.toString();
        if (this.target != null && (privMgr = AppletSecurity.getPrivilegeManager()).getBoolPref("signed.applets.verbose_security_exception")) {
            msg = String.valueOf(msg) + "\n#  " + this.target.getName() + " privilege not enabled: " + this.target.getDescription();
        }
        return msg;
    }
}

