#!/usr/bin/make -f
#
# source:
#   /var/cvs/projects/debian/dpkg.common/rules_var.mk,v
#
# revision:
#   @(#) rules_var.mk,v 1.7 1998/09/12 21:41:07 jplejacq Exp
#
# copyright:
#   Copyright (C) 1998 Jean Pierre LeJacq <jplejacq@quoininc.com>
#
#   Distributed under the GNU GENERAL PUBLIC LICENSE.
#
# description:
#   Standard variables for package building script for package.
#
#   This program is package independent and should work unmodified
#   with any package.
#
# bugs:
#   rules_pkgs creates the link debian/control since this is required
#   by the other dynamic variables.  Unfortunately, the link isn't
#   available after checkout from CVS which causes an error message to 
#   be printed.  This solves this problem but not in an elegant way.



#
# Generate list of all binary packages for this source package.
#
rules_pkgs=\
  $(shell\
    test -L debian/control || ln -f -s dpkg.src/control debian;\
    DH_DOPACKAGES=$$(./debian/dpkg.common/getpackages);\
    echo $${DH_DOPACKAGES}\
  )


#
# Generate list of architecture indep binary packages for this source
# package.
#
rules_pkgs_indep=\
  $(shell\
    DH_DOINDEP=$$(./debian/dpkg.common/getpackages indep);\
    echo $${DH_DOINDEP}\
  )


#
# Generate list of architecture dependent binary packages for this
# source package.
#
rules_pkgs_arch=\
  $(shell\
    DH_DOARCH=$$(./debian/dpkg.common/getpackages indep);\
    echo $${DH_DOARCH}\
  )


#
# Generate temporary directory to build debian binary package.
#
define rules_tmpdir
$(patsubst %.stamp-check,%.tmp,$(patsubst %.stamp-modify,%.tmp,$(patsubst %.stamp-binary,%.tmp,$(patsubst %.stamp-build,%.tmp,$(@)))))
endef


#
# Generate name of debian binary package.
#
define rules_pkg
$(patsubst debian/%.stamp-check,%,$(patsubst debian/%.stamp-modify,%,$(patsubst debian/%.stamp-binary,%,$(patsubst debian/%.stamp-build,%,$(@)))))
endef
