/* 
** Copyright (C) 1994, 1995 Enterprise Integration Technologies Corp.
**         VeriFone Inc./Hewlett-Packard. All Rights Reserved.
** Kevin Hughes, kev@kevcom.com 3/11/94
** Kent Landfield, kent@landfield.com 4/6/97
** 
** This program and library is free software; you can redistribute it and/or 
** modify it under the terms of the GNU (Library) General Public License 
** as published by the Free Software Foundation; either version 2 
** of the License, or any later version. 
** 
** This program is distributed in the hope that it will be useful, 
** but WITHOUT ANY WARRANTY; without even the implied warranty of 
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the 
** GNU (Library) General Public License for more details. 
** 
** You should have received a copy of the GNU (Library) General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA 
*/

#include "hypermail.h"
#include <time.h>

/* 
** Ladies and germs - the hash function.
*/

unsigned hash(char *s)
{
	unsigned hashval;

	for (hashval = 0; *s != '\0'; s++)
		hashval = *s + 31 * hashval;
	return hashval % HASHSIZE;
}

/*
** The structure most of everything else depends on.
** Hashes a message - header info, pointer to a list of body lines -
** by number, message ID, date, and subject, so an article can be
** handily looked up and retrieved using any of these criteria.
*/

void addhash(int num, char *date, char *name, char *email, char *msgid,
             char *subject, char *inreply, char *fromdate, struct body *bp)
{
	struct email *ep;
	struct body *sp;
	unsigned hashval;
	char numstr[NUMSTRLEN];

	sp = bp;

	ep = (struct email *) emalloc(sizeof(*ep));
	ep->msgnum = num;
	ep->name = (char *) strsav(name);
	ep->emailaddr = (char *) strsav(email);
	ep->fromdatestr = (char *) strsav(fromdate);
	ep->datestr = (char *) strsav(date);
	ep->msgid = (char *) strsav(msgid);
	ep->subject = (char *) strsav(subject);
	ep->inreplyto = (char *) strsav(inreply);
	ep->bodylist = sp;

	hashval = hash(stripzone(date));
	ep->next = etable[hashval];
	etable[hashval] = ep;

	ep = (struct email *) emalloc(sizeof(*ep));
	ep->msgnum = num;
	ep->name = (char *) strsav(name);
	ep->emailaddr = (char *) strsav(email);
	ep->fromdatestr = (char *) strsav(fromdate);
	ep->datestr = (char *) strsav(date);
	ep->msgid = (char *) strsav(msgid);
	ep->subject = (char *) strsav(subject);
	ep->inreplyto = (char *) strsav(inreply);
	ep->bodylist = sp;

	hashval = hash(msgid);
	ep->next = etable[hashval];
	etable[hashval] = ep;

	ep = (struct email *) emalloc(sizeof(*ep));
	ep->msgnum = num;
	ep->name = (char *) strsav(name);
	ep->emailaddr = (char *) strsav(email);
	ep->fromdatestr = (char *) strsav(fromdate);
	ep->datestr = (char *) strsav(date);
	ep->msgid = (char *) strsav(msgid);
	ep->subject = (char *) strsav(subject);
	ep->inreplyto = (char *) strsav(inreply);
	ep->bodylist = sp;

	hashval = hash(subject);
	ep->next = etable[hashval];
	etable[hashval] = ep;

	ep = (struct email *) emalloc(sizeof(*ep));
	ep->msgnum = num;
	ep->name = (char *) strsav(name);
	ep->emailaddr = (char *) strsav(email);
	ep->fromdatestr = (char *) strsav(fromdate);
	ep->datestr = (char *) strsav(date);
	ep->msgid = (char *) strsav(msgid);
	ep->subject = (char *) strsav(subject);
	ep->inreplyto = (char *) strsav(inreply);
	ep->bodylist = sp;

	sprintf(numstr, "%d", num);
	hashval = hash(numstr);
	ep->next = etable[hashval];
	etable[hashval] = ep;
}

/*
** Given an "in-reply-to:" field, this tries to retrieve information
** about the article that is a reply. If all else fails but a reply is
** found by comparing subjects, issubjmatch is set to 1.
*/

int hashreplylookup(char *inreply, char *name, char *subject, int *issubjmatch)
{
	struct email *ep;

	*issubjmatch = 0;
	if (numstrchr(inreply, ':') == 2)
		ep = etable[hash(stripzone(inreply))];
	else
		ep = etable[hash(inreply)];
	while (ep != NULL) {
		if (strcmp(inreply, ep->msgid) == 0) {
			strcpy(name, ep->name);
			strcpy(subject, ep->subject);
			return ep->msgnum;
		}
		ep = ep->next;
	}

	if (numstrchr(inreply, ':') == 2)
		ep = etable[hash(stripzone(inreply))];
	else
		ep = etable[hash(inreply)];
	while (ep != NULL) {
		if (strstr(inreply, stripzone(ep->datestr))) {
			strcpy(name, ep->name);
			strcpy(subject, ep->subject);
			return ep->msgnum;
		}
		ep = ep->next;
	}

	if (numstrchr(inreply, ':') == 2)
		ep = etable[hash(stripzone(inreply))];
	else
		ep = etable[hash(inreply)];
	while (ep != NULL) {
		if (strcmp(inreply, ep->subject) == 0) {
			strcpy(name, ep->name);
			strcpy(subject, ep->subject);
			*issubjmatch = 1;
			return ep->msgnum;
		}
		ep = ep->next;
	}

	return -1;
}

/*
** Same as the above function, but only returns the article number.
*/

int hashreplynumlookup(char *inreply, int *maybereply)
{
	struct email *ep;

	*maybereply = 0;

	if (numstrchr(inreply, ':') == 2)
		ep = etable[hash(stripzone(inreply))];
	else
		ep = etable[hash(inreply)];
	while (ep != NULL) {
		if (strcmp(inreply, ep->msgid) == 0)
			return ep->msgnum;
		ep = ep->next;
	}

	if (numstrchr(inreply, ':') == 2)
		ep = etable[hash(stripzone(inreply))];
	else
		ep = etable[hash(inreply)];
	while (ep != NULL) {
		if (strstr(inreply, stripzone(ep->datestr)))
			return ep->msgnum;
		ep = ep->next;
	}

	if (numstrchr(inreply, ':') == 2)
		ep = etable[hash(stripzone(inreply))];
	else
		ep = etable[hash(inreply)];
	while (ep != NULL) {
		if (strcmp(inreply, ep->subject) == 0) {
			*maybereply = 1;
			return ep->msgnum;
		}
		ep = ep->next;
	}

	return -1;
}

/*
** From an article's number, retrieve all information associated with
** that article.
*/

struct body *hashnumlookup(int num, char *name, char *email, char *subject,
                        char *reply, char *date, char *fromdate, char *msgid)
{
	struct email *ep;
	char numstr[NUMSTRLEN];

	sprintf(numstr, "%d", num);
	for (ep = etable[hash(numstr)]; ep != NULL; ep = ep->next)
		if (num == ep->msgnum) {
			strcpy(name, ep->name);
			strcpy(email, ep->emailaddr);
			strcpy(subject, ep->subject);
			strcpy(reply, ep->inreplyto);
			strcpy(date, ep->datestr);
			strcpy(fromdate, ep->fromdatestr);
			strcpy(msgid, ep->msgid);
			return ep->bodylist;
		}
	return NULL;
}

/*
** Add a line to a linked list that makes up a boundary stack. This new one 
** should be the new "active" boundary.
**
** "Adding" a NULL will retrieve the formerly used boundary pointer.
*/

struct boundary *bound(struct boundary *bound, char *line)
{
    struct boundary *newnode=NULL;
  
    if (line) {
        newnode = (struct boundary *) emalloc(sizeof(struct boundary));
        newnode->line = (char *) strsav(line);
        newnode->next = NULL;
        newnode->prev = bound;
  
        if (bound)
            bound->next = newnode;
  
        bound = newnode;
    }
    else {
        if (bound->prev) {
            /* go back to the previous */
            bound = bound->prev;
        
            /* free the latest one */
            free(bound->next->line);
            free(bound->next);
        }
        else {
            /* this is the last node */
            free(bound->line);
            free(bound);
            bound = NULL;
        }
    }
    return bound; /* the new "active" boundary */
}


/*
** Add a line to a linked list that makes up an article's body.
*/

struct body *addbody(struct body *bp,
                     struct body **lp, /* points to the last pointer */
                     char *line, int flags)
{
    struct body *tempnode;
    struct body *newnode=NULL;
  
    if (!(flags&BODY_CONTINUE)) {
        newnode = (struct body *) emalloc(sizeof(struct body));
        memset(newnode, 0, sizeof(struct body));
        newnode->line = (char *) strsav(line);
        newnode->html = (flags&BODY_HTMLIZED)?1:0;
        newnode->header = (flags&BODY_HEADER)?1:0;
        newnode->attached = (flags&BODY_ATTACHED)?1:0;
        newnode->next = NULL;
    }
    if (bp == NULL) {
        bp = newnode;
        *lp = bp;
    }  
    else {
        tempnode = *lp; /* get pointer right away */
  
        if (flags&BODY_CONTINUE) {
            /* this is a continuation of the previous line */
            int newlen;
            char *newbuf;
  
            /* get the new size + 1 for the terminating zero */
            newlen = strlen(tempnode->line) + strlen(line) + 1;
        
            /* extend the former memory area: */
            newbuf = (char *)realloc(tempnode->line, newlen);
  
            /* if successful, continue */
            if (newbuf) {
                /* remove LF from the first part: */
                char *lf;
                lf = (char *)strchr(newbuf, '\n');
                if (lf)
                    *lf=0;
  
                /* append the new part */
                strcat(newbuf, line);
  
                /* point out the new buffer instead */
                tempnode->line = newbuf;
            }
        }
        else {
            tempnode->next = newnode;
            *lp = newnode;
        }
    }
    return bp;
}

/*
** Remove the last empty lines, if any, from an article body's linked list.
*/

int rmlastlines(struct body *bp)
{
	struct body *tempnode;

	for (tempnode = bp; tempnode->next != NULL &&
	(tempnode->next->line)[0] != '\0'; tempnode = tempnode->next)
		;
	if ((tempnode->line)[0] == '\n') {
		(tempnode->line)[0] = '\0';
		return 1;
	}
	return 0;
}

/*
** If a message is a reply to another, that message's number and the
** number of the message it may be referring to is put in this list.
*/

struct reply *addreply(struct reply *rp, int num, int fromnum,
                       char *name, char *subject, int maybereply)
{
	struct reply *tempnode, *newnode;

        newnode = (struct reply *) emalloc(sizeof(struct reply));
        newnode->msgnum = num;
        newnode->frommsgnum = fromnum;
        newnode->name = (char *) strsav(name);
        newnode->subject = (char *) strsav(subject);
	newnode->maybereply = maybereply;
        newnode->next = NULL;

        if (rp == NULL)
                rp = newnode;
        else {
                for (tempnode = rp; tempnode->next != NULL; tempnode =
                tempnode->next)
                        ;
                tempnode->next = newnode;
        }

        return rp;
}

/*
** Mark an article number as having been printed.
*/

struct printed *markasprinted(struct printed *pp, int num)
{
    struct printed *tempnode, *newnode;

    newnode = (struct printed *) emalloc(sizeof(struct printed));
    newnode->msgnum = num;
    newnode->next = NULL;

    if (pp == NULL)
        pp = newnode;
    else {
        for (tempnode = pp; tempnode->next != NULL; tempnode = tempnode->next);
        tempnode->next = newnode;
    }
    return pp;
}

/*
** Has an article already been printed?
*/

int wasprinted(struct printed *list, int num)
{
	struct printed *pp;

	for (pp = list; pp != NULL; pp = pp->next)
		if (pp->msgnum == num)
			return 1;
	return 0;
}

/*
** Add article header information to a binary tree and sort by date,
** subject, or author. This is necessary for printing the index files.
*/

struct header *addheader(struct header *hp, int num, char *name,
                         char *subject, char *date, int sorttype)
{
        int isbigger;
        long yearsecs;

        isbigger = 0;
        if (hp == NULL) {
                hp = (struct header *) emalloc(sizeof(struct header));
                hp->msgnum = num;
		hp->name = (char *) strsav(name);
		hp->subject = (char *) strsav(subject);
		hp->datestr = (char *) strsav(date);
		if (sorttype == 2) {
			yearsecs = convtoyearsecs(date);
			if (!yearsecs)
				yearsecs = (long)time((time_t *) 0);
			hp->datenum = yearsecs;
			if (!firstdatenum || yearsecs < firstdatenum)
				firstdatenum = yearsecs;
			if (yearsecs > lastdatenum)
				lastdatenum = yearsecs;
		}
		else
			hp->datenum = 0;
                hp->left = hp->right = NULL;
                return hp;
        }

	if (sorttype == 1)
	        isbigger = (strcasecmp(name, hp->name) > 0) ? 0 : 1;
	else if (sorttype == 0)
	        isbigger = (strcasecmp(subject, hp->subject) > 0) ? 0 : 1;
	else if (sorttype == 2) {
		yearsecs = convtoyearsecs(date);
		if (!yearsecs)
			yearsecs = (long)time((time_t *) 0);
		if (reverse)
		        isbigger = (yearsecs < hp->datenum) ? 0 : 1;
		else
		        isbigger = (yearsecs >= hp->datenum) ? 0 : 1;
		if (!firstdatenum || yearsecs < firstdatenum)
			firstdatenum = yearsecs;
		if (yearsecs > lastdatenum)
			lastdatenum = yearsecs;
	}

        if (isbigger)
                hp->left = addheader(hp->left, num, name, subject, date,
		sorttype);
        else
                hp->right = addheader(hp->right, num, name, subject, date,
		sorttype);

        return hp;
}


/*
** And Now The List Addition Routines!
*/

void print_list(char *listname, struct hmlist *list)
{
    struct hmlist *tlist;
    int set = 0;

    for (tlist = list; tlist != NULL; tlist = tlist->next) {
        set++;
        printf("%s: %s\n", listname, tlist->val);
    }
    if (!set)
        printf("%s: No Elements\n", listname);
#if 0
    else
        printf("%s: %d Elements\n", listname, set);
#endif
}

/*
** Is the requested element in the list  ?
*/

int inlist(struct hmlist *listname, char *element)
{
    struct hmlist *tlist;

    for (tlist = listname; tlist != NULL; tlist = tlist->next) {
         if (strcasecmp(tlist->val, element) == 0)
              return 1;
    }
    return 0;
}

/*
** Add element to the specified list
*/

struct hmlist *add_2_list(struct hmlist *listname, char *value)
{
    struct hmlist *tnode, *newnode;

    newnode = (struct hmlist *) emalloc(sizeof(struct hmlist));
    newnode->val = strsav(value);
    newnode->next = NULL;

    if (listname == NULL)
        listname = newnode;
    else {
        for (tnode = listname; tnode->next != NULL; tnode = tnode->next);
        tnode->next = newnode;
    }
    return listname;
}

struct hmlist *add_list(struct hmlist *listname, char *value)
{
    register char *cp;
    register char *valp;

    /*
    ** This needs to support lists specified on a single line, such as
    **      inline = image/jpeg image/gif ...
    **      inline = image/jpeg,image/gif ...
    ** as well as lists specified on multiple lines.
    */

    valp = value;
    cp = valp;

    while (*cp) {
         if (*cp == ' ' || *cp == ',') {
             if (*valp != ' ' && *valp != ',') {
                 *cp = '\0';
                 listname = add_2_list(listname, valp);
             }
             valp = cp + 1;
         }
         cp++;
    }

    if (*valp)
        listname = add_2_list(listname, valp);

    return listname;
}
