#ifndef __PROTO_H_
#define __PROTO_H_ 1

/* 
** MIME Decode - base64.c
*/

void base64Decode(char *intext, char *out, int *length);

/*
** Date functions - date.c
*/

int  getnweekday(int mn, int dy, int yr);
void convtoshortdate(char *date, char *shortdate);
void splitshortdate(char *shortdate, int *month, int *day, int *year);
long getyearsecs(char *shortdate);
long convtoyearsecs(char *date);
char *getlocaltime(void);
void gettimezone(void);
void getthisyear(void);
char *getdatestr(long yearsecs);

/*
** domains.c
*/
int valid_root_domain(char *eaddr);


/*
** file.c functions
*/

int isfile(char *path);
void checkdir(char *dir);
char *getfilecontents(char *filename);
char *add_char(char *ptr, char member_char);
char *add_string(char *ptr, char *member_str);
char *dirpath(char *frmptr);

void dump_config(char *mbox, char *label, char *dir, 
                 char *archives, char *about, int overwrite, 
                 int increment, char *defaultindex);
void readconfigs(char *path, char *mbox, char *label, char *dir, 
		 char *archives, char *about, int *overwrite, 
		 int *increment, char *defaultindex);

/*
** hypermail.c functions
*/
void version(void);

/*
** mem.c function
*/
void *emalloc(int);

/*
** parse.c Functions
*/

int  ignorecontent(char *type);
int  inlinecontent(char *type);
int  preferedcontent(char *type);
char *tmpname(char *dir, char *pfx);
char *safe_filename(char *name);
void loadheaders(char *mbox, int use_stdin, int readone, char *dir);
void loadoldheaders(char *dir);
void getname(char *line, char *name, char *email);
char *getmaildate(char *line);
char *getfromdate(char *line);
char *getid(char *line);
char *getsubject(char *line);
char *getreply(char *line);
void crossindex(void);
void crossindexthread1(struct header *hp);
void crossindexthread2(int num);
void fixnextheader(char *dir, int num);
void fixreplyheader(char *dir, int num);
void fixthreadheader(char *dir, int num);

/*
** print.c functions
*/

void progerr(char *errorstr);
void usage(void);
void printcomment(FILE *fp, char *label, char *value);
void printbody(FILE *fp, struct body *bp, char *id, char *subject);
void writearticles( char *dir, char *label, char *about, int overwrite, int startnum);
void printdates(FILE *fp, struct header *hp);
void writedates(char *dir, char *label, char *archives, char *about);
void printthreads(FILE *fp, struct header *hp);
void writethreads(char *dir, char *label, char *archives, char *about);
void printsubjects(FILE *fp, struct header *hp);
void writesubjects(char *dir, char *label, char *archives, char *about);
void printauthors(FILE *fp, struct header *hp);
void writeauthors(char *dir, char *label, char *archives, char *about);
void checkreplies(FILE *fp, int num, int level);
void fprint_menu(FILE *fp, mindex_t idx, char *about, char *archives,
                 char *currentid, char *cursub, int pos);
void fprint_summary(FILE *fp, int first_d, int last_d, int num);
void print_index_header_links(FILE *fp,char *archives,char *about,int called);
void print_index_footer_links(FILE *fp, char *archives, int called);
void printhtml(FILE *fp, char *line);
int  showheader(char *header);

/*
** printfile.c functions
*/

int printfile(FILE *fp, char *format, char *label, char *subject,
              char *dir, char *name, char *email, char *message_id);
void print_main_header(FILE *fp,char *label,char *name,
                       char *email,char *subject);

void print_msg_header(FILE *fp, char *label, char *subject,
                      char *dir, char *name, char *email, char *msgid);
void print_index_header(FILE *fp, char *label, char *dir, char *subject);

void printfooter(FILE *fp, char *htmlfooter, char *label, 
                 char *dir, char *subject);


/*
** string.c functions
*/
char *strsav(char *s);
char *strreplace(char *present, char *new);
void strcpymax(char *dest, char *src, int n);
char *strcasestr(char *haystack, char *needle);
char *stripzone(char *date);
int  numstrchr(char *s, char c);
void zero_out(char *str, int len);
char *getvalue(char *line);
char *getconfvalue(char *line, char *var, char *value);
char *unre(char *subject);
void oneunre(char *inreply, char *subject);
char *rmcr(char *line);
int  isquote(char *line);
char *replace(char *string, char *oldpiece, char *newpiece);
char *replacechar(char *string, char old, char *new);
char *convchars(char *line);
char *unconvchars(char *line);
char *makemailcommand(char *mailcommand, char *email, char *id, char *subject);
char *parseemail(char *input, char *output, int outsize, char *mid, char *msubject);
char *parseurl(char *input, char *output, int outsize);
char *convurls(char *line, char *mailid, char *mailsubject);

/*
** struct.c functions
*/

unsigned hash(char *s);
void addhash(int num, char *date, char *name, char *email, 
             char *msgid, char *subject, char *inreply, 
             char *fromdate, struct body *bp);

int hashreplylookup(char *inreply, char *name, char *subject, int *issubjmatch);
int hashreplynumlookup(char *inreply, int *maybereply);

struct body *hashnumlookup(int num, char *name, char *email, char *subject,
                        char *reply, char *date, char *fromdate, char *msgid);

struct body *addbody(struct body *bp, struct body **lp, char *line, int flags); 

struct reply *addreply(struct reply *rp, int num, int fromnum,
                       char *name, char *subject, int maybereply);
int rmlastlines(struct body *bp);

struct printed *markasprinted(struct printed *pp, int num);
int wasprinted(struct printed *list, int num);
struct header *addheader(struct header *hp, int num, char *name,
                         char *subject, char *date, int sorttype);
struct boundary *bound(struct boundary *bound, char *line);

void print_list(char *listname, struct hmlist *list);
int inlist(struct hmlist *listname, char *element);
struct hmlist *add_2_list(struct hmlist *listname, char *value);
struct hmlist *add_list(struct hmlist *listname, char *value);
/*
** uudecode.c function 
*/

int uudecode(FILE *input,char *iptr,char *output,int *length,char init);

#ifdef lint
int isspace();
int isalpha();
int isalnum();
int isxdigit();
#endif

#endif
