/*                                       W3C Sample Code Library libwww Default Event Manager
                                  DEFAULT EVENT MANAGER
                                             
 */
/*
**      (c) COPYRIGHT MIT 1995.
**      Please first read the full copyright statement in the file COPYRIGH.
*/
/*

   This module provides an event registry and a multi-threaded event loop. An application
   may use this module for:
   
      event loop and registry - Application registers HTEvntrg_register and
      HTEvntrg_unregister and calls HTEventList_loop to dispatch events as they occur.
      
      event registry - Application just registers its own event handlers and chains them
      to HTEvntrg_register and HTEvntrg_unregister. When the application's event loop gets
      activity on a socket, it calls HTEvent_dispatch to handle it.
      
      nothing - Application registers its own event handler uses its own event loop to
      dispatch those events.
      
   This module is implemented by HTEvntrg.c, and it is a part of the W3C Sample Code
   Library.
   
 */
#ifndef HTEVTLST_H
#define HTEVTLST_H

#include "sysdep.h"
#include "HTEvent.h"
#include "HTReq.h"
/*

  Windows Specific Handles
  
 */
#if defined(WWW_WIN_ASYNC) || defined(WWW_WIN_DLL)
extern BOOL HTEventList_winHandle (HTRequest * request);
extern BOOL HTEventList_setWinHandle (HWND window, unsigned long message);
extern HWND HTEventList_getWinHandle (unsigned long * pMessage);
extern LRESULT CALLBACK AsyncWindowProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam
);
#endif
/*

EVENT REGISTRY

   The libwww's event registry binds a socket and operation (FD_READ, FD_WRITE...) to a
   callback function. Event are registered, unregistered, and dispatched.
   
  Register an Event Handler
  
   For a given socket, reqister a request structure, a set of operations, a
   HTEventCallback function, and a priority. For this implementation, we allow only a
   single HTEventCallback function for all operations. and the priority field is ignored.
   
 */
extern HTEvent_registerCallback HTEventList_register;
/*

  Unregister an Event Handler
  
   Remove the registered information for the specified socket for the actions specified in
   ops. if no actions remain after the unregister, the registered info is deleted, and, if
   the socket has been registered for notification, the HTEventCallback will be invoked.
   
 */
extern HTEvent_unregisterCallback HTEventList_unregister;
/*

  Unregister ALL Event Handlers
  
   Unregister all sockets. N.B. we just remove them for our internal data structures: it
   is up to the application to actually close the socket.
   
 */
extern int HTEventList_unregisterAll (void);
/*

  HTEventList_lookup/dispatch
  
   Callbacks can be looked up or dispatched based on the socket and operation
   (read/write/oob)
   
 */
extern int HTEventList_dispatch (SOCKET s, HTEventType type, ms_t now);
extern HTEvent * HTEventList_lookup (SOCKET s, HTEventType type);
/*

HANDLER FOR TIMEOUT ON SOCKETS

   This function sets the timeout for sockets in the select()call and registers a timeout
   function that is called if select times out. This does only works on NON windows
   platforms as we need to poll for the console on windows If tv = NULLthen timeout is
   disabled. Default is no timeout. If always=YESthen the callback is called at all times,
   if NO then only when Library sockets are active. Returns YES if OK else NO.
   
 */
#if 0
typedef int HTEventTimeout (HTRequest *);

extern BOOL HTEventList_registerTimeout (struct timeval *tp, HTRequest * request,
                                     HTEventTimeout *tcbf, BOOL always);
#endif
/*

EVENT LOOP

   The libwww's default event loop dispatches events to the event registry.
   
  Start and Stop the Event Manager
  
 */
extern BOOL HTEventInit (void);
extern BOOL HTEventTerminate (void);
/*

  Start the Event Loop
  
   That is, we wait for activity from one of our registered channels, and dispatch on
   that. Under Windows/NT, we must treat the console and sockets as distinct. That means
   we can't avoid a busy wait, but we do our best.
   
 */
extern int HTEventList_loop (HTRequest * request);
/*

  Stop the Event Loop
  
   Stops the (select based) event loop. The function does not guarantee that all requests
   have terminated. This is for the app to do
   
 */
extern void HTEventList_stopLoop (void);
/*

 */
#endif /* HTEVTLST_H */
/*

   
   ___________________________________
   
                           @(#) $Id: HTEvtLst.html,v 2.4 1997/02/16 18:42:13 frystyk Exp $
                                                                                          
    */
