/* -*-Mode: C;-*-
 * Xdelta - A binary delta library
 * Copyright (C) 1997, 1998  Josh MacDonald
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Josh MacDonald <jmacd@CS.Berkeley.EDU>
 *
 * This file was AUTOMATICALLY GENERATED using:
 *
 * $Id: reposer.el 1.22 Thu, 01 Oct 1998 04:56:35 -0700 jmacd $
 */

#ifndef _XDSER_H_
#define _XDSER_H_

#include "serializeio.h"
/* Init */
gboolean xdser_init (void);

/* Serial Types */

enum _SerialXdType {

  ST_XdeltaChecksum = (1<<(0+SER_LIBRARY_OFFSET_BITS))+3, 
  ST_XdeltaInstruction = (1<<(1+SER_LIBRARY_OFFSET_BITS))+3, 
  ST_XdeltaSourceInfo = (1<<(2+SER_LIBRARY_OFFSET_BITS))+3, 
  ST_XdeltaControl = (1<<(3+SER_LIBRARY_OFFSET_BITS))+3, 
  ST_XdeltaIndex = (1<<(4+SER_LIBRARY_OFFSET_BITS))+3, 
  ST_RsyncIndex = (1<<(5+SER_LIBRARY_OFFSET_BITS))+3, 
  ST_RsyncIndexElt = (1<<(6+SER_LIBRARY_OFFSET_BITS))+3
};

typedef struct _SerialRsyncIndexElt SerialRsyncIndexElt;
typedef struct _SerialRsyncIndex SerialRsyncIndex;
typedef struct _SerialXdeltaIndex SerialXdeltaIndex;
typedef struct _SerialXdeltaControl SerialXdeltaControl;
typedef struct _SerialXdeltaSourceInfo SerialXdeltaSourceInfo;
typedef struct _SerialXdeltaInstruction SerialXdeltaInstruction;
typedef struct _SerialXdeltaChecksum SerialXdeltaChecksum;


struct _SerialXdeltaChecksum {
  guint16 high;
  guint16 low;
};

SerialStatus unserialize_xdeltachecksum (SerialSource *source, SerialXdeltaChecksum**);
SerialStatus serialize_xdeltachecksum (SerialSink *sink, guint16 high, guint16 low);

SerialStatus serialize_xdeltachecksum_obj (SerialSink *sink, SerialXdeltaChecksum* obj);

struct _SerialXdeltaInstruction {
  guint32 offset;
  guint32 length;
  guint8 type;
  guint8 index;
};

SerialStatus unserialize_xdeltainstruction (SerialSource *source, SerialXdeltaInstruction**);
SerialStatus serialize_xdeltainstruction (SerialSink *sink, guint32 offset, guint32 length);

SerialStatus serialize_xdeltainstruction_obj (SerialSink *sink, SerialXdeltaInstruction* obj);

struct _SerialXdeltaSourceInfo {
  guint8 md5[16];
  guint8 real_md5[16];
  guint32 length;
};

SerialStatus unserialize_xdeltasourceinfo (SerialSource *source, SerialXdeltaSourceInfo**);
SerialStatus serialize_xdeltasourceinfo (SerialSink *sink, guint8 md5[16], guint8 real_md5[16], guint32 length);

SerialStatus serialize_xdeltasourceinfo_obj (SerialSink *sink, SerialXdeltaSourceInfo* obj);

struct _SerialXdeltaControl {
  gboolean normalized;
  guint32 data_len;
  SerialXdeltaSourceInfo to_info;
  guint32 source_info_len;
  SerialXdeltaSourceInfo** source_info;
  guint32 inst_len;
  SerialXdeltaInstruction* inst;
  GArray    *inst_array;
  GPtrArray *source_info_array;
};

SerialStatus unserialize_xdeltacontrol (SerialSource *source, SerialXdeltaControl**);
SerialStatus serialize_xdeltacontrol (SerialSink *sink, gboolean normalized, guint32 data_len, SerialXdeltaSourceInfo* to_info, guint32 source_info_len, SerialXdeltaSourceInfo** source_info, guint32 inst_len, SerialXdeltaInstruction* inst);

SerialStatus serialize_xdeltacontrol_obj (SerialSink *sink, SerialXdeltaControl* obj);

struct _SerialXdeltaIndex {
  guint32 file_len;
  guint8 file_md5[16];
  guint32 index_len;
  SerialXdeltaChecksum* index;
};

SerialStatus unserialize_xdeltaindex (SerialSource *source, SerialXdeltaIndex**);
SerialStatus serialize_xdeltaindex (SerialSink *sink, guint32 file_len, guint8 file_md5[16], guint32 index_len, SerialXdeltaChecksum* index);

SerialStatus serialize_xdeltaindex_obj (SerialSink *sink, SerialXdeltaIndex* obj);

struct _SerialRsyncIndex {
  guint32 seg_len;
  guint32 file_len;
  guint8 file_md5[16];
  guint32 index_len;
  SerialRsyncIndexElt* index;
  SerialRsyncIndexElt** table;
  guint table_size;
};

SerialStatus unserialize_rsyncindex (SerialSource *source, SerialRsyncIndex**);
SerialStatus serialize_rsyncindex (SerialSink *sink, guint32 seg_len, guint32 file_len, guint8 file_md5[16], guint32 index_len, SerialRsyncIndexElt* index);

SerialStatus serialize_rsyncindex_obj (SerialSink *sink, SerialRsyncIndex* obj);

struct _SerialRsyncIndexElt {
  guint8 md5[16];
  SerialXdeltaChecksum cksum;
  SerialRsyncIndexElt* next;
  gint match_offset;
};

SerialStatus unserialize_rsyncindexelt (SerialSource *source, SerialRsyncIndexElt**);
SerialStatus serialize_rsyncindexelt (SerialSink *sink, guint8 md5[16], SerialXdeltaChecksum* cksum);

SerialStatus serialize_rsyncindexelt_obj (SerialSink *sink, SerialRsyncIndexElt* obj);


#endif /* _XDSER_H_ */

