/* -*-Mode: C;-*-
 * Xdelta - A binary delta library
 * Copyright (C) 1997, 1998  Josh MacDonald
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Josh MacDonald <jmacd@CS.Berkeley.EDU>
 *
 * This file was AUTOMATICALLY GENERATED using:
 *
 * $Id: reposer.el 1.22 Thu, 01 Oct 1998 04:56:35 -0700 jmacd $
 */

#include "xdser.h"
/* Static decls */

static SerialStatus
unserialize_rsyncindexelt_internal_noalloc (SerialSource *source, SerialRsyncIndexElt* );
static SerialStatus
unserialize_rsyncindexelt_internal (SerialSource *source, SerialRsyncIndexElt** );
static SerialStatus
serialize_rsyncindexelt_internal (SerialSink *sink, guint8 md5[16], SerialXdeltaChecksum* cksum);
static guint
count_rsyncindexelt (guint8 md5[16], SerialXdeltaChecksum* cksum);
static SerialStatus
unserialize_rsyncindex_internal_noalloc (SerialSource *source, SerialRsyncIndex* );
static SerialStatus
unserialize_rsyncindex_internal (SerialSource *source, SerialRsyncIndex** );
static SerialStatus
serialize_rsyncindex_internal (SerialSink *sink, guint32 seg_len, guint32 file_len, guint8 file_md5[16], guint32 index_len, SerialRsyncIndexElt* index);
static guint
count_rsyncindex (guint32 seg_len, guint32 file_len, guint8 file_md5[16], guint32 index_len, SerialRsyncIndexElt* index);
static SerialStatus
unserialize_xdeltaindex_internal_noalloc (SerialSource *source, SerialXdeltaIndex* );
static SerialStatus
unserialize_xdeltaindex_internal (SerialSource *source, SerialXdeltaIndex** );
static SerialStatus
serialize_xdeltaindex_internal (SerialSink *sink, guint32 file_len, guint8 file_md5[16], guint32 index_len, SerialXdeltaChecksum* index);
static guint
count_xdeltaindex (guint32 file_len, guint8 file_md5[16], guint32 index_len, SerialXdeltaChecksum* index);
static SerialStatus
unserialize_xdeltacontrol_internal_noalloc (SerialSource *source, SerialXdeltaControl* );
static SerialStatus
unserialize_xdeltacontrol_internal (SerialSource *source, SerialXdeltaControl** );
static SerialStatus
serialize_xdeltacontrol_internal (SerialSink *sink, gboolean normalized, guint32 data_len, SerialXdeltaSourceInfo* to_info, guint32 source_info_len, SerialXdeltaSourceInfo** source_info, guint32 inst_len, SerialXdeltaInstruction* inst);
static guint
count_xdeltacontrol (gboolean normalized, guint32 data_len, SerialXdeltaSourceInfo* to_info, guint32 source_info_len, SerialXdeltaSourceInfo** source_info, guint32 inst_len, SerialXdeltaInstruction* inst);
static SerialStatus
unserialize_xdeltasourceinfo_internal_noalloc (SerialSource *source, SerialXdeltaSourceInfo* );
static SerialStatus
unserialize_xdeltasourceinfo_internal (SerialSource *source, SerialXdeltaSourceInfo** );
static SerialStatus
serialize_xdeltasourceinfo_internal (SerialSink *sink, guint8 md5[16], guint8 real_md5[16], guint32 length);
static guint
count_xdeltasourceinfo (guint8 md5[16], guint8 real_md5[16], guint32 length);
static SerialStatus
unserialize_xdeltainstruction_internal_noalloc (SerialSource *source, SerialXdeltaInstruction* );
static SerialStatus
unserialize_xdeltainstruction_internal (SerialSource *source, SerialXdeltaInstruction** );
static SerialStatus
serialize_xdeltainstruction_internal (SerialSink *sink, guint32 offset, guint32 length);
static guint
count_xdeltainstruction (guint32 offset, guint32 length);
static SerialStatus
unserialize_xdeltachecksum_internal_noalloc (SerialSource *source, SerialXdeltaChecksum* );
static SerialStatus
unserialize_xdeltachecksum_internal (SerialSource *source, SerialXdeltaChecksum** );
static SerialStatus
serialize_xdeltachecksum_internal (SerialSink *sink, guint16 high, guint16 low);
static guint
count_xdeltachecksum (guint16 high, guint16 low);


/* Init */
gboolean xdser_init (void) {
  serializeio_initialize_type (ST_RsyncIndexElt, &unserialize_rsyncindexelt_internal);
  serializeio_initialize_type (ST_RsyncIndex, &unserialize_rsyncindex_internal);
  serializeio_initialize_type (ST_XdeltaIndex, &unserialize_xdeltaindex_internal);
  serializeio_initialize_type (ST_XdeltaControl, &unserialize_xdeltacontrol_internal);
  serializeio_initialize_type (ST_XdeltaSourceInfo, &unserialize_xdeltasourceinfo_internal);
  serializeio_initialize_type (ST_XdeltaInstruction, &unserialize_xdeltainstruction_internal);
  serializeio_initialize_type (ST_XdeltaChecksum, &unserialize_xdeltachecksum_internal);
  return TRUE;
};

guint
count_xdeltachecksum (guint16 high, guint16 low) {
  guint size = sizeof (SerialXdeltaChecksum);
  ALIGN_8 (size);
  size += sizeof (guint16);
  ALIGN_8 (size);
  size += sizeof (guint16);
  ALIGN_8 (size);
  return size;
}

static SerialStatus
serialize_xdeltachecksum_internal (SerialSink *sink, guint16 high, guint16 low)
{
  sink->status = SerialSuccess;
  if (! (* sink->next_uint16) (sink, high)) goto bail;
  if (! (* sink->next_uint16) (sink, low)) goto bail;
bail:
  return sink->status;
}
SerialStatus
serialize_xdeltachecksum (SerialSink *sink, guint16 high, guint16 low)
{
  sink->status = SerialSuccess;
  if (! (* sink->sink_type) (sink, ST_XdeltaChecksum, count_xdeltachecksum (high, low))) { sink->status = SerialIncorrectType; goto bail; }
  if (serialize_xdeltachecksum_internal (sink, high, low) != SerialSuccess) goto bail;
  return (* sink->sink_quantum) (sink);
bail:
  return sink->status;
}

SerialStatus
serialize_xdeltachecksum_obj (SerialSink *sink, SerialXdeltaChecksum* obj) {

  return serialize_xdeltachecksum (sink, obj->high, obj->low);
}
SerialStatus
unserialize_xdeltachecksum_internal_noalloc (SerialSource *source, SerialXdeltaChecksum* result)
{
  source->status = SerialSuccess;
  if (! (* source->next_uint16) (source, &result->high)) goto bail;
  if (! (* source->next_uint16) (source, &result->low)) goto bail;
bail:
  return source->status;
}

SerialStatus
unserialize_xdeltachecksum_internal (SerialSource *source, SerialXdeltaChecksum** result)
{
  SerialXdeltaChecksum* unser;
  (*result) = NULL;
  source->status = SerialSuccess;
  unser = (* source->source_alloc) (source, sizeof (SerialXdeltaChecksum));
  if (! unser) goto bail;
  if (unserialize_xdeltachecksum_internal_noalloc (source, unser) != SerialSuccess) goto bail;
  (*result) = unser;
bail:
  return source->status;
}

SerialStatus
unserialize_xdeltachecksum (SerialSource *source, SerialXdeltaChecksum** result)
{
  source->status = SerialSuccess;
  if ( (* source->source_type) (source) != ST_XdeltaChecksum) { source->status = SerialIncorrectType; goto bail; }
  if (unserialize_xdeltachecksum_internal (source, result) != SerialSuccess) goto bail;
  source->alloc = NULL;
  (* source->source_reset) (source);
bail:
  return source->status;
}

guint
count_xdeltainstruction (guint32 offset, guint32 length) {
  guint size = sizeof (SerialXdeltaInstruction);
  ALIGN_8 (size);
  size += sizeof (guint32);
  ALIGN_8 (size);
  size += sizeof (guint32);
  ALIGN_8 (size);
  return size;
}

static SerialStatus
serialize_xdeltainstruction_internal (SerialSink *sink, guint32 offset, guint32 length)
{
  sink->status = SerialSuccess;
  if (! (* sink->next_uint) (sink, offset)) goto bail;
  if (! (* sink->next_uint) (sink, length)) goto bail;
bail:
  return sink->status;
}
SerialStatus
serialize_xdeltainstruction (SerialSink *sink, guint32 offset, guint32 length)
{
  sink->status = SerialSuccess;
  if (! (* sink->sink_type) (sink, ST_XdeltaInstruction, count_xdeltainstruction (offset, length))) { sink->status = SerialIncorrectType; goto bail; }
  if (serialize_xdeltainstruction_internal (sink, offset, length) != SerialSuccess) goto bail;
  return (* sink->sink_quantum) (sink);
bail:
  return sink->status;
}

SerialStatus
serialize_xdeltainstruction_obj (SerialSink *sink, SerialXdeltaInstruction* obj) {

  return serialize_xdeltainstruction (sink, obj->offset, obj->length);
}
SerialStatus
unserialize_xdeltainstruction_internal_noalloc (SerialSource *source, SerialXdeltaInstruction* result)
{
  source->status = SerialSuccess;
  if (! (* source->next_uint) (source, &result->offset)) goto bail;
  if (! (* source->next_uint) (source, &result->length)) goto bail;
bail:
  return source->status;
}

SerialStatus
unserialize_xdeltainstruction_internal (SerialSource *source, SerialXdeltaInstruction** result)
{
  SerialXdeltaInstruction* unser;
  (*result) = NULL;
  source->status = SerialSuccess;
  unser = (* source->source_alloc) (source, sizeof (SerialXdeltaInstruction));
  if (! unser) goto bail;
  if (unserialize_xdeltainstruction_internal_noalloc (source, unser) != SerialSuccess) goto bail;
  (*result) = unser;
bail:
  return source->status;
}

SerialStatus
unserialize_xdeltainstruction (SerialSource *source, SerialXdeltaInstruction** result)
{
  source->status = SerialSuccess;
  if ( (* source->source_type) (source) != ST_XdeltaInstruction) { source->status = SerialIncorrectType; goto bail; }
  if (unserialize_xdeltainstruction_internal (source, result) != SerialSuccess) goto bail;
  source->alloc = NULL;
  (* source->source_reset) (source);
bail:
  return source->status;
}

guint
count_xdeltasourceinfo (guint8 md5[16], guint8 real_md5[16], guint32 length) {
  guint size = sizeof (SerialXdeltaSourceInfo);
  ALIGN_8 (size);
  size += 0;
  ALIGN_8 (size);
  size += 0;
  ALIGN_8 (size);
  size += sizeof (guint32);
  ALIGN_8 (size);
  return size;
}

static SerialStatus
serialize_xdeltasourceinfo_internal (SerialSink *sink, guint8 md5[16], guint8 real_md5[16], guint32 length)
{
  sink->status = SerialSuccess;
  if (! (* sink->next_bytes_known) (sink, md5, 16)) goto bail;
  if (! (* sink->next_bytes_known) (sink, real_md5, 16)) goto bail;
  if (! (* sink->next_uint) (sink, length)) goto bail;
bail:
  return sink->status;
}
SerialStatus
serialize_xdeltasourceinfo (SerialSink *sink, guint8 md5[16], guint8 real_md5[16], guint32 length)
{
  sink->status = SerialSuccess;
  if (! (* sink->sink_type) (sink, ST_XdeltaSourceInfo, count_xdeltasourceinfo (md5, real_md5, length))) { sink->status = SerialIncorrectType; goto bail; }
  if (serialize_xdeltasourceinfo_internal (sink, md5, real_md5, length) != SerialSuccess) goto bail;
  return (* sink->sink_quantum) (sink);
bail:
  return sink->status;
}

SerialStatus
serialize_xdeltasourceinfo_obj (SerialSink *sink, SerialXdeltaSourceInfo* obj) {

  return serialize_xdeltasourceinfo (sink, obj->md5, obj->real_md5, obj->length);
}
SerialStatus
unserialize_xdeltasourceinfo_internal_noalloc (SerialSource *source, SerialXdeltaSourceInfo* result)
{
  source->status = SerialSuccess;
  if (! (* source->next_bytes_known) (source, result->md5, 16)) goto bail;
  if (! (* source->next_bytes_known) (source, result->real_md5, 16)) goto bail;
  if (! (* source->next_uint) (source, &result->length)) goto bail;
bail:
  return source->status;
}

SerialStatus
unserialize_xdeltasourceinfo_internal (SerialSource *source, SerialXdeltaSourceInfo** result)
{
  SerialXdeltaSourceInfo* unser;
  (*result) = NULL;
  source->status = SerialSuccess;
  unser = (* source->source_alloc) (source, sizeof (SerialXdeltaSourceInfo));
  if (! unser) goto bail;
  if (unserialize_xdeltasourceinfo_internal_noalloc (source, unser) != SerialSuccess) goto bail;
  (*result) = unser;
bail:
  return source->status;
}

SerialStatus
unserialize_xdeltasourceinfo (SerialSource *source, SerialXdeltaSourceInfo** result)
{
  source->status = SerialSuccess;
  if ( (* source->source_type) (source) != ST_XdeltaSourceInfo) { source->status = SerialIncorrectType; goto bail; }
  if (unserialize_xdeltasourceinfo_internal (source, result) != SerialSuccess) goto bail;
  source->alloc = NULL;
  (* source->source_reset) (source);
bail:
  return source->status;
}

guint
count_xdeltacontrol (gboolean normalized, guint32 data_len, SerialXdeltaSourceInfo* to_info, guint32 source_info_len, SerialXdeltaSourceInfo** source_info, guint32 inst_len, SerialXdeltaInstruction* inst) {
  guint size = sizeof (SerialXdeltaControl);
  ALIGN_8 (size);
  size += 1;
  ALIGN_8 (size);
  size += sizeof (guint32);
  ALIGN_8 (size);
  size += count_xdeltasourceinfo (to_info->md5, to_info->real_md5, to_info->length) - sizeof (SerialXdeltaSourceInfo);
  ALIGN_8 (size);
  {
    gint i;
    for (i = 0; i < source_info_len; i += 1)
      {
        size += count_xdeltasourceinfo ((source_info[i])->md5, (source_info[i])->real_md5, (source_info[i])->length);
      }
  }
  ALIGN_8 (size);
  {
    gint i;
    for (i = 0; i < inst_len; i += 1)
      {
        size += count_xdeltainstruction ((&inst[i])->offset, (&inst[i])->length) - sizeof (SerialXdeltaInstruction);
      }
  }
  ALIGN_8 (size);
  return size;
}

static SerialStatus
serialize_xdeltacontrol_internal (SerialSink *sink, gboolean normalized, guint32 data_len, SerialXdeltaSourceInfo* to_info, guint32 source_info_len, SerialXdeltaSourceInfo** source_info, guint32 inst_len, SerialXdeltaInstruction* inst)
{
  sink->status = SerialSuccess;
  if (! (* sink->next_bool) (sink, normalized)) goto bail;
  if (! (* sink->next_uint) (sink, data_len)) goto bail;
  if (serialize_xdeltasourceinfo_internal (sink, to_info->md5, to_info->real_md5, to_info->length) != SerialSuccess) goto bail;
  {
    gint i;
    if (! (* sink->next_uint) (sink, source_info_len)) goto bail;
    for (i = 0; i < source_info_len; i += 1)
      {
        if (serialize_xdeltasourceinfo_internal (sink, (source_info[i])->md5, (source_info[i])->real_md5, (source_info[i])->length) != SerialSuccess) goto bail;
      }
  }
  {
    gint i;
    if (! (* sink->next_uint) (sink, inst_len)) goto bail;
    for (i = 0; i < inst_len; i += 1)
      {
        if (serialize_xdeltainstruction_internal (sink, (&inst[i])->offset, (&inst[i])->length) != SerialSuccess) goto bail;
      }
  }
bail:
  return sink->status;
}
SerialStatus
serialize_xdeltacontrol (SerialSink *sink, gboolean normalized, guint32 data_len, SerialXdeltaSourceInfo* to_info, guint32 source_info_len, SerialXdeltaSourceInfo** source_info, guint32 inst_len, SerialXdeltaInstruction* inst)
{
  sink->status = SerialSuccess;
  if (! (* sink->sink_type) (sink, ST_XdeltaControl, count_xdeltacontrol (normalized, data_len, to_info, source_info_len, source_info, inst_len, inst))) { sink->status = SerialIncorrectType; goto bail; }
  if (serialize_xdeltacontrol_internal (sink, normalized, data_len, to_info, source_info_len, source_info, inst_len, inst) != SerialSuccess) goto bail;
  return (* sink->sink_quantum) (sink);
bail:
  return sink->status;
}

SerialStatus
serialize_xdeltacontrol_obj (SerialSink *sink, SerialXdeltaControl* obj) {

  return serialize_xdeltacontrol (sink, obj->normalized, obj->data_len, &obj->to_info, obj->source_info_len, obj->source_info, obj->inst_len, obj->inst);
}
SerialStatus
unserialize_xdeltacontrol_internal_noalloc (SerialSource *source, SerialXdeltaControl* result)
{
  source->status = SerialSuccess;
  if (! (* source->next_bool) (source, &result->normalized)) goto bail;
  if (! (* source->next_uint) (source, &result->data_len)) goto bail;
  if (unserialize_xdeltasourceinfo_internal_noalloc (source, &result->to_info) != SerialSuccess) goto bail;
  {
    gint i;
    if (! (* source->next_uint) (source, &result->source_info_len)) goto bail;
    if (! (result->source_info = (* source->source_alloc) (source, sizeof (SerialXdeltaSourceInfo*) * result->source_info_len))) goto bail;
    for (i = 0; i < result->source_info_len; i += 1)
      {
        if (unserialize_xdeltasourceinfo_internal (source, &(result->source_info[i])) != SerialSuccess) goto bail;
      }
  }
  {
    gint i;
    if (! (* source->next_uint) (source, &result->inst_len)) goto bail;
    if (! (result->inst = (* source->source_alloc) (source, sizeof (SerialXdeltaInstruction) * result->inst_len))) goto bail;
    for (i = 0; i < result->inst_len; i += 1)
      {
        if (unserialize_xdeltainstruction_internal_noalloc (source, &(result->inst[i])) != SerialSuccess) goto bail;
      }
  }
bail:
  return source->status;
}

SerialStatus
unserialize_xdeltacontrol_internal (SerialSource *source, SerialXdeltaControl** result)
{
  SerialXdeltaControl* unser;
  (*result) = NULL;
  source->status = SerialSuccess;
  unser = (* source->source_alloc) (source, sizeof (SerialXdeltaControl));
  if (! unser) goto bail;
  if (unserialize_xdeltacontrol_internal_noalloc (source, unser) != SerialSuccess) goto bail;
  (*result) = unser;
bail:
  return source->status;
}

SerialStatus
unserialize_xdeltacontrol (SerialSource *source, SerialXdeltaControl** result)
{
  source->status = SerialSuccess;
  if ( (* source->source_type) (source) != ST_XdeltaControl) { source->status = SerialIncorrectType; goto bail; }
  if (unserialize_xdeltacontrol_internal (source, result) != SerialSuccess) goto bail;
  source->alloc = NULL;
  (* source->source_reset) (source);
bail:
  return source->status;
}

guint
count_xdeltaindex (guint32 file_len, guint8 file_md5[16], guint32 index_len, SerialXdeltaChecksum* index) {
  guint size = sizeof (SerialXdeltaIndex);
  ALIGN_8 (size);
  size += sizeof (guint32);
  ALIGN_8 (size);
  size += 0;
  ALIGN_8 (size);
  {
    gint i;
    for (i = 0; i < index_len; i += 1)
      {
        size += count_xdeltachecksum ((&index[i])->high, (&index[i])->low) - sizeof (SerialXdeltaChecksum);
      }
  }
  ALIGN_8 (size);
  return size;
}

static SerialStatus
serialize_xdeltaindex_internal (SerialSink *sink, guint32 file_len, guint8 file_md5[16], guint32 index_len, SerialXdeltaChecksum* index)
{
  sink->status = SerialSuccess;
  if (! (* sink->next_uint) (sink, file_len)) goto bail;
  if (! (* sink->next_bytes_known) (sink, file_md5, 16)) goto bail;
  {
    gint i;
    if (! (* sink->next_uint) (sink, index_len)) goto bail;
    for (i = 0; i < index_len; i += 1)
      {
        if (serialize_xdeltachecksum_internal (sink, (&index[i])->high, (&index[i])->low) != SerialSuccess) goto bail;
      }
  }
bail:
  return sink->status;
}
SerialStatus
serialize_xdeltaindex (SerialSink *sink, guint32 file_len, guint8 file_md5[16], guint32 index_len, SerialXdeltaChecksum* index)
{
  sink->status = SerialSuccess;
  if (! (* sink->sink_type) (sink, ST_XdeltaIndex, count_xdeltaindex (file_len, file_md5, index_len, index))) { sink->status = SerialIncorrectType; goto bail; }
  if (serialize_xdeltaindex_internal (sink, file_len, file_md5, index_len, index) != SerialSuccess) goto bail;
  return (* sink->sink_quantum) (sink);
bail:
  return sink->status;
}

SerialStatus
serialize_xdeltaindex_obj (SerialSink *sink, SerialXdeltaIndex* obj) {

  return serialize_xdeltaindex (sink, obj->file_len, obj->file_md5, obj->index_len, obj->index);
}
SerialStatus
unserialize_xdeltaindex_internal_noalloc (SerialSource *source, SerialXdeltaIndex* result)
{
  source->status = SerialSuccess;
  if (! (* source->next_uint) (source, &result->file_len)) goto bail;
  if (! (* source->next_bytes_known) (source, result->file_md5, 16)) goto bail;
  {
    gint i;
    if (! (* source->next_uint) (source, &result->index_len)) goto bail;
    if (! (result->index = (* source->source_alloc) (source, sizeof (SerialXdeltaChecksum) * result->index_len))) goto bail;
    for (i = 0; i < result->index_len; i += 1)
      {
        if (unserialize_xdeltachecksum_internal_noalloc (source, &(result->index[i])) != SerialSuccess) goto bail;
      }
  }
bail:
  return source->status;
}

SerialStatus
unserialize_xdeltaindex_internal (SerialSource *source, SerialXdeltaIndex** result)
{
  SerialXdeltaIndex* unser;
  (*result) = NULL;
  source->status = SerialSuccess;
  unser = (* source->source_alloc) (source, sizeof (SerialXdeltaIndex));
  if (! unser) goto bail;
  if (unserialize_xdeltaindex_internal_noalloc (source, unser) != SerialSuccess) goto bail;
  (*result) = unser;
bail:
  return source->status;
}

SerialStatus
unserialize_xdeltaindex (SerialSource *source, SerialXdeltaIndex** result)
{
  source->status = SerialSuccess;
  if ( (* source->source_type) (source) != ST_XdeltaIndex) { source->status = SerialIncorrectType; goto bail; }
  if (unserialize_xdeltaindex_internal (source, result) != SerialSuccess) goto bail;
  source->alloc = NULL;
  (* source->source_reset) (source);
bail:
  return source->status;
}

guint
count_rsyncindex (guint32 seg_len, guint32 file_len, guint8 file_md5[16], guint32 index_len, SerialRsyncIndexElt* index) {
  guint size = sizeof (SerialRsyncIndex);
  ALIGN_8 (size);
  size += sizeof (guint32);
  ALIGN_8 (size);
  size += sizeof (guint32);
  ALIGN_8 (size);
  size += 0;
  ALIGN_8 (size);
  {
    gint i;
    for (i = 0; i < index_len; i += 1)
      {
        size += count_rsyncindexelt ((&index[i])->md5, &(&index[i])->cksum) - sizeof (SerialRsyncIndexElt);
      }
  }
  ALIGN_8 (size);
  return size;
}

static SerialStatus
serialize_rsyncindex_internal (SerialSink *sink, guint32 seg_len, guint32 file_len, guint8 file_md5[16], guint32 index_len, SerialRsyncIndexElt* index)
{
  sink->status = SerialSuccess;
  if (! (* sink->next_uint) (sink, seg_len)) goto bail;
  if (! (* sink->next_uint) (sink, file_len)) goto bail;
  if (! (* sink->next_bytes_known) (sink, file_md5, 16)) goto bail;
  {
    gint i;
    if (! (* sink->next_uint) (sink, index_len)) goto bail;
    for (i = 0; i < index_len; i += 1)
      {
        if (serialize_rsyncindexelt_internal (sink, (&index[i])->md5, &(&index[i])->cksum) != SerialSuccess) goto bail;
      }
  }
bail:
  return sink->status;
}
SerialStatus
serialize_rsyncindex (SerialSink *sink, guint32 seg_len, guint32 file_len, guint8 file_md5[16], guint32 index_len, SerialRsyncIndexElt* index)
{
  sink->status = SerialSuccess;
  if (! (* sink->sink_type) (sink, ST_RsyncIndex, count_rsyncindex (seg_len, file_len, file_md5, index_len, index))) { sink->status = SerialIncorrectType; goto bail; }
  if (serialize_rsyncindex_internal (sink, seg_len, file_len, file_md5, index_len, index) != SerialSuccess) goto bail;
  return (* sink->sink_quantum) (sink);
bail:
  return sink->status;
}

SerialStatus
serialize_rsyncindex_obj (SerialSink *sink, SerialRsyncIndex* obj) {

  return serialize_rsyncindex (sink, obj->seg_len, obj->file_len, obj->file_md5, obj->index_len, obj->index);
}
SerialStatus
unserialize_rsyncindex_internal_noalloc (SerialSource *source, SerialRsyncIndex* result)
{
  source->status = SerialSuccess;
  if (! (* source->next_uint) (source, &result->seg_len)) goto bail;
  if (! (* source->next_uint) (source, &result->file_len)) goto bail;
  if (! (* source->next_bytes_known) (source, result->file_md5, 16)) goto bail;
  {
    gint i;
    if (! (* source->next_uint) (source, &result->index_len)) goto bail;
    if (! (result->index = (* source->source_alloc) (source, sizeof (SerialRsyncIndexElt) * result->index_len))) goto bail;
    for (i = 0; i < result->index_len; i += 1)
      {
        if (unserialize_rsyncindexelt_internal_noalloc (source, &(result->index[i])) != SerialSuccess) goto bail;
      }
  }
bail:
  return source->status;
}

SerialStatus
unserialize_rsyncindex_internal (SerialSource *source, SerialRsyncIndex** result)
{
  SerialRsyncIndex* unser;
  (*result) = NULL;
  source->status = SerialSuccess;
  unser = (* source->source_alloc) (source, sizeof (SerialRsyncIndex));
  if (! unser) goto bail;
  if (unserialize_rsyncindex_internal_noalloc (source, unser) != SerialSuccess) goto bail;
  (*result) = unser;
bail:
  return source->status;
}

SerialStatus
unserialize_rsyncindex (SerialSource *source, SerialRsyncIndex** result)
{
  source->status = SerialSuccess;
  if ( (* source->source_type) (source) != ST_RsyncIndex) { source->status = SerialIncorrectType; goto bail; }
  if (unserialize_rsyncindex_internal (source, result) != SerialSuccess) goto bail;
  source->alloc = NULL;
  (* source->source_reset) (source);
bail:
  return source->status;
}

guint
count_rsyncindexelt (guint8 md5[16], SerialXdeltaChecksum* cksum) {
  guint size = sizeof (SerialRsyncIndexElt);
  ALIGN_8 (size);
  size += 0;
  ALIGN_8 (size);
  size += count_xdeltachecksum (cksum->high, cksum->low) - sizeof (SerialXdeltaChecksum);
  ALIGN_8 (size);
  return size;
}

static SerialStatus
serialize_rsyncindexelt_internal (SerialSink *sink, guint8 md5[16], SerialXdeltaChecksum* cksum)
{
  sink->status = SerialSuccess;
  if (! (* sink->next_bytes_known) (sink, md5, 16)) goto bail;
  if (serialize_xdeltachecksum_internal (sink, cksum->high, cksum->low) != SerialSuccess) goto bail;
bail:
  return sink->status;
}
SerialStatus
serialize_rsyncindexelt (SerialSink *sink, guint8 md5[16], SerialXdeltaChecksum* cksum)
{
  sink->status = SerialSuccess;
  if (! (* sink->sink_type) (sink, ST_RsyncIndexElt, count_rsyncindexelt (md5, cksum))) { sink->status = SerialIncorrectType; goto bail; }
  if (serialize_rsyncindexelt_internal (sink, md5, cksum) != SerialSuccess) goto bail;
  return (* sink->sink_quantum) (sink);
bail:
  return sink->status;
}

SerialStatus
serialize_rsyncindexelt_obj (SerialSink *sink, SerialRsyncIndexElt* obj) {

  return serialize_rsyncindexelt (sink, obj->md5, &obj->cksum);
}
SerialStatus
unserialize_rsyncindexelt_internal_noalloc (SerialSource *source, SerialRsyncIndexElt* result)
{
  source->status = SerialSuccess;
  if (! (* source->next_bytes_known) (source, result->md5, 16)) goto bail;
  if (unserialize_xdeltachecksum_internal_noalloc (source, &result->cksum) != SerialSuccess) goto bail;
bail:
  return source->status;
}

SerialStatus
unserialize_rsyncindexelt_internal (SerialSource *source, SerialRsyncIndexElt** result)
{
  SerialRsyncIndexElt* unser;
  (*result) = NULL;
  source->status = SerialSuccess;
  unser = (* source->source_alloc) (source, sizeof (SerialRsyncIndexElt));
  if (! unser) goto bail;
  if (unserialize_rsyncindexelt_internal_noalloc (source, unser) != SerialSuccess) goto bail;
  (*result) = unser;
bail:
  return source->status;
}

SerialStatus
unserialize_rsyncindexelt (SerialSource *source, SerialRsyncIndexElt** result)
{
  source->status = SerialSuccess;
  if ( (* source->source_type) (source) != ST_RsyncIndexElt) { source->status = SerialIncorrectType; goto bail; }
  if (unserialize_rsyncindexelt_internal (source, result) != SerialSuccess) goto bail;
  source->alloc = NULL;
  (* source->source_reset) (source);
bail:
  return source->status;
}

