/* -*- Mode: C;-*-
 *
 * This file is part of XDelta - A binary delta generator.
 *
 * Copyright (C) 1997, 1998  Josh MacDonald
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Josh MacDonald <jmacd@CS.Berkeley.EDU>
 *
 * xdeltapriv.h,v 1.9 1998/10/03 02:32:09 jmacd Exp
 */

#ifndef _XDELTAPRIV_H_
#define _XDELTAPRIV_H_

#if 0
#define CLOBBER_ALGORITHM_C
#define DEBUG_MD5
#define DEBUG_CONT
#define DEBUG_INST
#define DEBUG_COPY
#define DEBUG_FIND
#define DEBUG_HASH
#define DEBUG_CKSUM
#endif

typedef struct _XdeltaPos         XdeltaPos;
typedef struct _RsyncHash         RsyncHash;

#define XPOS(p) (((p).page * (p).page_size) + (p).off)

struct _XdeltaPos {
  guint page;
  guint page_size;
  guint off;

  const guint8* mem;
  guint mem_page;
  guint mem_rem;
};

#define handle_length       (* gen->handle_table.table_handle_length)
#define handle_pages        (* gen->handle_table.table_handle_pages)
#define handle_pagesize     (* gen->handle_table.table_handle_pagesize)
#define handle_map_page     (* gen->handle_table.table_handle_map_page)
#define handle_unmap_page   (* gen->handle_table.table_handle_unmap_page)
#define handle_checksum_md5 (* gen->handle_table.table_handle_checksum_md5)
#define handle_close        (* gen->handle_table.table_handle_close)
#define handle_write        (* gen->handle_table.table_handle_write)
#define handle_copy         (* gen->handle_table.table_handle_copy)

#define md5_ctx             (  (void*) gen->gen_md5_ctx)
#define md5_init            (* gen->md5_table.table_md5_init)
#define md5_update          (* gen->md5_table.table_md5_update)
#define md5_final           (* gen->md5_table.table_md5_final)

struct _XdeltaGenerator
{
  GPtrArray *sources;

  gint       xdp_errno;

  const guint32 *table;
  guint          table_size;

  guint          to_output_pos;
  gboolean       normalize;

  XdeltaOutStream  *data_out;
  XdeltaOutStream  *control_out;

  XdeltaControl    *control;

#ifdef DEBUG_HASH
  gint hash_conflicts;           /* bucket already used. */
  gint hash_real_conflicts;      /* bucket had different checksum. */
  gint hash_real_real_conflicts; /* bucket had same checksum, different region */
  gint hash_fill;
  gint hash_entries;
#endif

  HandleFuncTable   handle_table;
  XdeltaMD5Table    md5_table;

  gchar                gen_md5_ctx[1]; /* it allocates this off the end of the struct. */
};

struct _XdeltaSource
{
  XdeltaControl   *delta_control_in;
  XdeltaStream    *source_in;
  XdeltaPos        source_pos;

  gint                   ck_count; /* number of elts in cksums. */
  const XdeltaChecksum  *cksums;   /* array of cksums. */

  gint flags;

  XdeltaStream    *index_in;
  XdeltaOutStream *index_out;

  gint             source_index;
  gboolean         used;
};

#endif /* _XDELTAPRIV_H_ */
