/*
    ras - Redundant Archive System
    Copyright (C) 1998  Nick Cleaton

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Nick Cleaton <nc@dial.pipex.com>
*/
/*

common.h

header to be included by all ras modules

*/

#define PROGNAME "ras"
#define PROGVERSION "1.01"


#define MAX_SEGS_AND_SUMS 256
/*  The upper limit on the total of the number of segments in the archive
    and the number of distinct sumfiles that can be generated. See field.c
    for why this limit exists.
*/

#define MAX_SEGMENT_COUNT (MAX_SEGS_AND_SUMS-1)
/*  An upper limit on the number of segments in the archive, assuming at
    least one sumfile is to be generated.
*/

typedef unsigned char uchar;


