
/*

  Dedicated to Evelyn Reimann, the most wonderful girl I ever met.
  
 */

/* Greater parts of this piece of code comes from the gdk_imlib, load.c, I think */
/* Some parts are rewritten to handle aninmated gifs*/

#include "pics.h"

void cja_LoadGIF(char *f, int *w, int *h, int *t)
{
   unsigned char      *ptr;
   GifFileType        *gif;
   GifRowType         *rows;
   GifRecordType       rec;
   ColorMapObject     *cmap;
   int                 i, j, bg, csize, r, g, b;
   int                 intoffset[] ={0, 4, 2, 1};
   int                 intjump[] ={8, 8, 4, 2};
   int                 ext_code;
   GifByteType        *ext;
   int                 istransp, transp;
   int picnum=0;

   istransp = 0;
   gif = DGifOpenFileName(f);
   transp = -1;
   for(i=0;i<100;i++) data[i] = NULL;
   rows = NULL;

   if (!gif)
      return;

   do
     {

       do
	 {
	   if (DGifGetRecordType(gif, &rec) == GIF_ERROR)
	     {
	       PrintGifError();
	       rec = TERMINATE_RECORD_TYPE;
	     }
	   
	   if (rec == IMAGE_DESC_RECORD_TYPE)
	     {
	       
	       if (DGifGetImageDesc(gif) == GIF_ERROR)
		 {
		   PrintGifError();
		   rec = TERMINATE_RECORD_TYPE;
		 }
	       
	       *w = gif->Image.Width;
	       *h = gif->Image.Height;
	       rows = malloc(*h * sizeof(GifRowType *));
	       if (!rows)
		 {
		   DGifCloseFile(gif);
		   return;
		 }
	       data[picnum] = malloc(*w ** h * 3);
	       if (!data)
		 {
		   DGifCloseFile(gif);
		   free(rows);
		   return;
		 }
	       for (i = 0; i < *h; i++)
		 rows[i] = NULL;
	       for (i = 0; i < *h; i++)
		 {
		   rows[i] = malloc(*w * sizeof(GifPixelType));
		   if (!rows[i])
		     {
		       DGifCloseFile(gif);
		       for (i = 0; i < *h; i++)
			 if (rows[i])
			   free(rows[i]);
		       free(rows);
		       free(data);
		       return;
		     }
		 }
	       if (gif->Image.Interlace)
		 {
		   for (i = 0; i < 4; i++)
		     {
		       for (j = intoffset[i]; j < *h; j += intjump[i])
			 DGifGetLine(gif, rows[j], *w);
		     }
		 }
	       else
		 {
		   for (i = 0; i < *h; i++)
		     DGifGetLine(gif, rows[i], *w);
		 }
	       
	       bg = gif->SBackGroundColor;
	       cmap = (gif->Image.ColorMap ? gif->Image.ColorMap : gif->SColorMap);
	       csize = cmap->ColorCount;
	       ptr = data[picnum];
	       
	       
	       if (!istransp)
		 {
		   for (i = 0; i < *h; i++)
		     {
		       for (j = 0; j < *w; j++)
			 {
			   r = cmap->Colors[rows[i][j]].Red;
			   g = cmap->Colors[rows[i][j]].Green;
			   b = cmap->Colors[rows[i][j]].Blue;
			   *ptr++ = r;
			   *ptr++ = g;
			   *ptr++ = b;
			 }
		     }
		 }
	       else
		 {
		   for (i = 0; i < *h; i++)
		     {
		       for (j = 0; j < *w; j++)
			 {
			   if (rows[i][j] == transp)
			     {
			       *ptr++ = 255;
			       *ptr++ = 0;
			       *ptr++ = 255;
			     }
			   else
			     {
			       r = cmap->Colors[rows[i][j]].Red;
			       g = cmap->Colors[rows[i][j]].Green;
			       b = cmap->Colors[rows[i][j]].Blue;
			       if (r == 255 && g == 0 && b == 255)
				 r = 254;
			       *ptr++ = r;
			       *ptr++ = g;
			       *ptr++ = b;
			     }
			 }
		     }
		 }
	       
	       
	       for (i = 0; i < *h; i++)
		 free(rows[i]);
	       free(rows);
	       
	       picnum++;
	     }
	   else if (rec == EXTENSION_RECORD_TYPE)
	     {
	       
	       ext = NULL;
	       DGifGetExtension(gif, &ext_code, &ext);
	       if (ext)
		 {
		   if ((ext[1] & 1) && (transp < 0))
		     {
		       istransp = 1;
		       transp = (int)((unsigned char)ext[4]);
		     }
		 }
	       do
		 {
		   ext = NULL; 
		   DGifGetExtensionNext(gif, &ext);
		 }
	       while (ext);
	     }
	 }
       while (rec != TERMINATE_RECORD_TYPE && rec !=IMAGE_DESC_RECORD_TYPE);
     }
   while (rec !=  TERMINATE_RECORD_TYPE);

   DGifCloseFile(gif);
   *t = istransp;
   numofpics=picnum;
}


void cja_load_image(char *file)
{
   int                 w, h;
   int                 trans;
   int                 i;

   for(i=0;i<MAX_PICTURES;i++) data[i] = NULL;
  
   trans = 0;

   cja_LoadGIF(file, &w, &h, &trans);	     
     
   if(data[0]==NULL) printf("Something went wrong.\n");

   for(i=0;i<numofpics;i++)
     {
       im[i] = (GdkImlibImage *) malloc(sizeof(GdkImlibImage));
       if (!im[i])
	 {
	   fprintf(stderr, "ERROR: Cannot allocate RAM for image data\n");
	   if (data[i])
	     free(data[i]);
	   return;
	 }
       im[i]->alpha_data = NULL;
       if (trans)
	 {
	   im[i]->shape_color.r = 255;
	   im[i]->shape_color.g = 0;
	   im[i]->shape_color.b = 255;
	 }
       else
	 {
	   im[i]->shape_color.r = -1;
	   im[i]->shape_color.g = -1;
	   im[i]->shape_color.b = -1;
	 }
       im[i]->border.left = 0;
       im[i]->border.right = 0;
       im[i]->border.top = 0;
       im[i]->border.bottom = 0;
       im[i]->cache = 1;
       im[i]->rgb_data = data[i];
       im[i]->rgb_width = w;
       im[i]->rgb_height = h;
       im[i]->pixmap = NULL;
       im[i]->shape_mask = NULL;

       im[i]->mod.gamma = id->mod.gamma;
       im[i]->mod.brightness = id->mod.brightness;
       im[i]->mod.contrast = id->mod.contrast;
       im[i]->rmod.gamma = id->rmod.gamma;
       im[i]->rmod.brightness = id->rmod.brightness;
       im[i]->rmod.contrast = id->rmod.contrast;
       im[i]->gmod.gamma = id->gmod.gamma;
       im[i]->gmod.brightness = id->gmod.brightness;
       im[i]->gmod.contrast = id->gmod.contrast;
       im[i]->bmod.gamma = id->bmod.gamma;
       im[i]->bmod.brightness = id->bmod.brightness;
       im[i]->bmod.contrast = id->bmod.contrast;
       im[i]->filename = malloc(strlen(file) + 1);
       if (im[i]->filename)
	 strcpy(im[i]->filename, file);
       if ((id->cache.on_image && im[i]))
	 gadd_image(im[i], file);
       gcalc_map_tables(im[i]);
     }
}
