/*
 *      Copyright (C) 1997 Claus-Justus Heine

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *
 * $Source: /homes/cvs/ftape/ftape-tools/src/vtblc/vtblc.h,v $
 * $Revision: 1.2 $
 * $Date: 1998/05/21 18:39:06 $
 *
 *     This file contains the definitions for the volume table
 *     manipulation tool for the the QIC-40/80/3010/3020 floppy-tape
 *     driver "ftape" for Linux.
 */

#define VTBL_SIZE 128 /* bytes */

/* The following are offsets in the vtbl.  */
#define VTBL_SIG   0
#define VTBL_START 4
#define VTBL_END   6
#define VTBL_DESC  8
#define VTBL_DATE  52
#define VTBL_FLAGS 56
#define VTBL_FL_VENDOR_SPECIFIC (1<<0)
#define VTBL_FL_MUTLI_CARTRIDGE (1<<1)
#define VTBL_FL_NOT_VERIFIED    (1<<2)
#define VTBL_FL_REDIR_INHIBIT   (1<<3)
#define VTBL_FL_SEG_SPANNING    (1<<4)
#define VTBL_FL_DIRECTORY_LAST  (1<<5)
#define VTBL_FL_RESERVED_6      (1<<6)
#define VTBL_FL_RESERVED_7      (1<<7)
#define VTBL_M_NO  57
#define VTBL_EXT   58
#define EXT_ZFTAPE_SIG     0
#define EXT_ZFTAPE_BLKSZ  10
#define EXT_ZFTAPE_CMAP   12
#define EXT_ZFTAPE_QIC113 13
#define VTBL_PWD   84
#define VTBL_DIR_SIZE 92
#define VTBL_DATA_SIZE 96
#define VTBL_OS_VERSION 104
#define VTBL_SRC_DRIVE  106
#define VTBL_DEV        122
#define VTBL_RESERVED_1 123
#define VTBL_CMPR       124
#define VTBL_CMPR_UNREG 0x3f
#define VTBL_CMPR_USED  0x80
#define VTBL_FMT        125
#define VTBL_RESERVED_2 126
#define VTBL_RESERVED_3 127
/* compatability with pre revision K */
#define VTBL_K_CMPR     120 

/*  the next is used by QIC-3020 tapes with format code 6 (>2^16
 *  segments) It is specified in QIC-113, Rev. G, Section 5 (SCSI
 *  volume table). The difference is simply, that we only store the
 *  number of segments used, not the starting segment.
 */
#define VTBL_SCSI_SEGS  4 /* is a 4 byte value */

/*  one vtbl is 128 bytes, that results in a maximum number of
 *  29*1024/128 = 232 volumes.
 */
#define MAX_VOLUMES (FT_SEGMENT_SIZE/VTBL_SIZE)
#define VTBL_IDS { "VTBL", "XTBL", "UTID", "EXVT" } /* valid ids */

typedef struct vtblentry {
	u_int8_t sig[4];
	union {
		struct { u_int16_t start, end; } se;
		u_int32_t space;
	} size;
	u_int8_t  desc[44];
	u_int32_t date;
	u_int8_t vendor_specific:1;
	u_int8_t multi_cartridge:1;
	u_int8_t not_verified:1;
	u_int8_t inhibit_redirection:1;
	u_int8_t segment_spanning:1;
	u_int8_t directory_last:1;
	u_int8_t fl_reserved_6:1;
	u_int8_t fl_reserved_7:1;
	u_int8_t m_no;
	u_int8_t ext[26];
	u_int8_t pwd[8];
	u_int32_t dir_size;
	u_int64_t data_size;
	u_int16_t os_version;
	u_int8_t  source_drive[16];
	u_int8_t  device;
	u_int8_t  reserved_1;
	u_int8_t  cmpr;
	u_int8_t  format;
	u_int8_t  reserved_2;
	u_int8_t  reserved_3;
} vtblentry __attribute__ ((packed));

typedef struct vtbl {
	int num;
	int fmt_code;
	int start, end;
	unsigned int modified:1;
	vtblentry entry;
} vtbl;

#define vt_start entry.size.se.start
#define vt_end   entry.size.se.end
#define vt_space entry.size.space
#define vt_sig    entry.sig
#define vt_desc  entry.desc
#define vt_date  entry.date

extern int
getsubopt (char **optionp, const char *const *tokens, char **valuep);

#define FTAPE_DEF_TAPE "/dev/rawft0"
