.\" Copyright 1994 NEC Corporation, Tokyo, Japan.
.\"
.\" Permission to use, copy, modify, distribute and sell this software
.\" and its documentation for any purpose is hereby granted without
.\" fee, provided that the above copyright notice appear in all copies
.\" and that both that copyright notice and this permission notice
.\" appear in supporting documentation, and that the name of NEC
.\" Corporation not be used in advertising or publicity pertaining to
.\" distribution of the software without specific, written prior
.\" permission.  NEC Corporation makes no representations about the
.\" suitability of this software for any purpose.  It is provided "as
.\" is" without express or implied warranty.
.\"
.\" NEC CORPORATION DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN 
.\" NO EVENT SHALL NEC CORPORATION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF 
.\" USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR 
.\" OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR 
.\" PERFORMANCE OF THIS SOFTWARE. 
.\"
.\" $Id: RkMapPho.man,v 7.1 1994/04/21 06:51:39 kuma Exp $ NEC;
.TH "RKMAPPHONOGRAM" "3"
.SH "NAME"
\f4RkMapPhonogram\f1 \- perform Romaji-kana conversion by using a specified Romaji-kana conversion table
.SH "SYNOPSIS"
.nf
.ft 4
#include <canna/RK.h>
int RkMapPhonogram(romaji, dst, maxdst, src, srclen, flags, ulen, 
                  dlen, tlen, rule)
struct RkRxDic *romaji;
unsigned char *dst;
int maxdst;
unsigned char *src;
int srclen;
int flags;
int *ulen;
int *dlen;
int *tlen;
int *rule;
.ft 1
.fi
.SH "DESCRIPTION"
\f2RkMapPhonogram\f1 performs Romaji-kana conversion by using a specified Romaji-kana conversion table.  \f2romaji\f1 specifies a pointer to the Romaji-kana conversion table that has been returned by \f2RkOpenRoma(3)\f1.  \f2RkMapPhonogram\f1 interprets the \f2srclen\f1 bytes of contiguous data starting at the area \f2src\f1 as a Romaji character string and searches through the Romaji-kana conversion table for the rule of Romaji-kana conversion that matches the beginning of the Romaji character string.  If the corresponding conversion rule is found, the area \f2dst\f1 is loaded with the corresponding kana character string, with \f2dlen\f1 being set to its byte length.  The resulting character string is truncated when its byte length exceeds \f2maxdst\f1 -1.  
.P
\f2flags\f1 is a combination of the following Romaji-kana conversion flags connected by or:
.P
.RS
.IP "RK_SOKUON" 15n
Enables gemination, in which a sequence of two occurrences of the same character, xx, is converted to small kana character "tsu" only if it is not defined in the Romaji-kana conversion table file.  This process provides for situations in which an obsolete Romaji-kana conversion table is used.
.IP "RK_FLUSH"
Converts all Romaji characters compulsorily.  Useful for handling n appearing at the end of a character string.
.RE
.P
\f2ulen\f1, \f2dlen\f1, and \f2tlen\f1 are used to manage the progress of Romaji-kana conversion.
.P
For example, if the character string "tt" is given to \f2RkMapPhonogram\f1, the first "t" is submitted to Romaji-kana conversion, with \f2dst\f1 being set to small kana character "tsu".  The remaining "t" is put to reuse for Romaji-kana conversion.  When "a" is entered subsequently, it is combined with the "t" left from the previous run of \f2RkMapPhonogram\f1 to generate kana character "ta".
.P
\f2ulen\f1 is set to the byte length of the characters from \f2src\f1 used for Romaji-kana conversion.
.P
\f2dlen\f1 is set to the byte length of the kana characters derived from Romaji-kana conversion.
.P
\f2tlen\f1 is set to the byte length of the character string to be used in the next run of Romaji-kana conversion.  The character string led by \f2tlen\f1 is placed after the character string resulting from Romaji-kana conversion in the \f2dst\f1 buffers.
.P
If null pointers are specified in \f2ulen\f1, \f2dlen\f1, and \f2tlen\f1, these parameters do not return any values and are simply ignored.
.P
\f2rule\f1 is used to exchange information about the \f2rule\f1 of Romaji-kana conversion.  When calling \f2RkMapPhonogram\f1 for the first time, specify a pointer to a variable loaded with 0.  Upon return from the first call to \f2RkMapPhonogram\f1, that variable is loaded with internal information about the rule of Romaji-kana conversion, in place of 0.  To continue Romaji-kana conversion, specify the same pointer to the variable to \f2RkMapPhonogram\f1.
.SH "RETURN VALUE"
This function returns information about whether the character string set in \f2dst\f1 has been converted by using a rule existing in the Romaji-kana conversion table or not.  The function returns 1 if a rule existing in the Romaji-kana conversion table has been used; otherwise, it returns 0.
