/* $Id: fmt-html.h,v 1.3 1997/03/31 21:59:42 dps Exp $ */
/* Shared stuff for the *TeX output format */

#ifndef __fmt_html_h__
#define __fmt_html_h__
#include "tblock.h"
#include "interface.h"
#include "html-table.h"

/* Anything shorter than this is not a real paragraph */
#define PAR_TRESHOLD_LEN 70
/* Less than this is not a heading */
#define HEADING_TRESHOLD_LEN 10
/* Maximum section number */
#define MAX_START_NUM 100

/* Type */
struct embed
{
    const char *key;
    int key_len;
    void (*handle)(const char *txt, const docfmt *fmt, FILE *out,
		   void *d);
};


/* Local data */
struct html_data
{
    html_table *tabl;
    int col;
    int row;
    const char *last_tc;
    struct unit_info unit_d;
    int par_flg;
    int list_flg;
    const char *unit_html;
};

/* latex-fmt.cc */
extern tblock *__html_do_map(const char *s);

/* latex-embed.cc */
extern void html_embed(const tok_seq::tok *t, const docfmt *fmt, FILE *out,
		      void *d);

#endif  /* __fmt_html_h__ */

