#! /usr/bin/perl -w

use strict;

# Variable de configuration du programme.   ne modifier qu'en cas d'absolue
# ncessit !
my ($Rep_dicos, @Dicos_essent, $Chemin_Ispell, $Chemin_Buildhash,
    $Nom_Dico, $Nom_Aff, $Nom_Hash, $Nom_Aff8b, $Nom_Hash8b, $Version);

$Rep_dicos     = "./dicos";
@Dicos_essent  = ("auxil.dico", "nonverbes.dico", "pronominaux.dico",
		  "reflex-gp12.dico", "reflex-gp3.dico",
		  "series.dico", "verbes-gp12.dico", "verbes-gp3.dico",
		  "verbes-defect.dico", "verbes-impers.dico");

$Chemin_Ispell    = "ispell";
$Chemin_Buildhash = "buildhash";

$Nom_Dico   = "francais.dico";
$Nom_Aff    = "francais.aff";
$Nom_Hash   = "francais.hash";
$Nom_Aff8b  = "francais-TeX8b.aff";
$Nom_Hash8b = "francais-TeX8b.hash";
$Version    = "1.0alpha8";

# ---------------------------------------------------------------------------

# Variables boolennes renvoyant  diffrent tests d'intgrit du systme
my ($NoIspell, $NoBuildhash, $No8bits, $No64bits, $DicosManquent,$NombreDicos,
    $IndispAuto, $DicoTeX8b);

$NoIspell      = 0;
$NoBuildhash   = 0;
$No8bits       = 0;
$No64bits      = 0;
$DicosManquent = 0;
$NombreDicos   = 0;
$IndispAuto    = 0;
$DicoTeX8b     = 0;

# Autres variables...
my (@Liste_dicos, $Soulign, $Est_indisp, @Mots, @MotsTries, @FrDic, $LignePrec,
    $Dicos_manquent, $ChDicos);
my ($i, $j);

# Titre et copyright...
&Baniere;

# On vrifie que le programme ISPELL est accessible...
unless (&OKIspell) {
  &Sep;
  print STDERR "\
AVERTISSEMENT : impossible d'accder  ISPELL.  Ou le programme n'est pas
                install sur cette machine, ou il ne figure pas dans votre
                chemin d'accs (PATH).

Souhaitez-vous nanmoins poursuivre la cration du dictionnaire (o/n) ? ";
  unless (&Oui) {
    &MortSubite (6);
  }
  $NoIspell = 1;
}

# On fait de mme pour buildhash...
unless (&OKBuildhash) {
  &Sep;
  print STDERR "\
AVERTISSEMENT : impossible d'accder  l'utilitaire buildhash.  Ou le
                programme n'est pas install sur cette machine, ou il ne
                figure pas dans votre chemin d'accs (PATH).  buildhash est
                ncessaire  l'accomplissement des dernires oprations de
                cration du dictionnaire.

Souhaitez-vous nanmoins poursuivre la cration du dictionnaire (o/n) ? ";
  unless (&Oui) {
    &MortSubite (7);
  }
  $NoBuildhash = 1;
}

# Si ISPELL est accessible, on vrifie qu'il est convenablement configur
# (caractres accentus et 64 drapeaux possibles)
if (&OKIspell) {
  unless (&OK8bits) {
    &Sep;
    print STDERR "\
AVERTISSEMENT : apparemment votre version de ISPELL ne permet pas l'usage
                des caractres 8 bits.

Souhaitez-vous nanmoins poursuivre la cration du dictionnaire (o/n) ? ";
    unless (&Oui) {
      &MortSubite (1);
    }
    $No8bits = 1;
  }

  unless (&OKMask64) {
    &Sep;
    print STDERR "\
AVERTISSEMENT : apparemment votre version de ISPELL n'est pas configure
                avec l'option MASKBITS=64.  Cela est ncessaire pour que
                Francais-GUTenberg puisse utiliser les lettres minuscules
                comme drapeaux.

Souhaitez-vous nanmoins poursuivre la cration du dictionnaire (o/n) ? ";
    unless (&Oui) {
      &MortSubite (2);
    }
    $No64bits = 1;
  }
}

# On vrifie que tout est en place du ct du rpertoire contenant les
# dictionnaires.
unless (-r $Rep_dicos && -x $Rep_dicos) {
  &Sep;
  print STDERR "\
ERREUR : le rpertoire $Rep_dicos n'est pas accessible.
         Vrifiez son existence ou les permissions qui lui sont affectes.\n";
  &MortSubite (3);
}

# tablissement de la liste des dictionnaires disponibles.
chdir $Rep_dicos;
@Liste_dicos = <*.dico>;

# On vrifie que tous les dicos essentiels sont accessibles.
foreach (@Dicos_essent) {
  unless (&EstDansRep ($_)) {
    &Sep;
    print STDERR "\
AVERTISSEMENT : le dictionnaire essentiel $_ est introuvable !

Souhaitez-vous nanmoins poursuivre la cration du dictionnaire (o/n) ? ";
    unless (&Oui) {
      &MortSubite (4);
    }
    $Dicos_manquent = 1;
  }
}

# On demande  l'utilisateur s'il veut automatiquement inclure tous les
# dictionnaires essentiels
&Sep;
print "\
Un certain nombre de dictionnaires sont considrs comme essentiels au bon
fonctionnement de ISPELL.  Souhaitez-vous tous les inclure automatiquement
(si vous rpondez non, vous pourrez en effectuer la slection dictionnaire
par dictionnaire) (o/n) ? "; # " <- bug dans la syntax highlighting de xemacs
if (&Oui) {
  $IndispAuto = 1;
  &Sep;
  print "\nLes dictionnaires suivants seront inclus automatiquement :\n";
  foreach (@Dicos_essent) {
    print ($_, "\n");
  }
}

# On demande  l'utilisateur quels dictionnaires il veut utiliser.
foreach $i (@Liste_dicos) {
  if (&EstDansDicosEssent($i)) { # Est-ce qu'on a affaire  un dico indisp. ?
    $Est_indisp = 1;
  } else {
    $Est_indisp = 0;
  }
  if ($IndispAuto && $Est_indisp) { # Est-ce qu'on inclut les dico indisp.
    open (DICO, $i);                # automatiquement ?
    push(@Mots, <DICO>);
    close (DICO);
    $NombreDicos++;
    next;
  }
  &Sep;
  print "\n$i\n";  # Sinon on affiche le nom du dictionnaire...
  $Soulign = "";   # ... et on le souligne joliment.
  for ($j = 0; $j < length($i); $j++) {
    $Soulign = $Soulign."-";
  }
  print "$Soulign\n";
  $_ = $i;
  s/\.dico/\.desc/;  # On cherche le fichier .desc correspondant au dico. 
  if (not (-r $_)) {
    print "(Pas de description de ce fichier disponible.)\n";
  } else {
    open (DESCRIPTION, $_); # On affiche la description si elle existe.
    foreach (<DESCRIPTION>) {
      print $_;
    }
    close (DESCRIPTION);
  }
  if ($Est_indisp) { # On prcise si le dico est indispensable ou pas
    print "En principe, ce fichier est indispensable.\n";
  } else {
    print "L'utilisation de ce fichier est facultative.\n";
  }
  print "Souhaitez-vous inclure ce fichier dans le dictionnaire (o/n) ? ";
  if (&Oui) { # On demande si le dico doit tre inclus
    open (DICO, $i);
    push(@Mots, <DICO>);
    close (DICO);
    $NombreDicos++;
  } else {
    if ($Est_indisp) { # Si le dico est indisp. et pas inclus, s'en souvenir
      $DicosManquent = 1;
    }
  }
}

# Affichage du nombre de dictionnaires slectionns.
if ($NombreDicos) {
  &Sep;
  print "\nVous avez slectionn $NombreDicos dictionnaires.\n";
} else {
  print STDERR "\nVous n'avez slectionn aucun dictionnaire !\n";
  print STDERR "Quid ?\n";
  exit (5);
}

# Tri du dictionnaire
&Sep;
print "\nTri du dictionnaire en cours...\n";
@MotsTries = sort(@Mots);
print "Tri du dictionnaire termin.\n";

# Suppression des doublons
&Sep;
print "\nSuppression des doublons en cours...\n";
$LignePrec = $MotsTries[0];
push @FrDic, $LignePrec;

for ($i = 1; $i < @MotsTries; $i++) {
  unless ($MotsTries[$i] eq $LignePrec) {
    push @FrDic, $MotsTries[$i];
  }
  $LignePrec = $MotsTries[$i];
}
print "Suppression des doublons termine.\n";


# criture du dictionnaire
chdir ("..");
open (DICO, ">$Nom_Dico");
foreach (@FrDic) {
  print DICO $_;
}
close (DICO);

# S'il y a eu des problmes au niveau des tests d'intgrit, on effectue un
# petit rappel...
&Sep;
if ($NoIspell) {
  print "\
RAPPEL : ISPELL n'a pu tre trouv sur votre systme.  L'invocation de
         buildhash est donc impossible.\n";
} elsif ($NoBuildhash) {
  print "\
RAPPEL : l'utilitaire buildhash n'est pas disponible.  Sans lui, il est
         impossible d'accomplir la dernire opration de cration du
         dictionnaire.\n";
} elsif ($No8bits) {
  print "\
RAPPEL : votre version de ISPELL n'accepte pas les caractres 8 bits.
         L'invocation de buildhash est donc impossible.\n";
} elsif ($No64bits) {
  print "\
RAPPEL : votre version de ISPELL n'a pas t compile avec  l'option
         MASKBITS=64.  L'invocation de buildhash est donc impossible.\n";
} else {
  print "\nInvocation de buildhash...\n\n";
  unlink ($Nom_Dico.".cnt", $Nom_Dico.".stat");
  system "$Chemin_Buildhash $Nom_Dico $Nom_Aff $Nom_Hash";
  &Sep;
  print "\
Souhaitez-vous galement produire un dictionnaire permettant de corriger des
fichiers TeX huit bits depuis la ligne de commande (pas ncessaire si vous
utilisez EMACS -- voir docs/tex8b.pdf pour plus de dtails) (o/n) ? ";
  if (&Oui) {
    $DicoTeX8b = 1;
    system "$Chemin_Buildhash $Nom_Dico $Nom_Aff8b $Nom_Hash8b";
  }
}

# Si des dicos essentiels sont introuvables, on rappelle la chose.
if ($DicosManquent) {
  &Sep;
  print "\
AVERTISSEMENT : Un ou plusieurs dictionnaires essentiels n'ont pas t inclus
                dans Francais-GUTenberg, soit qu'ils manquent, soit que vous
                ayez dcid de ne pas les inclure.  Dans les deux cas, il est
                fort probable que Francais-GUTenberg ne fonctionnera pas
                correctement !\n";
}

# Affichage des dernires recommandations.
unless ($NoIspell || $NoBuildhash || $No8bits || $No64bits) {
  &Sep;
  $ChDicos = &CheminDicos;
  print "\
Pour complter l'installation de Francais-GUTenberg, vous devez maintenant
copier les fichiers $Nom_Aff et $Nom_Hash  l'endroit o ISPELL va
chercher ses dictionnaires.
Probablement : $ChDicos\n\n";

  if ($DicoTeX8b) {
    print "(Faites de mme pour $Nom_Aff8b et $Nom_Hash8b.)\n\n";
  }
}

# ---------------------------------------------------------------------------

# Est-ce que ISPELL est install sur le systme ?
sub OKIspell {
  my ($Bool, $rc);
  $Bool = 0;
  $rc = system "$Chemin_Ispell -v > /dev/null";
  if ($rc == 0) {
    $Bool = 1;
  }
  $Bool;
}

# ---------------------------------------------------------------------------

# Est-ce que l'utilitaire buildhash est accessible ?
sub OKBuildhash {
  my ($Bool, $rc);
  $Bool = 0;
  $rc = system "$Chemin_Buildhash 2> /dev/null";
  if ($rc == 256) {
    $Bool = 1;
  }
  $Bool;
}

# ---------------------------------------------------------------------------

# Est-ce que ISPELL peut utiliser les caractres accentus ?
sub OK8bits {
  my ($Bool);
  $Bool = 0;
  foreach $_ (`$Chemin_Ispell -vv`) {
    if (/!NO8BIT/) {
      $Bool = 1;
      last;
    }
    if (/NO8BIT/) {
      last;
    }
  }
  $Bool;
}

# ---------------------------------------------------------------------------

# Est-ce que ISPELL peut utiliser 64 (en fait 58) drapeaux ?
sub OKMask64 {
  my ($Bool);
  $Bool = 0;
  foreach $_ (`$Chemin_Ispell -vv`) {
    if (/MASKBITS.*64/) {
      $Bool = 1;
      last;
    }
  }
  $Bool;
}

# ---------------------------------------------------------------------------

# On cherche  tablir o ISPELL cache ses dictionnaires 
sub CheminDicos {
  my ($chdic, @prov);
  foreach $_ (`$Chemin_Ispell -vv`) {
    if (/LIBDIR/) {
      @prov = split /\"/;  # on sait que le chemin figure entre guillemets
      $chdic = $prov[1];
      last;
    }
  }
  $chdic;
}

# ---------------------------------------------------------------------------

sub Oui {
  my ($Bool, $Rep);
  $Bool = 0;
  $Rep = <STDIN>;
  while (not ($Rep =~ /^o/ || $Rep =~ /^O/ || $Rep =~ /^n/ || $Rep =~ /^N/)) {
    print STDERR "Veuillez rpondre par oui ou par non : ";
    $Rep = <STDIN>;
  }
  if ($Rep =~ /^o/  || $Rep =~ /^O/) {
    $Bool = 1;
  }
  $Bool;
}

# ---------------------------------------------------------------------------

sub EstDansRep {
  my ($Bool);
  $Bool = 0;
  foreach (@Liste_dicos) {
    if ($_[0] eq $_) {
      $Bool = 1;
      last;
    }
  }
  $Bool;
}


# ---------------------------------------------------------------------------

sub EstDansDicosEssent {
  my ($Bool);
  $Bool = 0;
  foreach (@Dicos_essent) {
    if ($_[0] eq $_) {
      $Bool = 1;
      last;
    }
  }
  $Bool;
}

# ---------------------------------------------------------------------------

sub MortSubite {
  print STDERR "Cration du dictionnaire interrompue !\n";
  exit ($_[0]);
}

# ---------------------------------------------------------------------------

sub Baniere {
  print "\
---------------------------------------------------------------------------

Francais-GUTenberg version $Version
Copyright (C) 1998 Christophe Pythoud et l'Association GUTenberg.
Francais-GUTenberg est fourni sans AUCUNE GARANTIE.
Vous tes encourag  redistribuer ce programme sous certaines conditions.
Pour plus de dtails, consultez le fichier GPL-fr.\n";
}

# ---------------------------------------------------------------------------

sub Sep {
  print "\
---------------------------------------------------------------------------\n";
}


