<!-- Fragment document type declaration subset:
ArborText, Inc., 1988-1998, v.4001
<!DOCTYPE SET PUBLIC "-//Davenport//DTD DocBook V3.0//EN" [
<!ENTITY html-version SYSTEM "n:\share\dsssl\docbook\html\version.dsl">
<!ENTITY html SYSTEM "html.sgm">
<!ENTITY print SYSTEM "print.sgm">
<!ENTITY dprhtm "<?html-filename pr-ver.htm>">
<!ENTITY dlibhtm "<?html-filename lib-ver.htm>">
<!ENTITY dcmnhtm "<?html-filename cmn-ver.htm>">
<!ENTITY doc-dblib SYSTEM "dblib.sgm">
<!ENTITY doc-dbparam SYSTEM "dbparam.sgm">
<!ENTITY print-version SYSTEM "n:\share\dsssl\docbook\print\version.dsl">
<!ENTITY common-version SYSTEM "n:\share\dsssl\docbook\common\version.sgm">
<!ENTITY lib-version SYSTEM "n:\share\dsssl\docbook\lib\version.sgm">
<!ENTITY dhtmhtm "<?html-filename index.html>">
<!ENTITY % dsssl-source "IGNORE">
<!ENTITY % dsssl-documentation "INCLUDE">
]>
-->
<?Pub Inc>
<?Pub CX set(book(title()bookinfo()chapter(title()>
<![ %dsssl-source; [;; $Id: version.dsl 1.32 1998/09/02 17:41:43 nwalsh Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.nwalsh.com/docbook/dsssl/
;;

;; If **ANY** change is made to this file, you _MUST_ alter the
;; following definition:

(define %stylesheet-version%
  "Modular DocBook HTML Stylesheet version 1.13")

]]><![ %dsssl-documentation; [<para>This document summarizes the changes made
to the Modular DocBook HTML Stylesheet:</para><variablelist>
<varlistentry><term>Version 1.11, 18 Aug 1998</term>
<listitem>
<itemizedlist>
<listitem><para>Modified presentation of <sgmltag>ClassName</sgmltag>, <sgmltag>
Function</sgmltag>, <sgmltag><?Pub Caret1>Citation</sgmltag>, and <sgmltag>
Email</sgmltag>. I think these are improvements.</para>
</listitem>
<listitem><para><sgmltag>Set</sgmltag> and <sgmltag>Part</sgmltag> TOCs are
now generated by default.</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>Version 1.10, 31 Jul 1998</term>
<listitem>
<itemizedlist>
<listitem><para>Renamed<literal>%html-meta-tags%</literal> to <literal>%html-header-tags%
</literal> and changed the list format.</para>
</listitem>
<listitem><para>Added <literal>%link-mailto-url%</literal>. If not <literal>
#f</literal>, a <literal>REL="made"</literal> <sgmltag>LINK</sgmltag> will
be added to the <sgmltag>HEAD</sgmltag> of each HTML file with <literal>HREF
</literal> set to <literal>%link-mailto-url%</literal>.</para>
</listitem>
<listitem><para>Added<literal>%css-decoration%</literal>. If true, then the
stylesheets will add inline CSS styles where necessary. At the moment, this
is only in handling of list items with unsupported <literal>MARK</literal>
attributes (e.g. &ldquo;none&rdquo;) or <literal>OVERRIDE</literal> attributes.
</para>
</listitem>
<listitem><para>Added <literal>%css-liststyle-alist%</literal> to map the
list style names used in the <literal>MARK</literal> or <literal>OVERRIDE
</literal> attributes on <sgmltag>ItemizedList</sgmltag> to the appropriate
HTML names. For example, <literal>bullet</literal> maps to <literal>disc</literal>
in HTML.</para>
</listitem>
<listitem><para>Changed meaning of <literal>(nav-home)</literal>; it now returns
the node which is the home page. The old behavior is now provided by <literal>
(nav-home-link)</literal>.</para>
</listitem>
<listitem><para>Fixed bug in <sgmltag>CalloutList</sgmltag> handling where <sgmltag>
Area</sgmltag>, <sgmltag>AreaSpec</sgmltag>, and <sgmltag>AreaSet</sgmltag>
incorrectly produced <sgmltag>P</sgmltag>s.</para>
</listitem>
<listitem><para>Fixed bug in handling of <literal>CLASS</literal> attribute
on footnote <sgmltag>DIV</sgmltag>s.</para>
</listitem>
<listitem><para>Reworked support for elements in the <sgmltag>HEAD</sgmltag>.
The stylesheets now automatically produce <sgmltag>META</sgmltag> elements
for keywords and <sgmltag>LINK</sgmltag> elements for navigation.</para>
<para>The functions and parameters used to produce information in the head
have been renamed. Use the <literal>%html-header-tags%</literal> list to add
elements to the <sgmltag>HEAD</sgmltag> or redefine <literal>($user-html-header$)
</literal>. Redefine <literal>($standard-html-header$)</literal> to remove/modify
the standard header tags.</para>
</listitem>
<listitem><para>Added better support for <literal>OVERRIDE</literal> and <literal>
MARK</literal> on <sgmltag>ItemizedList</sgmltag>s. Some support requires <literal>
%css-decoration%</literal>.</para>
</listitem>
<listitem><para>Added <sgmltag>DIV</sgmltag>s around the navigation elements
on each page with an appropriate <literal>CLASS</literal>.</para>
</listitem>
<listitem><para>In the non-tabular navigation setup, I changed the order of
&ldquo;Next&rdquo; and &ldquo;Previous&rdquo; so that it's a little easier
to use with Lynx (&ldquo;Next&rdquo; is now the default link, which makes
more sense).</para>
</listitem>
<listitem><para>Fixed bug in formatting of <sgmltag>Procedure</sgmltag>s.
</para>
</listitem>
<listitem><para>Fixed bug in formatting of tables with missing entries at
the end of a row.</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>Version 1.09, 19 Jul 1998</term>
<listitem>
<itemizedlist>
<listitem><para>Added <literal>SPAN</literal> wrapper around inlines with
a <literal>CLASS</literal> attribute that indicates the GI of the original
element. This makes the resulting HTML documents more amenable to CSS stylesheets.
</para>
</listitem>
<listitem><para>Made output of <literal>&lt;sgmltag class="element"></literal>
switch to Courier.</para>
</listitem>
<listitem><para>Fixed bug which caused <sgmltag>Footnote</sgmltag>s to be
lost in <sgmltag>CalloutList</sgmltag>s</para>
</listitem>
<listitem><para>Fixed bug in calculation of component names when <literal>
%use-id-as-filename%</literal> is true.</para>
</listitem>
<listitem><para>Added <literal>($html-body-start$)</literal>, <literal>($html-body-content-start$)
</literal>, <literal>($html-body-content-end$)</literal>, and <literal>($html-body-end$)
</literal>. These functions can be redefined to add content to the top and
bottom of every HTML document generated. </para>
</listitem>
<listitem><para>Added <literal>%html-manifest%</literal> parameter. The complete
list of files generated by the stylesheet is written to this file.</para>
</listitem>
<listitem><para>Changed the default doctype to <literal>"-//W3C//DTD HTML
4.0 Transitional//EN"</literal>. The HTML resulting from these stylesheets
is not always completely legal because DocBook allows block elements in paragraphs
and HTML does not, but the resulting HTML is closer to the transitional 4.0
DTD.</para>
</listitem>
<listitem><para>Changed the default CSS stylesheet to <literal>#f</literal>.
</para>
</listitem>
<listitem><para>Fixed bug in <literal>%funcsynopsis-decoration%</literal>
where multiple <sgmltag>Parameter</sgmltag>s were not comma separated.</para>
</listitem>
<listitem><para>Fixed bug in handling of graphics on title pages. Tinkered
with title pages.</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>Version 1.08, 12 Jun 1998</term>
<listitem>
<itemizedlist>
<listitem><para>Added support for formatting an <sgmltag>Index</sgmltag>.
Note: This <emphasis>does not</emphasis> include support for building an index
from <sgmltag>IndexTerm</sgmltag> tags; only for formatting an index coded
in SGML. And even that support's not great.</para>
</listitem>
<listitem><para>Added hooks for printing out section-level &ldquo;titlepages&rdquo;.
</para>
</listitem>
<listitem><para>Output IDs on informal objects.</para>
</listitem>
<listitem><para>Fixed bug in processing of <sgmltag>Article</sgmltag> titlepages.
</para>
</listitem>
<listitem><para>Fixed bug in formatting of <sgmltag>SegmentedList</sgmltag>s.
</para>
</listitem>
<listitem><para>Fixed bug in construction of HTML filename when an <literal>
html-basename</literal> PI is used.</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>Version 1.08beta8, 13 May 1998</term>
<listitem>
<itemizedlist>
<listitem><para>Sweeping changes to make it possible to use these stylesheets
with both SGML and XML instances. All element names have been lowercased and
most strings are now <literal>(normalized "")</literal> before comparisons.
A number of variables are now functions because normalization can only occur
after a <literal>(current-node)</literal> exists.</para>
</listitem>
<listitem><para><sgmltag>RefSect*</sgmltag>'s are never auto-numbered.</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>Version 1.08beta7, 06 May 1998</term>
<listitem>
<itemizedlist>
<listitem><para>Completely rewrote support for title pages. Title pages are
now supported on all division&mdash; and component-level elements. Title pages
are now supported on <sgmltag>Article</sgmltag>s, for example.</para>
</listitem>
<listitem><para>Added support for <sgmltag>PubDate</sgmltag> in <sgmltag>
BiblioEntry</sgmltag>s. If <sgmltag>PubDate</sgmltag> is present, it will
be used. Otherwise the <sgmltag>Year</sgmltag> in the <sgmltag>Copyright</sgmltag>
will be used.</para>
</listitem>
<listitem><para>Added French localization.</para>
</listitem>
<listitem><para>Fixed spacing around footnote references.</para>
</listitem>
<listitem><para>The system identifier of a graphic file referenced by <sgmltag
class="attribute">EntityRef</sgmltag> is now subject to the same processing
as <sgmltag class="attribute">FileRef</sgmltag>.</para>
</listitem>
<listitem><para>Added <literal>%stylesheet%</literal> and <literal>%stylesheet-type%
</literal> to support an HTML LINK to a stylesheet.</para>
</listitem>
<listitem><para>Added <literal>$html-header-tags$</literal> to support complete
customization of the HTML HEAD elements.</para>
</listitem>
<listitem><para>Fixed <sgmltag>Chapter</sgmltag>/<sgmltag>Appendix</sgmltag>
numbering in the navigation context string in headers.</para>
</listitem>
<listitem><para>I think I had the distinction between ANSI and K&amp;R style
function synopsis backwards. So I reversed it.</para>
</listitem>
<listitem><para>Added <literal>%funcsynopsis-decoration%</literal> to control
whether or not the elements in a <sgmltag>FuncSynopsis</sgmltag> should be
decorated (return types bold, parameters italic, etc.).</para>
</listitem>
<listitem><para>Removed <literal>%generate-titlepage%</literal>. Added <literal>
%generate-<replaceable>element</replaceable>-titlepage%</literal> for <sgmltag>
Set</sgmltag>, <sgmltag>Book</sgmltag>, <sgmltag>Part</sgmltag>, <sgmltag>
Reference</sgmltag>, and <sgmltag>Article</sgmltag>.</para>
</listitem>
<listitem><para>Replaced <sgmltag>%generate-toc%</sgmltag> with <literal>
%generate-<replaceable>element</replaceable>-toc%</literal></para>
</listitem>
<listitem><para>Replaced <sgmltag>%generate-lot-list%</sgmltag> with <literal>
%generate-<replaceable>element</replaceable>-lot-list%</literal></para>
</listitem>
<listitem><para>Added <literal>%titlepage-in-info-order%</literal>. If true,
then the elements on a generated titlepage occur in the order that they appear
in the corresponding <sgmltag>*Info</sgmltag> element. Otherwise, they appear
in a fixed (but configurable) order specified by the stylesheet.</para>
</listitem>
<listitem><para>Added <literal>%generate-part-toc-on-titlepage%</literal>
and <literal>%generate-reference-toc-on-titlepage%</literal>. If true then
the TOC for <sgmltag>Part</sgmltag>s and <sgmltag>Reference</sgmltag>s occur
on the title page for those elements, otherwise they appear on a page sequence
following the title page.</para>
</listitem>
<listitem><para>Added <literal>%generate-partinfo-on-titlepage%</literal>.
If true then the contents of the <sgmltag>PartIntro</sgmltag> element occurs
on the title page of the containing element (<sgmltag>Part</sgmltag> or <sgmltag>
Reference</sgmltag>).</para>
</listitem>
<listitem><para>Added html-filenames to all the REFENTRY comments in the <filename>
prparam.dsl</filename> file so that they can be propagated to the documentation.
I'm basically sacraficing any attempt at maintaining 8.3 filenames in the
documentation in favor of consistent filenames. Since switching to <literal>
all-element-number</literal>, the filenames for the <sgmltag>RefEntry</sgmltag>s
change completely with every release which is a bit of a maintainance headache.
</para>
</listitem>
<listitem><para>Fixed bug in <filename>dbtable.dsl</filename>; changed <literal>
(make paragraph)</literal> to <literal>(make element gi: "P")</literal>.</para>
</listitem>
<listitem><para>Added semicolons between multiple <sgmltag>SubTitle</sgmltag>s.
</para>
</listitem>
<listitem><para>Changed <literal>legalnotice-link-file</literal> to a function
(rather than a constant) so that multiple legal notice links can be generated
(for several <sgmltag>Book</sgmltag>s in a <sgmltag>Set</sgmltag>, for example).
</para>
</listitem>
<listitem><para>Fixed some table bugs. Missing cells should now be generated
at the end of rows.</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>Version 1.08beta6, 08 Apr 1998</term>
<listitem>
<itemizedlist>
<listitem><para>Added support for <sgmltag>RevHistory</sgmltag> in <sgmltag>
BookBiblio</sgmltag>.</para>
</listitem>
<listitem><para>Put spacing paragraphs below <literal>$informal-object$</literal>s
(as well as above) and around tabular <sgmltag>SimpleLists</sgmltag>.</para>
</listitem>
<listitem><para>Added <literal>head-title-mode</literal> to make sure that
markup is suppressed in the <sgmltag>TITLE</sgmltag> element in the <sgmltag>
HTML</sgmltag> <sgmltag>HEAD</sgmltag>.</para>
</listitem>
<listitem><para>Changed the format of automatically generated anchor names.
Instead of making an XPointer-like string, simple use the <literal>(all-element-number)
</literal> of the element.</para>
</listitem>
<listitem><para>It is now legal to have a <sgmltag>Graphic</sgmltag> element
with neither <sgmltag class="attribute">FileRef</sgmltag> nor <sgmltag class="attribute">
EntityRef</sgmltag>. If so, no output is generated.</para>
</listitem>
<listitem><para>In <literal>xref-title-mode</literal>, inline markup is no
longer suppressed.</para>
</listitem>
<listitem><para>Added support for cross-references to <sgmltag>ListItem</sgmltag>s
in <sgmltag>OrderedList</sgmltag>s.</para>
</listitem>
<listitem><para>Added spacing paras around tabular <sgmltag>SimpleList</sgmltag>s.
</para>
</listitem>
<listitem><para>Overhauled the table processing as per the print version.
Construction rules are now used to process elements in table cells again,
making inline markup in tables work correctly.</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>Version 1.08beta5, 29 Mar 1998</term>
<listitem>
<para>Update documentation.</para>
</listitem>
</varlistentry>
<varlistentry><term>Version 1.08beta4, 29 Mar 1998</term>
<listitem>
<itemizedlist>
<listitem><para>Removed a significant performance bottleneck. It turns out
that <literal>element-number</literal> is fairly expensive, so I have replaced
it with <literal>all-element-number</literal>. The disadvantage of this change
is that the straightforward numbering of chunks has been lost. While the third
section of the second chapter was formerly named <filename>c0203.htm</filename>,
it is now named <filename>c23252.htm</filename> where &ldquo;23252&rdquo;
is the ordinal number of the element from the start of the document and bears
no obvious relationship to the logical position of the element in the document.
Bummer. But the performance improvement is at least a factor of <emphasis>
five</emphasis>.</para>
</listitem>
<listitem><para>Changed public identifier for the ISO Latin 1 entity set so
that it matches the public identifier used by DocBook.</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>Version 1.08beta3, 26 Mar 1998</term>
<listitem>
<itemizedlist>
<listitem><para>More changes to support multiple languages simultaneously.
</para>
</listitem>
<listitem><para>Fixed bug in TOC formatting. (HTML tags did not nest properly.)
</para>
</listitem>
<listitem><para>Fixed bug in <sgmltag>VariableList</sgmltag> formatting.</para>
</listitem>
<listitem><para>Improved gentext for German and Russian.</para>
</listitem>
<listitem><para>Fixed bug where elements in <literal>chunk-skip-first-element-list
</literal> were not always being handled correctly.</para>
</listitem>
<listitem><para>Changed default table width in navigation tables from 515
to 100%.</para>
</listitem>
<listitem><para>Improved formatting of titles in <sgmltag>RefEntry</sgmltag>s.
</para>
</listitem>
<listitem><para>Fixed formatting of <sgmltag>FuncSynopsis</sgmltag>.</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>Version 1.08beta1, 26 Feb 1998</term>
<listitem>
<para>Widespread changes to support multiple languages simultaneously.</para>
</listitem>
</varlistentry>
<varlistentry><term>Version 1.07, 22 Feb 1998</term>
<listitem>
<para>Fixed bug where an unrecognized alignment cause the stylesheet to crash.
</para>
</listitem>
</varlistentry>
<varlistentry><term>Version 1.06, 19 Feb 1998</term>
<listitem>
<itemizedlist>
<listitem><para>Fixed an insidious bug in the handling of titles. If you put
markup in titles (including things like <sgmltag>InlineGraphic</sgmltag>),
it was being ignored. Now it won't be.</para>
</listitem>
<listitem><para>Added basic support for <sgmltag>Set</sgmltag>s.</para>
</listitem>
<listitem><para>Added <literal>%generate-set-toc%</literal> to control creation
of a ToC for <sgmltag>Set</sgmltag>s.</para>
</listitem>
<listitem><para>For some inexplicable reason, I chose to render <sgmltag>
Title</sgmltag>s in bibliography entries with leading and trailing underscores
rather than properly in italics. I fixed that.</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>Version 1.05, 15 Feb 1998</term>
<listitem>
<itemizedlist>
<listitem><para>Fixed some bugs in the way ToCs and chapter ToCs were produced.
</para>
</listitem>
<listitem><para>Moved common localization functions into the common directory.
</para>
</listitem>
<listitem><para>Created a public identifier for the HTML stylesheet: <screen>
-//Norman Walsh//DOCUMENT DocBook HTML Stylesheet//EN</screen>and added a <filename>
CATALOG</filename> file to the distribution.</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>Version 1.04, 08 Feb 1998</term>
<listitem>
<itemizedlist>
<listitem><para>Fixed some bugs with admonitions. If a <sgmltag>Title</sgmltag>
is present on an admonition, it is used <emphasis>in place of</emphasis> the
automatically generated title. This was the intended behavior in the past,
but it was not implemented properly. Admonitions containing <sgmltag>SimPara
</sgmltag> now work.</para>
</listitem>
<listitem><para>Changed heuristic for finding <sgmltag>Title</sgmltag> and <sgmltag>
SubTitle</sgmltag> elements in <sgmltag>*Info</sgmltag> nodes. The stylesheet
now unwraps one level of <sgmltag>BookBiblio</sgmltag>, <sgmltag>BiblioMisc
</sgmltag>, or <sgmltag>BiblioSet</sgmltag>.</para>
</listitem>
<listitem><para><sgmltag>Editor</sgmltag>s are now supported in the book meta.
</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>Version 1.03, 06 Feb 1998</term>
<listitem>
<para>Fixed a small problem with <sgmltag>RevHistory</sgmltag> in <sgmltag>
BookBiblio</sgmltag>; the construction rule in <filename>dbinfo.dsl</filename>
was more specific than the rule in <filename>dbbibl.dsl</filename>, so the
wrong rule was firing. Fixed by making the construction rule in <filename>
dbinfo.dsl</filename> call a function defined in <filename>dbbibl.dsl</filename>.
</para>
</listitem>
</varlistentry>
<varlistentry><term>Version 1.02, 03 Feb 1998</term>
<listitem>
<itemizedlist>
<listitem><para>Added support for sending HTML output to a single file instead
of making chunks. To use this feature, set <literal>nochunks</literal> to <literal>
#t</literal> in your stylesheet or pass Jade the option <literal>-V nochunks
</literal> when you format the document. You must use I/O redirection to capture
the HTML output if you suppress chunking.</para>
</listitem>
<listitem><para>Added support for separators between chunks. These are empty
by default if chunking is enabled, and a single <literal>&lt;HR></literal>
if chunking is suppressed.</para>
</listitem>
<listitem><para><sgmltag>Chapter</sgmltag> and <sgmltag>Part</sgmltag> TOCs
are suppressed by default if chunking is suppressed.</para>
</listitem>
<listitem><para>Added an <literal>&lt;A NAME="..."></literal> wrapper to component
and division titles.</para>
</listitem>
<listitem><para>Fixed a bug in the support for graphics if <literal>fileref
</literal> is unspecified.</para>
</listitem>
<listitem><para>Changed default section level for <sgmltag>SimpleSect</sgmltag>s
to 1.</para>
</listitem>
<listitem><para>Fixed bug that prevented processing instructions from being
allowed between table rows and entries. </para>
</listitem>
<listitem><para>Changed default formatting of <sgmltag>Emphasis</sgmltag>
and <sgmltag>FirstTerm</sgmltag> to italic rather than bold. Changed the default
formatting of <sgmltag>Filename</sgmltag> to a mono-spaced font.</para>
</listitem>
<listitem><para>Added <literal>%chapter-autolabel%</literal> to control enumeration
of <sgmltag>Chapter</sgmltag>s.</para>
</listitem>
<listitem><para>Fixed a small problem in the formatting of <sgmltag>RefEntry
</sgmltag>s.</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>1.01, 07 Jan 1998</term>
<listitem>
<itemizedlist>
<listitem><para>Made <sgmltag>SideBar</sgmltag> and <sgmltag>LegalNotice</sgmltag> <literal>
$semiformal-object$</literal>s</para>
</listitem>
<listitem><para>Fixed formatting of section <sgmltag>SubTitle</sgmltag>s.
(The were coming out <emphasis>bigger</emphasis> rather than smaller than
the section <sgmltag>Title</sgmltag>s.)</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>1.0, 06 Jan 1998</term>
<listitem>
<para>Changes to the HTML stylesheet:<itemizedlist>
<listitem><para>Happy New Year!</para>
</listitem>
<listitem><para>Moved table footnote code to <filename>dbfootn.dsl</filename>;
moved <sgmltag>TABLE</sgmltag> and <sgmltag>INFORMALTABLE</sgmltag> element
rules to <filename>dbblock.dsl</filename>. Like the changes to <filename>
dbcommon.dsl</filename>, these changes make it easier to reuse the CALS table
handling code in <filename>dbtable.dsl</filename> with other DTDs.</para>
</listitem>
<listitem><para>Made substantial changes to <literal>next-major-component-chunk-element
</literal> and <literal>prev-major-component-chunk-element</literal>. These
are supposed to be &ldquo;next sibling&rdquo; and &ldquo;previous sibling&rdquo;
functions. I <emphasis>think</emphasis> these versions work.</para>
</listitem>
<listitem><para>Added <filename>common/dbtable.dsl</filename> to the DocBook
stylesheet.</para>
</listitem>
</itemizedlist></para>
</listitem>
</varlistentry>
<varlistentry><term>0.10, 29 Dec 1997</term>
<listitem>
<para>Changes to the HTML stylesheet:<itemizedlist>
<listitem><para>Fixed small formatting bug in Bibliographies, where a comma
(<literal>%biblsep%</literal>) was output after the <literal>[abbrev]</literal>.
</para>
</listitem>
<listitem><para>Added <literal>%graphic-default-extension%</literal> to allow
stylesheets to select the appropriate format of graphics in print vs. HTML
stylesheets.</para>
</listitem>
<listitem><para>Modified <literal>$html-header-meta$</literal> so that a <literal>
CREATOR</literal> <sgmltag>Meta</sgmltag> tag is always output with the <literal>
%stylesheet-version%</literal>.</para>
</listitem>
<listitem><para>Handle <literal>IDREFS</literal> on <sgmltag>Callout</sgmltag>s.
</para>
</listitem>
<listitem><para>Added <literal>%simplelist-column-width%</literal> to set
width of columns in <sgmltag>SimpleList</sgmltag>s.</para>
</listitem>
<listitem><para>Added <filename>version.dsl</filename> to contain the change
log and the version.</para>
</listitem>
</itemizedlist></para>
</listitem>
</varlistentry>
<varlistentry><term>0.9, 04 Dec 1997</term>
<listitem>
<para>This release contains support for callouts, a few other enhancements,
a number of bug fixes, and a set of test documents.</para>
<para>Changes to <filename>dblib.dsl</filename>; the general function library:<itemizedlist>
<listitem><para>Fixed bug in <literal>has-ancestor-member?</literal>; it returned
precisely the opposite condition.</para>
</listitem>
<listitem><para>Added <literal>string->list</literal>, <literal>list->string
</literal>, and <literal>split</literal>.</para>
</listitem>
</itemizedlist></para>
<para>Changes to <filename>dbcommon.dsl</filename>; the common library:<itemizedlist>
<listitem><para>Added <literal>REFENTRY</literal> to <literal>major-component-element-list
</literal> to fix HTML navigation problems.</para>
</listitem>
<listitem><para>Added <literal>EQUATION</literal> to <literal>block-element-list
</literal> so that <literal>XREF</literal>s are possible.</para>
</listitem>
<listitem><para>Removed extraneous space in <literal>author-list-string</literal>.
</para>
</listitem>
<listitem><para>Added <literal>bibliodiv-autolabel</literal>, <literal>glossdiv-autolabel
</literal>, <literal>dedication-title-sosofo</literal>, and <literal>dedication-title
</literal>.</para>
</listitem>
</itemizedlist></para>
<para>Changes to the HTML stylesheet:<itemizedlist>
<listitem><para>Added more support for <literal>CALLOUT</literal>s. The support
is based on an old posting to the <ulink url="http://www.mulberrytech.com/">
dssslist</ulink> and is fairly fragile. See <filename>dbcallou.dsl</filename>.
</para>
</listitem>
<listitem><para>Added support for line numbers in linespecific displays. Like
the support for <literal>CALLOUT</literal>s, it's a bit fragile.</para>
</listitem>
<listitem><para>Using the same approach, <literal>LITERALLAYOUT</literal>
and <literal>ADDRESS</literal> elements are no longer set as <literal>&lt;PRE>
</literal>s. Instead, line breaks and spaces are handled by conversion to <literal>
&lt;BR></literal> and <literal>&amp;nbsp;</literal> in a normal <literal>
&lt;P></literal>.</para>
</listitem>
<listitem><para>Added support for bibliography entries. The result probably
doesn't follow any particular, published bibliographic style, and may not
suit the needs of anyone, but at least the stylesheet <emphasis>tries</emphasis>
now. ;-)</para>
</listitem>
<listitem><para>Fixed table bug. Overhanging rows were not always accounted
for when skipping to a new entry.</para>
</listitem>
<listitem><para>Support for <literal>CALLOUT</literal>s to multiple <literal>
AREA</literal>s is broken. The stylesheet now outputs &ldquo;??&rdquo; to
indicate this.</para>
</listitem>
<listitem><para>Suppress <literal>ACRONYM</literal> and <literal>ABBREV</literal>
in the <emphasis>direct</emphasis> content model of <literal>GLOSSENTRY</literal>.
</para>
</listitem>
<listitem><para>Fixed <literal>KEYCOMBO</literal> so that a &ldquo;+&rdquo;
is printed between its children.</para>
</listitem>
<listitem><para>Improved <filename>dbl1ru.dsl</filename>.</para>
</listitem>
<listitem><para>Added <literal>DEDICATION</literal> and &ldquo;Pgs.&rdquo;
to <filename>dbl1usen.dsl</filename>.</para>
</listitem>
<listitem><para>Improved support for <literal>INFORMALEQUATION</literal> and <literal>
INLINEEQUATION</literal>.</para>
</listitem>
<listitem><para>Suppress <literal>MSGREL</literal>.</para>
</listitem>
</itemizedlist></para>
</listitem>
</varlistentry>
<varlistentry><term>0.8, 24 Nov 1997</term>
<listitem>
<para>Minor changes.</para>
</listitem>
</varlistentry>
<varlistentry><term>0.7, never released</term>
<listitem>
<para>The changes between 0.6 and 0.7 are quite extensive. Most dramatically,
support for tables has been rewritten from scratch; see <filename>dbtable.dsl
</filename> for more info.</para>
<para>Changes to <filename>dblib.dsl</filename>; the general function library:<itemizedlist>
<listitem><para>Added <literal>expand-children</literal> to replace elements
of a node list with the children of those elements. This is used, for example,
to make sure that a list of all the chapters of a book can be constructed
by expanding the <literal>PART</literal> elements in the node list returned
by <literal>(children book)</literal> with their children.</para>
</listitem>
<listitem><para>Moved <literal>book-start?</literal> to <filename>dbcommon.dsl
</filename>. It's specific to a particular class of DTDs (those with <literal>
BOOK</literal>s ;-).</para>
</listitem>
<listitem><para>Fixed a serious bug in case conversion; the letter &ldquo;A&rdquo;
couldn't be shifted to lower case.</para>
</listitem>
<listitem><para>Added <literal>constant-list</literal>, returns a list of
&ldquo;n&rdquo; copies of a specified value.</para>
</listitem>
<listitem><para>Added <literal>list-head</literal>, returns the first &ldquo;n&rdquo;
items from a list.</para>
</listitem>
<listitem><para>Added <literal>list-put</literal>, replaces a single value
in a list.</para>
</listitem>
<listitem><para>Added <literal>decrement-list-members</literal>. Maybe this
isn't so useful in general, but it decrements all the members of a list of
numbers by a specified value.</para>
</listitem>
<listitem><para>Added <literal>sgml-root-element</literal>. Returns the root
of the document. There's a better way to do this, right?</para>
</listitem>
<listitem><para>Added <literal>length-string-number-part</literal>. Given
a string of the form &ldquo;25pt&rdquo;, this function returns the &ldquo;25&rdquo;.
</para>
</listitem>
<listitem><para>Added <literal>length-string-unit-part</literal>. Given a
string of the form &ldquo;25pt&rdquo;, this function returns the &ldquo;pt&rdquo;.
</para>
</listitem>
</itemizedlist></para>
<para>Changes to <filename>dbcommon.dsl</filename>; the common library:<itemizedlist>
<listitem><para>Moved <literal>book-start?</literal> from <filename>dblib.dsl
</filename>.</para>
</listitem>
<listitem><para>Added <literal>first-chapter?</literal>. Returns true if the
node specified is the first <literal>CHAPTER</literal> of a <literal>BOOK
</literal>. (This includes the first chapter inside a <literal>PART</literal>.)
</para>
</listitem>
<listitem><para>Added <literal>major-component-element-list</literal> for
the revised &ldquo;fast forward&rdquo; code. See <literal>dbnavig.dsl</literal>.
</para>
</listitem>
<listitem><para>Added a whole bunch of functions for supporting CALS tables
that are shared between the HTML and print versions of the stylesheet.</para>
</listitem>
</itemizedlist></para>
<para>Changes to the HTML stylesheet:<itemizedlist>
<listitem><para>Completely rewrote table processing code.</para>
</listitem>
<listitem><para>Replaced <literal>admon-title-mode</literal> with <literal>
title-mode</literal> in <filename>dbtitle.dsl</filename>.</para>
</listitem>
<listitem><para>Moved support for linked-to <literal>LEGALNOTICE</literal>s
into the mode used for book title pages. This means <literal>LEGALNOTICE</literal>s
and <literal>COPYRIGHT</literal>s elsewhere don't get special treatment.</para>
</listitem>
<listitem><para>Added <literal>$inline-object$</literal>, <literal>$formal-object$
</literal>, and <literal>$semiformal-object$</literal>. Reorganized code for
informal and formal block obects to use these new functions. These functions
explicitly handle titles instead of relying on element construction rules
for the titles.</para>
</listitem>
<listitem><para>Added alt-text as a parameter to the code that supports images.
This allows the contents of the <literal>ALT</literal> tag on, for example, <literal>
EQUATION</literal>s to be passed through.</para>
</listitem>
<listitem><para>Added support for <literal>SUBTITLE</literal>s in most places.
</para>
</listitem>
<listitem><para>Added support for titled <literal>EQUATION</literal>s.</para>
</listitem>
<listitem><para>Localized literal text in support for table footnotes.</para>
</listitem>
<listitem><para>Changed meaning of fast forward and fast backward. These functions
now <emphasis>always</emphasis> go to the next or previous chapter-level element.
</para>
</listitem>
<listitem><para>Navigation banner and title banner now sport the book title
by default. Up is only present if the parent is not the root of the document.
</para>
</listitem>
<listitem><para>Added support for callouts that use <literal>CO</literal>.
</para>
</listitem>
<listitem><para>Fixed table/figure enumeration bugs.</para>
</listitem>
<listitem><para>Improved support for <literal>CMDSYNOPSIS</literal></para>
</listitem>
<listitem><para>Improved support for <literal>FUNCSYNOPSIS</literal></para>
</listitem>
<listitem><para>Added support for <literal>CLASS</literal> on <literal>SGMLTAG
</literal>.</para>
</listitem>
</itemizedlist></para>
</listitem>
</varlistentry>
<varlistentry><term>0.6, 12 Nov 1997</term>
<listitem>
<para>The changes between 0.5 and 0.6 are so extensive that it would be difficult
to document them in detail. All of the files in this distribution have been
updated to have a version number of 0.6.</para>
<para>My primary goal in making these changes was to build a common library
of code for both the print and HTML stylesheets. To achieve this goal, a great
deal of code was moved around and reorganized.</para>
<para>What follows is a short list of the more dramatic changes:</para>
<itemizedlist>
<listitem><para>This style sheet now relies on the common <filename>dblib.dsl
</filename> and <filename>dbcommon.dsl</filename> libraries.</para>
</listitem>
<listitem><para>Changed formatting of division, component, and section titles
from &ldquo;passive&rdquo; to &ldquo;active&rdquo;. Rather than relying on
a rule for <literal>(<replaceable>element</replaceable> TITLE)</literal> to
process the titles, the rules that process the actually element wrappers now
process the titles. This allows optional titles to be formatted correctly.
</para>
</listitem>
<listitem><para>Added support for <literal>Subtitle</literal>s in many places.
</para>
</listitem>
<listitem><para>Added support for <literal>SimpleList</literal>s</para>
</listitem>
<listitem><para>Added support for <literal>GlossSee</literal> and <literal>
GlossSeeAlso</literal>.</para>
</listitem>
<listitem><para>Added <literal>%spacing-paras%</literal> to control whether
or not empty &lt;p> tags are inserted before some block-level elements to
get the &ldquo;right&rdquo; vertical spacing in the browser.  Can you say
hack?</para>
</listitem>
<listitem><para>Lots of other little bug fixes.</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>Version 0.5, 27 Oct 1997</term>
<listitem>
<itemizedlist>
<listitem><para>Fixed bugs associated with automatically generated TOCs that
contain only one element (when <literal>%force-chapter-toc%</literal> is true).
</para>
</listitem>
<listitem><para>Added <literal>%generate-legalnotice-link%</literal> and the
ability to place <literal>LegalNotice</literal>s in an external file, linked
to from the <literal>Copyright</literal> notice.</para>
</listitem>
<listitem><para>Generate HTML anchors on Figures.</para>
</listitem>
<listitem><para>Fixed a bug in Table and Figure enumeration.</para>
</listitem>
<listitem><para>Replaced <literal>(process-children-trim)</literal> with <literal>
(process-children)</literal> in many places. (Should be done in all?)</para>
</listitem>
<listitem><para>Added support for ENTITYREF on <literal>Graphic</literal>
and <literal>InlineGraphic</literal></para>
</listitem>
<listitem><para>Changed <literal>DocInfo</literal>, <literal>Sect1Info</literal>,
etc. to process children. This will cause backward compatability problems
for users that have *Info elements but don't want that content displayed.
A future version will fix this problem by making all of the internal containers <literal>
(empty-sosofo)</literal>s.</para>
<para>Added wrappers for handling <literal>Abstract</literal>s in <literal>
DocInfo</literal>.</para>
</listitem>
<listitem><para>Added <literal>%gentext-nav-use-ff%</literal> to toggle use
of &ldquo;fast forwarding&rdquo; in navigation. Fast forwarding adds navigation
elements to skip forward to the next sibling element (i.e. the next chapter)
instead of the next sequential element (i.e. the first sect1).</para>
<para>Added support for fast forward navigation.</para>
</listitem>
<listitem><para>Changed the functions that insert navigational elements to
make insert of graphics easier.</para>
</listitem>
<listitem><para>Added more hooks in <literal>dblink.dsl</literal> to make
customizing titles easier.</para>
</listitem>
<listitem><para>First cut at support for horizontal and vertical spanning
and alignment in tables.</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>Version 0.4, 18 Sep 1997</term>
<listitem>
<itemizedlist>
<listitem><para>Suppress chapter TOC if there's only one element in the TOC.
 Added <literal>%force-chapter-toc%</literal> to force one.</para>
</listitem>
<listitem><para>Changed formatting of <literal>REVHISTORY</literal>.</para>
</listitem>
<listitem><para>Made <literal>$chapter-toc$</literal> always find the appropriate
ancestral component in case it's called from a descendant (such as <literal>
TITLE</literal>).</para>
</listitem>
<listitem><para>Output <literal>NAME</literal> on an anchor for <literal>
VARLISTENTRY</literal>s that have <literal>ID</literal>s.</para>
</listitem>
<listitem><para><emphasis>Big</emphasis> changes to <filename>dbnavig.dsl
</filename> to fix a bug where linking was incorrect when <literal>chunk-skip-first-element-list
</literal> was used.  I think it works now.  See comments in file.</para>
</listitem>
<listitem><para>Added <literal>style-specification</literal> and <literal>
style-specification-body</literal> tags to <filename>docbook.dsl</filename>
and <filename>dbl1*.dsl</filename> so that <literal>OMITTAG YES</literal>
is no longer required in the SGML declaration used by Jade.</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>Version 0.3, 18 Aug 1997</term>
<listitem>
<itemizedlist>
<listitem><para>Added <literal>%gentext-and%</literal> to customization layers.
Replaces literal &ldquo;and&rdquo; in <filename>dbbibl.dsl</filename>.</para>
</listitem>
<listitem><para>The chunking level is now very general. In the distributed
style sheet, any element at the division, component, or block level can be
a chunk. If the function <literal>(chunk? nd)</literal> returns true, the
chunk <literal>nd</literal> will be in a seperate file. (Supporting arbitrary
chunking would require some additional coding in the style sheet.)</para>
</listitem>
<listitem><para>Added support for the <literal>align</literal> attribute on <sgmltag>
GRAPHIC</sgmltag> and <sgmltag>INLINEGRAPHIC</sgmltag>.</para>
</listitem>
<listitem><para>Added support for <sgmltag>ARTICLE</sgmltag>s</para>
</listitem>
<listitem><para>Element titles can be retrieved with <literal>(element-title
nd)</literal>. For xref purposes, these titles will be italic.</para>
</listitem>
<listitem><para>Changed calculation for filenames. The new names are perhaps
not as nice, but they have the necessary generality to support the more arbitrary
chunking.</para>
</listitem>
<listitem><para>Completely reworked the code that calculates previous and
next nodes.</para>
</listitem>
<listitem><para>Added hooks for tailoring the navigation links at the head
and foot of each page.</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
<varlistentry><term>Version 0.2, 08 Aug 1997</term>
<listitem>
<para> <itemizedlist>
<listitem><para>Version 0.2 never publicly released.</para>
</listitem>
<listitem><para> Completely rewrote automatic TOC code. Automatic TOCs are
now built by traversing elements explicitly. Added ability to set depth of
TOC, see <literal>(toc-depth)</literal>.</para>
</listitem>
<listitem><para>Changed format of SIDEBAR. Now a table.</para>
</listitem>
<listitem><para>Added support for META in HEAD.</para>
</listitem>
<listitem><para>Changed <literal>($chapter-toc$)</literal> to use new TOC
code.</para>
</listitem>
<listitem><para>Added navigation to BOOK page, BOOK entity filename is no
longer a constant.</para>
</listitem>
<listitem><para>Added support for PARTs.</para>
</listitem>
<listitem><para>GLOSSARY is now a DL, not a collection of H3's and BLOCKQUOTEs.
</para>
</listitem>
<listitem><para>Rewrote header and footer navigation. Now works correctly
 for a much wider range of component level elements.</para>
</listitem>
<listitem><para>Added support for <literal>&lt;?html-filename></literal>, <literal>
&lt;?html-dir></literal> and <literal>&lt;?html-basename></literal>.</para>
<para> <literal>&lt;?html-filename path/name.ext></literal> sets the name
of the HTML file for the component in which it occurs (note: if the component
contains chunk-level subcomponents without their own <literal>&lt;?html-filename>
</literal>'s, all of them will get the same filename, wreaking havoc). <literal>
&lt;?html-basename base></literal> sets the base name (upon which sub-component
numbers will be appended) for a component. <literal>&lt;?html-dir dir></literal>
sets the directory in which generated HTML files should be placed. Must be
relative, and below, the starting directory.</para>
</listitem>
<listitem><para>Made <sgmltag>CITETITLE</sgmltag> italic.</para>
</listitem>
<listitem><para>Changed to the new method for generating <sgmltag>XREF</sgmltag>
text. See the top of <filename>dblink.dsl</filename>.</para>
</listitem>
<listitem><para>Added <literal>(dirctory-depth)</literal>, <literal>(copy-string)
</literal>, and <literal>(node-list-filter-by-gi)</literal> to library.</para>
</listitem>
<listitem><para>Added new config parameters: <literal>%generate-part-toc%
</literal>, <literal>%html-ext%</literal>, <literal>%use-id-as-filename%</literal>,
and <literal>%html-meta-tags%</literal>.</para>
</listitem>
<listitem><para>Made REFMETA <literal>(empty-sosofo)</literal>. Need to grab
 this info elsewhere to get reasonable HTML formatting, IMHO.</para>
</listitem>
<listitem><para>Changed default TITLE to be a bold string, not an H2.</para>
</listitem>
<listitem><para>Rearranged code in <filename>dblib.dsl</filename>, <filename>
dbhtml.dsl</filename>, and <filename>dbnavig.dsl</filename> (new file). </para>
</listitem>
</itemizedlist></para>
</listitem>
</varlistentry>
<varlistentry><term>In 0.1</term>
<listitem>
<itemizedlist>
<listitem><para> A transmogrification of the print style sheet, so most  elements
are supported</para>
</listitem>
<listitem><para> Support for FOOTNOTE and FOOTNOTEREF, even in tables </para>
</listitem>
<listitem><para> Automatic chunking at the component and SECT1 level </para>
</listitem>
<listitem><para> A navigation system that I'm fond of, but lacking any  real
hooks for customization</para>
</listitem>
<listitem><para> Uses DIV to mark elements so that a browser style sheet could
do even more style stuff</para>
</listitem>
<listitem><para> Optional screened verbatim displays (an idea from Richard
Burton's style sheet).</para>
</listitem>
</itemizedlist>
</listitem>
</varlistentry>
</variablelist><para>This summary is fairly terse. If you have more detailed
questions, ask the maintainer ;-). I've gone to considerable lengths to generalize
the features of this stylesheet and provide hooks for customization. If you
have a need that doesn't seem to have been addressed, feel free to ask me
about it.</para>]]>
<?Pub *0000043835>
