;; $Id: dbl1ru.dsl 1.8 1998/07/19 16:10:53 nwalsh Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://nwalsh.com/docbook/dsssl/
;;

;; ----------------------------- Localization -----------------------------

;; If you create a new version of this file, please send it to
;; Norman Walsh, ndw@nwalsh.com

;; This is revised Russian Localization, modified by 
;; Ilia V. Kouznetsov, kuznetjr@syntext.com

;; Suggestion of I. Kouznetsov: According to my experience of writing 
;; documentation, Russian Words for cross references had better be 
;; abbreviated (just like it is usually done in Russian documents) 
;; because the ends of not abbreviated cross references may vary from 
;; place to place due to the cases of Russian language  

;; The generated text for cross references to elements.  See dblink.dsl
;; for a discussion of how substitution is performed on the %x and #x
;; keywords.
;;

;;
;; Note: Norman Walsh converted ISO Cyrilic 1 entity names into Unicode
;; character references.  Since Jade doesn't support SDATA entities,
;; the ISO entity set didn't help anyway. I may very well have made
;; some mistakes.  Please send corrections, if you make any.
;; 
;; The basis for my conversion was the Unicode character chart at
;; http://charts.unicode.org/Unicode.charts/normal/U0400.html
;;

(define (gentext-ru-xref-strings giname)
  (case giname
    (("APPENDIX") "&Pcy;&rcy;&icy;&lcy;. %n")
    (("BIBLIOGRAPHY") "%t")
    (("BOOK") "%t")
    (("CHAPTER") "&Gcy;&lcy;. %n")
    (("EXAMPLE") "&Pcy;&rcy;&icy;&mcy;. %n")
    (("FIGURE") "&Rcy;&icy;&scy;. %n")
    (("LISTITEM") "%n")
    (("PART") "&CHcy;. %n")
    (("PREFACE") "&Pcy;&rcy;&iecy;&dcy;&icy;&scy;&lcy;&ocy;&vcy;. %t")
    (("PROCEDURE") "&Pcy;&rcy;&ocy;&tscy;. %n, %t")
    (("SECT1") (if %section-autolabel% 
		   "&Rcy;&acy;&zcy;&dcy;. %n" 
		   "&Rcy;&acy;&zcy;&dcy;. %t#c"))
    (("SECT2") (if %section-autolabel% 
		   "&Rcy;&acy;&zcy;&dcy;. %n" 
		   "&Rcy;&acy;&zcy;&dcy;. %t#c"))
    (("SECT3") (if %section-autolabel% 
		   "&Rcy;&acy;&zcy;&dcy;. %n" 
		   "&Rcy;&acy;&zcy;&dcy;. %t#c"))
    (("SECT4") (if %section-autolabel% 
		   "&Rcy;&acy;&zcy;&dcy;. %n" 
		   "&Rcy;&acy;&zcy;&dcy;. %t#c"))
    (("SECT5") (if %section-autolabel% 
		   "&Rcy;&acy;&zcy;&dcy;. %n" 
		   "&Rcy;&acy;&zcy;&dcy;. %t#c"))
    (("STEP") "&SHcy;&acy;&gcy; %n#k")
    (("TABLE") "&Tcy;&acy;&bcy;. %n")
    (else (string-append "[xref to " 
			 (if giname 
			     giname
			     "non-existant element")
			 " unsupported]"))))

;; Indirection in the generated text for cross references.  The first
;; element of the list is used for cross references across element
;; boundries, the second element is used for cross references within
;; the same element
;;
(define (gentext-ru-xref-strings-indirect key)
  (case key
    (("b") '("" ""))
    (("c") '(" in %cg %cn" ""))
    (("d") '("" ""))
    (("k") '(" in %kg %kn" ""))
    (("s") '("" ""))))

;; Should the TOC come first or last?
;;
(define %generate-ru-toc-in-front% #t)

;; gentext-element-name returns the generated text that should be 
;; used to make reference to the selected element.
;;
(define (gentext-ru-element-name giname)
  (case giname
    (("ABSTRACT") "&Acy;&ncy;&ncy;&ocy;&tcy;&acy;&tscy;&icy;&yacy;")
    (("APPENDIX") "&Pcy;&rcy;&icy;&lcy;&ocy;&zhcy;&iecy;&ncy;&icy;&iecy;")
    (("BIBLIOGRAPHY") "[Bibliography in Russian]")
    (("CAUTION") "&Pcy;&Rcy;&IEcy;&Dcy;&Ocy;&Scy;&Tcy;&IEcy;&Rcy;&IEcy;&ZHcy;&IEcy;&Ncy;&Icy;&IEcy;")
    (("CHAPTER") "&Gcy;&lcy;&acy;&vcy;&acy;")
    (("COPYRIGHT") "Copyright")
    (("DEDICATION") "&Pcy;&ocy;&scy;&vcy;&yacy;&shchcy;&acy;&iecy;&tcy;&scy;&yacy;")
    (("EXAMPLE") "&Pcy;&rcy;&icy;&mcy;&iecy;&rcy;")
    (("GLOSSARY") "&Scy;&lcy;&ocy;&vcy;&acy;&rcy;&softcy; &tcy;&iecy;&rcy;&mcy;&icy;&ncy;&ocy;&vcy;")
    (("FIGURE") "&Rcy;&icy;&scy;&ucy;&ncy;&ocy;&kcy;")
    (("IMPORTANT") "&Vcy;&Acy;&ZHcy;&Ncy;&Ocy;")
    (("NOTE") "&Zcy;&Acy;&Mcy;&IEcy;&CHcy;&Acy;&Ncy;&Icy;&IEcy;")
    (("PART") "&CHcy;&acy;&scy;&tcy;&softcy;")
    (("PREFACE") "&Pcy;&rcy;&iecy;&dcy;&icy;&scy;&lcy;&ocy;&vcy;&icy;&iecy;")
    (("PROCEDURE") "&Pcy;&rcy;&ocy;&tscy;&iecy;&dcy;&ucy;&rcy;&acy;")
    (("REFNAME") "&Scy;&scy;&ycy;&lcy;&kcy;&acy;")
    (("REVHISTORY") "&Icy;&scy;&tcy;&ocy;&rcy;&icy;&yacy; &Icy;&zcy;&dcy;&acy;&ncy;&icy;&jcy;")
    (("REVISION") "&Icy;&zcy;&dcy;&acy;&ncy;&icy;&iecy;")
    (("SECT1") "&Rcy;&acy;&zcy;&dcy;&iecy;&lcy;")
    (("SECT2") "&Rcy;&acy;&zcy;&dcy;&iecy;&lcy;")
    (("SECT3") "&Rcy;&acy;&zcy;&dcy;&iecy;&lcy;")
    (("SECT4") "&Rcy;&acy;&zcy;&dcy;&iecy;&lcy;")
    (("SECT5") "&Rcy;&acy;&zcy;&dcy;&iecy;&lcy;")
    (("STEP") "&SHcy;&acy;&gcy;")
    (("TABLE") "&Tcy;&acy;&bcy;&lcy;&icy;&tscy;&acy;")
    (("TIP") "&Pcy;&Ocy;&Dcy;&Scy;&Kcy;&Acy;&Zcy;&Kcy;&Acy;")
    (("TOC") "&Scy;&Ocy;&Dcy;&IEcy;&Rcy;&ZHcy;&Acy;&Ncy;&Icy;&IEcy;")
    (("WARNING") "&Pcy;&Rcy;&IEcy;&Dcy;&Ucy;&Pcy;&Rcy;&IEcy;&ZHcy;&Dcy;&IEcy;&Ncy;&Icy;&IEcy;")
        (else (string-append "UNEXPECTED-ELEMENT-NAME: " giname))))

;; gentext-element-name-space returns gentext-element-name with a 
;; trailing space, if gentext-element-name isn't "".
;;
(define (gentext-ru-element-name-space giname)
  (string-with-space (gentext-element-name giname)))

;; gentext-intra-label-sep returns the seperator to be inserted
;; between multiple occurances of a label (or parts of a label)
;; for the specified element.  Most of these are for enumerated
;; labels like "Figure 2-4", but this function is used elsewhere
;; (e.g. REFNAME) with a little abuse.
;;
(define (gentext-ru-intra-label-sep giname)
  (case giname
    (("EQUATION") "-")
    (("EXAMPLE") "-")
    (("FIGURE") "-")
    (("PROCEDURE") ".")
    (("REFENTRY") ".")
    (("REFERENCE") ".")
    (("REFNAME") ", ")
    (("REFSECT1") ".")
    (("REFSECT2") ".")
    (("REFSECT3") ".")
    (("SECT1") ".")
    (("SECT2") ".")
    (("SECT3") ".")
    (("SECT4") ".")
    (("SECT5") ".")
    (("STEP") ".")
    (("TABLE") "-")
    (("_PAGENUMBER") "-")  ;; page number psuedo element
    (else "")))

;; gentext-label-title-sep returns the seperator to be inserted
;; between a label and the text following the label for the
;; specified element.  Most of these are for use between
;; enumerated labels and titles like "1. Chapter One Title", but
;; this function is used elsewhere (e.g. NOTE) with a little
;; abuse.
;;
(define (gentext-ru-label-title-sep giname)
  (case giname
    (("ABSTRACT") ": ")
    (("APPENDIX") ". ")
    (("CAUTION") "")
    (("CHAPTER") ". ")
    (("EQUATION") ". ")
    (("EXAMPLE") ". ")
    (("FIGURE") ". ")
    (("FOOTNOTE") ". ")
    (("GLOSSSEE") ": ")
    (("GLOSSSEEALSO") ": ")
    (("IMPORTANT") ": ")
    (("NOTE") ": ")
    (("ORDEREDLIST") ". ")
    (("PART") ". ")
    (("PROCEDURE") ". ")
    (("PREFIX") ". ")
    (("REFENTRY") "")
    (("REFERENCE") ". ")
    (("REFSECT1") ". ")
    (("REFSECT2") ". ")
    (("REFSECT3") ". ")
    (("SECT1") ". ")
    (("SECT2") ". ")
    (("SECT3") ". ")
    (("SECT4") ". ")
    (("SECT5") ". ")
    (("STEP") ". ")
    (("TABLE") ". ")
    (("TIP") ": ")
    (("WARNING") "")
    (else "")))

(define ($lot-title-ru$ lotgi)
  (cond ((string=? "TABLE"   lotgi) "&Pcy;&IEcy;&Rcy;&IEcy;&CHcy;&IEcy;&Ncy;&SOFTcy; &Tcy;&Acy;&Bcy;&Lcy;&Icy;&TScy;")
	((string=? "EXAMPLE" lotgi) "&Pcy;&IEcy;&Rcy;&IEcy;&CHcy;&IEcy;&Ncy;&SOFTcy; &Pcy;&Rcy;&Icy;&Mcy;&IEcy;&Rcy;&Ocy;&Vcy;")
	((string=? "FIGURE"  lotgi) "&Pcy;&IEcy;&Rcy;&IEcy;&CHcy;&IEcy;&Ncy;&SOFTcy; &Icy;&Lcy;&Lcy;&YUcy;&Scy;&Tcy;&Rcy;&Acy;&TScy;&Icy;&Jcy;")
	(else "&Pcy;&IEcy;&Rcy;&IEcy;&CHcy;&IEcy;&Ncy;&SOFTcy; ???")))

(define %gentext-ru-start-quote%  (dingbat "ldquo"))

(define %gentext-ru-end-quote%  (dingbat "rdquo"))

(define %gentext-ru-by% "") ;; e.g. Copyright 1997 "by" A. Nonymous
                            ;; Authored "by" Jane Doe

;; WHAT SHOULD THIS BE?

(define %gentext-ru-edited-by% "")
                           ;; "Edited by" Jane Doe

(define %gentext-ru-page% "")

(define %gentext-ru-and% "&icy;")

(define %gentext-ru-bibl-pages% "&Scy;&tcy;&rcy;.")

(define %gentext-ru-endnotes% "&Zcy;&acy;&kcy;&lcy;&yucy;&chcy;&icy;&tcy;&iecy;&lcy;&softcy;&ncy;&ycy;&iecy; &zcy;&acy;&mcy;&iecy;&chcy;&acy;&ncy;&icy;&yacy;")

(define %gentext-ru-table-endnotes% "&Zcy;&acy;&mcy;&iecy;&chcy;&acy;&ncy;&icy;&yacy;:")

(define %gentext-ru-index-see% "See")

(define %gentext-ru-index-seealso% "See Also")
