;; $Id: dbl1dege.dsl 1.6 1998/07/19 16:10:53 nwalsh Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://nwalsh.com/docbook/dsssl/
;;

;; ----------------------------- Localization -----------------------------

;; If you create a new version of this file, please send it to
;; Norman Walsh, ndw@nwalsh.com

;; Thanks to Rainer Feuerstein, fire@informatik.uni-wuerzburg.de and
;; Christian Leutloff, leutloff@sundancer.oche.de for many of these
;; translations.

;; The generated text for cross references to elements.  See dblink.dsl
;; for a discussion of how substitution is performed on the %x and #x
;; keywords.
;;

(define (gentext-dege-xref-strings giname)
  (case giname
    (("APPENDIX") (if %chapter-autolabel%
		      "Anhang %n"
		      "Anhang namens %t"))
    (("ARTICLE") "\U-201C;%t\U-201D;")
    (("BIBLIOGRAPHY") "%t")
    (("BOOK") "%t")
    (("CHAPTER") (if %chapter-autolabel%
		     "Kapitel %n"
		     "Kapitel namens %t"))
    (("EQUATION") "Gleichung %n")
    (("EXAMPLE") "Beispiel %n")
    (("FIGURE") "Abbildung %n")
    (("INFORMALTABLE") "%kg %kn")
    (("LISTITEM") "%n")
    (("PART") "Teil %n")
    (("PREFACE") "%t")
    (("PROCEDURE") "Prozedur %n, %t")
    (("SECT1") (if %section-autolabel% 
		   "Abschnitt %n" 
		   "Abschnitt namens %t#c"))
    (("SECT2") (if %section-autolabel% 
		   "Abschnitt %n" 
		   "Abschnitt namens %t#c"))
    (("SECT3") (if %section-autolabel% 
		   "Abschnitt %n" 
		   "Abschnitt namens %t#c"))
    (("SECT4") (if %section-autolabel% 
		   "Abschnitt %n" 
		   "Abschnitt namens %t#c"))
    (("SECT5") (if %section-autolabel% 
		   "Abschnitt %n" 
		   "Abschnitt namens %t#c"))
    (("STEP") "Schritt %n#k")
    (("TABLE") "Tabelle %n")
    (("TITLE") "%kg %kn")
    (else (string-append "[xref auf " 
			 (if giname 
			     giname
 			     "nicht existierendes Element")
 			 " wird nicht unterst\latin-small-letter-u-with-diaeresis;tzt]"))))

;; Indirection in the generated text for cross references.  The first
;; element of the list is used for cross references across element
;; boundries, the second element is used for cross references within
;; the same element
;;
(define (gentext-dege-xref-strings-indirect key)
  (case key
    (("b") '("" ""))
    (("c") '(" in %cg %cn" ""))
    (("d") '("" ""))
    (("k") '(" in %kg %kn" ""))
    (("s") '("" ""))))

;; Should the TOC come first or last?
;;
(define %generate-dege-toc-in-front% #t)

;; gentext-element-name returns the generated text that should be 
;; used to make reference to the selected element.
;;
(define (gentext-dege-element-name giname)
  (case giname
    (("ABSTRACT") "Zusammenfassung")
    (("APPENDIX") "Anhang")
    (("BIBLIOGRAPHY") "Literaturverzeichnis")
    (("CAUTION") "ACHTUNG")
    (("CHAPTER") "Kapitel")
    (("COPYRIGHT") "Copyright")
    (("DEDICATION") "Widmung")
    (("EQUATION") "Gleichung")
    (("EXAMPLE") "Beispiel")
    (("FIGURE") "Abbildung")
    (("GLOSSARY") "Glossar")
    (("GLOSSSEE") "Siehe")
    (("GLOSSSEEALSO") "Siehe auch")
    (("IMPORTANT") "WICHTIG")
    (("INDEX") "Stichwortverzeichnis")
    (("LEGALNOTICE") "")
    (("MSGAUD") "Zielgruppe")
    (("MSGLEVEL") "Ebene")
    (("MSGORIG") "Herkunft")
    (("NOTE") "Anmerkung")
    (("PART") "Teil")
    (("PREFACE") "Vorwort")
    (("PROCEDURE") "Prozedur")
    (("REFERENCE") "Referenz")
    (("REFNAME") "Name")
    (("REVHISTORY") "Revisions\latin-small-letter-u-with-diaeresis;bersicht")
    (("REVISION") "Revision")
    (("SECT1") "Abschnitt")
    (("SECT2") "Abschnitt")
    (("SECT3") "Abschnitt")
    (("SECT4") "Abschnitt")
    (("SECT5") "Abschnitt")
    (("SIDEBAR") "")
    (("STEP") "Schritt")
    (("TABLE") "Tabelle")
    (("TIP") "TIP")
    (("TOC") "Inhaltsverzeichnis")
    (("WARNING") "WARNUNG")
    (else (string-append "UNERWARTETER ELEMENT NAME: " giname))))

;; gentext-element-name-space returns gentext-element-name with a 
;; trailing space, if gentext-element-name isn't "".
;;
(define (gentext-dege-element-name-space giname)
  (string-with-space (gentext-element-name giname)))

;; gentext-intra-label-sep returns the seperator to be inserted
;; between multiple occurances of a label (or parts of a label)
;; for the specified element.  Most of these are for enumerated
;; labels like "Figure 2-4", but this function is used elsewhere
;; (e.g. REFNAME) with a little abuse.
;;
(define (gentext-dege-intra-label-sep giname)
  (case giname
    (("EQUATION") "-")
    (("EXAMPLE") "-")
    (("FIGURE") "-")
    (("PROCEDURE") ".")
    (("REFENTRY") ".")
    (("REFERENCE") ".")
    (("REFNAME") ", ")
    (("REFSECT1") ".")
    (("REFSECT2") ".")
    (("REFSECT3") ".")
    (("SECT1") ".")
    (("SECT2") ".")
    (("SECT3") ".")
    (("SECT4") ".")
    (("SECT5") ".")
    (("STEP") ".")
    (("TABLE") "-")
    (("_PAGENUMBER") "-")  ;; page number psuedo element
    (else "")))

;; gentext-label-title-sep returns the seperator to be inserted
;; between a label and the text following the label for the
;; specified element.  Most of these are for use between
;; enumerated labels and titles like "1. Chapter One Title", but
;; this function is used elsewhere (e.g. NOTE) with a little
;; abuse.
;;
(define (gentext-dege-label-title-sep giname)
  (case giname
    (("ABSTRACT") ": ")
    (("APPENDIX") ". ")
    (("CAUTION") "")
    (("CHAPTER") ". ")
    (("EQUATION") ". ")
    (("EXAMPLE") ". ")
    (("FIGURE") ". ")
    (("FOOTNOTE") ". ")
    (("GLOSSSEE") ": ")
    (("GLOSSSEEALSO") ": ")
    (("IMPORTANT") ": ")
    (("NOTE") ": ")
    (("ORDEREDLIST") ". ")
    (("PART") ". ")
    (("PROCEDURE") ". ")
    (("PREFIX") ". ")
    (("REFENTRY") "")
    (("REFERENCE") ". ")
    (("REFSECT1") ". ")
    (("REFSECT2") ". ")
    (("REFSECT3") ". ")
    (("SECT1") ". ")
    (("SECT2") ". ")
    (("SECT3") ". ")
    (("SECT4") ". ")
    (("SECT5") ". ")
    (("STEP") ". ")
    (("TABLE") ". ")
    (("TIP") ": ")
    (("WARNING") "")
    (else "")))

(define ($lot-title-dege$ lotgi)
  (cond ((string=? "TABLE"   lotgi) "Tabellenverzeichnis")
	((string=? "EXAMPLE" lotgi) "Beispiele")
	((string=? "FIGURE"  lotgi) "Abbildungsverzeichnis")
	((string=? "EQUATION" lotgi) "Gleichungen")
	(else "???-Verzeichnis")))

(define %gentext-dege-start-quote% "\U-201E;")
(define %gentext-dege-end-quote% "\U-201C;")

(define %gentext-dege-by% "von") ;; e.g. Copyright 1997 "by" A. Nonymous
                           ;; Authored "by" Jane Doe

(define %gentext-dege-edited-by% "Herausgegeben von")
                           ;; "Edited by" Jane Doe

(define %gentext-dege-page% "")

(define %gentext-dege-and% "und")

(define %gentext-dege-bibl-pages% "Seiten")

(define %gentext-dege-endnotes% "Funoten")

(define %gentext-dege-table-endnotes% "Bemerkungen:")

(define %gentext-dege-index-see% "See")

(define %gentext-dege-index-seealso% "See Also")
