#ifndef VERSION
#define VERSION "1.00?"
#endif

#define FALSE 0
#define TRUE  1
#define END_BOUNDARY 2
#define OUTER_BOUNDARY 3

#define PUSH_BOUNDARY  1

#define MIN(a, b)	( (a) < (b) ? (a) : (b) )
#define NUM_OF_ELEM(some_array) ( sizeof (some_array) / sizeof ((some_array)[0]) )
#define PUTC_IN_UTF8(c) \
	( charset_p->type == KNOWN ? Putc_in_UTF8 (c, charset_p->pipe) \
	  : putc (c, charset_p->pipe) )

#define OK 1
#define err_short 2
#define err_long 3
#define err_IO 4
#define err_internal 5
#define err_few_chars 6

enum action_type
  {
    QUERY_CHARSET_NAME, DECODE
  };
struct buffer_type
  {
    unsigned char *start, *header_start, *end, *next;
  };
struct charmap_file_type
  {
    FILE *stream;
    enum charmap_file_format_type
      {
	DEFAULT, TXT
      }
    format;
  };
struct charset_type
  {
    FILE *pipe;
    char name[80];
    enum USASCII_is_subset_type
      {
	NO, IS
      }
    USASCII_is_subset;
    enum charset_type_type
      {
	KNOWN, BUF_PIPE, NON_BUF_PIPE, UNKNOWN, USASCII, UTF8
      }
    type;
    wchar_t *charmap;
  };
struct line_buf_type
  {
    unsigned char *buf;
    size_t length;
  };
struct long2short_options_type
  {
    char *long_option;
    char short_option;
  };
struct mime_header_type
  {
    int content_type;
    int transfer_encoding;
    char boundary[80];
    char headers_charset[80];
    char content_charset[80];
  };

extern const char IO_err[];
extern const char bad_charmap_format[];
extern const char buffer_overflow[];
extern const char incomplete_charmap[];
extern const char internal_err[];
extern const char long_file[];

/*extern const char default_charmap_format[]; */
extern int Debug, verbose;
extern struct charset_type *charset_p;
extern struct charset_type unknown_charset, USASCII_charset, UTF8_charset;
extern struct line_buf_type line;
extern wchar_t unknown_wchar;

extern char *Add_to_buffer (struct buffer_type *buffer_p, char *string);
extern char *Convert (char *to, char *from);
extern void Error (const char *message);
extern FILE *Fopen_charmap
  (char *charmap_filename, struct charmap_file_type *charmap_file_p);
extern int Get_charmap (wchar_t * charmap, \
			struct charmap_file_type *charmap_file, \
			wchar_t unknown_wchar);
extern size_t Getdelim (unsigned char **lineptr, \
    			size_t *current_line_length, \
			int delimiter, FILE *stream);
#define Getline(lineptr, length, stream) Getdelim(lineptr, length, '\n', stream)
extern void Long2short_options (int argc, char **argv, \
    const struct long2short_options_type *long2short_options);
extern void Output_consumed_chars (unsigned char *space_between_enc_words, \
				   unsigned char *charset_name, \
				   size_t charset_name_length, \
				   unsigned char *encoding);
extern inline int Parse_string \
  (char *charmap_format_string, wchar_t * charmap, char *s);
extern inline void Pipe_to_UTF8 (FILE * in_stream);
extern inline int Putc_in_UTF8 (int c, FILE * out_stream);
extern int Str_is_UTF8 (char *charmap_filename);
extern inline int Str_is_boundary \
	(char *linebuf, char *boundary, int push_boundary);
extern int Seek_boundary (FILE * in_stream, char *boundary, int push_boundary);
extern char *Stpcpy (char *To, const char *From);
extern char *Stpncpy (char *To, const char *From, size_t count);
extern int Strcasecmp (const char *str1, const char *str2);
extern int Strcase_has_prefix (const char *string, const char *prefix);
extern int Str_has_prefix (const char *string, const char *prefix);
extern char *Str_str (char *haystack_, char *needle_);
extern inline char *Strtoupper (char *string);
extern int Validate_charset (char *, \
			     enum USASCII_is_subset_type USASCII_is_subset);
extern int parse_message (char *);
extern inline void *xmalloc (size_t size);
extern inline void *xrealloc (void *pointer, size_t size);
extern inline char *xstrdup (const char *string);
/* extern inline char *xstrndup (const char *string, size_t size); */


extern int parse_message (char *);
extern int parse_body (struct mime_header_type *, char *);
extern int parse_header (struct mime_header_type *);
extern char *decode_header_line (enum action_type, \
				 struct buffer_type *headers_buffer_p);
extern void print_state (int);

/*extern int casncmp (const char *, const char *, int); */
extern int decode_quoted_printable (FILE *, FILE *, char *);
extern int nextgetc (FILE *);
extern int decode_base64 (FILE *, FILE *, char *);
extern void write_cte (struct buffer_type *, int, int);
