#include <stdio.h>
#include <libgus.h>
#include <string.h>
#include <assert.h>
#include <malloc.h>

void main()
{
  int i, j;
  struct GUS_STRU_MIDI_DEVICES devices;
  struct GUS_STRU_MIDI_DEVICE_INFO info;
  gus_midi_device_t *odevice, *idevice;
  
  assert( !gus_midi_devices( &devices ) );
  printf( "Device check - %i MIDI interfaces found...\n", devices.count );
  for ( i = 0; i < devices.count; i++ )
    {
      info.device = devices.devices[ i ];
      assert( !gus_midi_device_info( &info ) );
      printf( "Interface 0x%02x info:\n", info.device );
      printf( "  Name              : %s\n", info.name );
      printf( "  Capabilities      :%s%s%s%s\n",
      			info.cap & GUS_MIDI_CAP_INPUT ? " input" : "",
      			info.cap & GUS_MIDI_CAP_OUTPUT ? " output" : "",
      			info.cap & GUS_MIDI_CAP_SYNTH ? " synth" : "",
      			info.cap & GUS_MIDI_CAP_MEMORY ? " memory" : "" );
      if ( info.cap & GUS_MIDI_CAP_OUTPUT )
        {
          odevice = malloc( sizeof( gus_midi_device_t ) );
          assert( !gus_midi_fill_device_structure(
          				odevice,
          				GUS_MIDI_OPEN_MODE_WRITE,
          				devices.devices[ i ],
          				0xffff ) );
        }
       else
        odevice = NULL;
      if ( info.cap & GUS_MIDI_CAP_INPUT )
        {
          idevice = malloc( sizeof( gus_midi_device_t ) );
          assert( !gus_midi_fill_device_structure(
          				idevice,
          				GUS_MIDI_OPEN_MODE_READ,
          				devices.devices[ i ],
          				0xffff ) );
        }
       else
        idevice = NULL;
      if ( odevice )
        odevice -> next = idevice;
#if 0
      printf( "odevice = 0x%lx, idevice = 0x%lx\n", (long)odevice, (long)idevice );
#endif
      assert( !gus_midi_open( 
      			  odevice ? ( idevice ? GUS_MIDI_BOTH : GUS_MIDI_OUT ) : GUS_MIDI_IN,
      			  odevice ? odevice : idevice, 512, 0 ) );
      if ( odevice )
        {
          odevice = gus_midi_output_device( devices.devices[ i ] );
          assert( odevice );
          printf( "  Emulation         : " );
          j = gus_midi_emulation_get( odevice -> device );
          switch ( j ) {
            case GUS_MIDI_EMUL_GM:
              printf( "General MIDI" );
              break;
            case GUS_MIDI_EMUL_GS:
              printf( "GM & GS" );
              break;
            case GUS_MIDI_EMUL_MT32:
              printf( "MT-32" );
              break;
            default:
              printf( "<-error->" );
          }
          printf( "\n" );
          printf( "  MIDI device ID    : 0x%x\n", odevice -> midi_device );
          printf( "  MIDI ID number    : 0x%x (%s)\n", odevice -> midi_id_number, gus_midi_device_info_manufacture( odevice ) );
          if ( odevice -> midi_id_number != 0xffff )
            {
              printf( "  MIDI family       : 0x%x (%s)\n", odevice -> midi_family_code, gus_midi_device_info_family( odevice ) );
              printf( "  MIDI family num   : 0x%x (%s)\n", odevice -> midi_family_number_code, gus_midi_device_info_product( odevice ) );
              printf( "  MIDI software rev : 0x%x\n", odevice -> midi_software_revision );
            }
        }
      gus_midi_close();
    }
}
