#include "m_pd.h"

/* ------------------------ rightshift~ ----------------------------- */

static t_class *rightshift_class;

typedef struct _rightshift
{
    t_object x_obj;
} t_rightshift;

static t_int *rightshift_perform(t_int *w)
{
    t_float *in = (t_float *)(w[1]);
    t_float *out= (t_float *)(w[2]);
    int n = (int)(w[3]);

    while (--n) *--out = *--in;
    *--out = 0;
    return (w+4);
}

static void rightshift_dsp(t_rightshift *x, t_signal **sp)
{
    int n = sp[0]->s_n;
    dsp_add(rightshift_perform, 3,
    	sp[0]->s_vec + n - 1, sp[1]->s_vec + n, n);
}

static void *rightshift_new()
{
    t_rightshift *x = (t_rightshift *)pd_new(rightshift_class);
    outlet_new(&x->x_obj, gensym("signal"));
    return (x);
}

void rightshift_setup(void)
{
    rightshift_class = class_new(gensym("rightshift"), rightshift_new, 0,
    	sizeof(t_rightshift), 0, 0);
    class_addmethod(rightshift_class, nullfn, gensym("signal"), 0);
    class_addmethod(rightshift_class, rightshift_dsp, gensym("dsp"), 0);
}
