// delay.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#ifdef __GNUG__
#pragma implementation
#endif

#include "delay.h"
#include "valuerequester.h"

Delay::Delay(Data* output) : SimpleFunction(output),
	stack(nil), counter(0), stackSize(1), stackMax(0) {}

Delay::Delay(Data* output, int nsdelay)
		: SimpleFunction(output),
		  stack(nil), counter(0), stackSize(nsdelay) {
	initialize();
}

Modifier *
Delay::create(DataEditor* de) {
	return nil;
}

Delay::~Delay() { delete [] stack; }

Requester *
Delay::createRequester() {
	return new RangedValueRequester<int>(
		"Add Delay to Selected Region:", "Delay (in frames):",
		stackSize,
		PositiveIntegers
	);
}

void
Delay::initialize() {
	if(stackSize > 0) {	// no need to process if delay == 0
		stack = new double[stackSize];
		stackMax = stackSize - 1;
		clear();
		SimpleFunction::initialize();
	}
}

void
Delay::clear() {
	for(int i=0; i < stackSize; i++) stack[i] = 0;
}

double
Delay::operator () (double input) {
	double out = getPast();
	push(input);
	increment();
	return out;
}

void
Delay::restoreState() {
	clear();
	counter = 0;
}

Modifier *
Delay::createUnDo() {
	return nil;
}
