/*
 *  @(#) obuffer_sparc.h 1.2, last edit: 21 Nov 1994 13:27:30
 *  @(#) Copyright (C) 1993, 1994 Tobias Bading (bading@cs.tu-berlin.de)
 *  @(#) Berlin University of Technology
 *
 *  Idea and first implementation for u-law output with fast downsampling by
 *  Jim Boucher (jboucher@flash.bu.edu)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 *  Changes from version 1.2 to 1.3:
 *    - SparcObuffer uses asynchronous audio output now.
 *	Calculated PCM samples are stored in a ringbuffer and written to
 *	the audio device by a signal handler. The handler works with either
 *	SIGIO or SIGALRM signals.
 *    - should work with SPARC 5 machines, if the audio patch is installed
 *	correctly. But don't ask me what's correct in this matter,
 *	please ask Sun.
 */

#ifndef OBUFFER_SPARC_H
#define OBUFFER_SPARC_H

#define USE_TIMER
	  // if USE_TIMER is defined, audio output is done via setitimer()
	  // and SIGALRM signals, else SIGIO signals are being used.


// a class for direct sound output on SPARC 10 machines (dbri device)
// and SPARC 5 machines (audiocs device) (SPARC 20 ???)
// or if ULAW is defined:
// a class for direct sound output on SPARCs using a 8 kHz
// 8-bit u-law audio device: (audioamd)
class SparcObuffer : public Obuffer
{
private:
  static uint32		ringbuffersize;		// size of ringbuffer (in bytes)
#ifdef ULAW
  static ulawsample	*buffer;		// ringbuffer
  static ulawsample	*tail;			// position for next sample
#else
  static int16		*buffer;		// ringbuffer
  static int16		*tail[2];		// position for next sample per channel
  static uint32		channels;		// number of channels (1 or 2)
#endif
  static char		*head;			// next byte for the audio device
  static boil		buffer_empty;		// buffer empty?
  static boil		handler_activated;	// signal_handler() is activated and
						// can receive signals, if True
  static boil		drain_buffer;		// drain ringbuffer completely, if True
  static int		audio_fd;		// filedescriptor for /dev/audio
#ifdef USE_TIMER
  static itimerval	timerval;		// timer value for setitimer()
#endif

  static int		open_audio_device (void);

  static void		signal_handler (void);
			  // works as a SIGALRM handler if USE_TIMER is defined,
			  // else as SIGIO handler

#ifdef Solaris
  static void		get_device_type (int fd, audio_device *);
#else
  static int		get_device_type (int fd);
#endif

public:
#ifdef ULAW
		SparcObuffer (Header *, boil use_speaker, boil use_headphone,
			      boil use_line_out, float volume);
#else
		SparcObuffer (uint32 number_of_channels, Header *, boil use_speaker,
			      boil use_headphone, boil use_line_out, float volume);
#endif

	       ~SparcObuffer (void);

  void		append (uint32 channel, int16 value);

  void		write_buffer (int) { cerr << "don't call me!\n"; }
		  // This function is obsolete, because signal_handler() does the output now.

#ifdef ULAW
  static boil	class_suitable (uint32 number_of_channels, boil force_amd);
		  // returnvalue == False: no u-law audio output possible (class unsuitable)
#else
  static boil	class_suitable (void);
		  // returnvalue == False: no 16-bit audio output possible (class unsuitable)
#endif
};

#endif
