
#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif

#ifndef __cplusplus
#include <StringList.h>
#endif

struct playlist_item {
   char *name;
   char *path;
   int length;
   int pos;
   struct player_plugin *player;
   struct playlist_item *next;
   struct playlist_item *prev;
};

typedef struct {
   struct playlist_item *first;
   struct playlist_item *last;
   int length;
} PlayList;

struct player_plugin {
   void (*init) (void);
   void (*config) (char *left, char *right);
   void (*seek_to_frame) (int second);
   int (*play) (int start_second, char *song);
   void (*pause_it) (void);
   void (*stop) (int playing);
   int (*is_file) (char *path);
   void (*get_info) (struct playlist_item * song);
   void (*version_info) (char *id, char *version, char *copyright);
   char *id;
   char *version;
   char *copyright;
   void *handle;
   int loaded;
   char *soname;
   struct player_plugin *next;
};

#ifdef __cplusplus
extern "C" {
#endif

   extern int setup_audio(int frequency, int stereo, int sign, int big, int sixteen);
   extern void set_bitrate(int bit);
   extern void close_audio(void);
   extern void flush_audio(void);
   extern int end_of_song;
   extern int parsebool(char *data);
   extern int audio_play(char *buffer, int size);
   extern int exists(char *s);
#ifdef __cplusplus
}

#endif
