
#ifndef PLAYLIST_H
#define PLAYLIST_H

struct playlist_item {
   char *name;
   char *path;
   int length;
   int pos;
   struct player_plugin *player;
   struct playlist_item *next;
   struct playlist_item *prev;
};

typedef struct {
   struct playlist_item *first;
   struct playlist_item *last;
   int length;
} PlayList;

void setcurposition(PlayList * plist, int pos);
void copylist(PlayList * source, PlayList * dest);
void printlist(PlayList * plist);
void makelistofnums(PlayList * plist, int numbers);
void clearplaylist(PlayList * plist);
PlayList *shuffle_list(PlayList * plist);
int loadplaylist(char *file);
int saveplaylist(PlayList * plist, char *file);
void addplaylist(char *path);
void move_one(int number, int direction);
void delete_one(int number);
void renumber_list(PlayList * plist, int prefix);
void sort_list(PlayList * plist, int strip);
void add_one(int number, struct playlist_item *add);
void setplugsplaylist(PlayList * plist);

#endif
