
#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif

#include <config.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <Imlib.h>
#include <StringList.h>
#include "oscil.h"

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

typedef struct {
   short *buf;
   int bufsize;
   int bufnum;
   int fps;
   int lag;
   double scale_x;
   Window win;
   int place;
   int w, h;
   int num;
} OscilData;

OscilData *o_data;
extern Display *disp;
extern int screen;
extern ImlibData *imlib;
extern Window root;
GC oscil_fg;

void oscil(void)
{
   int x, i;
   static int bnum;
   XPoint oscil_p[48];
   int origin;
   int num = o_data->bufsize / 48;
   int middle = o_data->h / 2;

   bnum = (((int) (o_data->num - o_data->lag) % o_data->bufnum) + o_data->bufnum) % o_data->bufnum;
   origin = bnum * o_data->bufsize * 2;
   XClearWindow(disp, o_data->win);
   XFlush(disp);
   for (x = 0; x < 48; x++) {
      int val = 0;

      for (i = 0; i < num * 2 + 1; i++)
	 val += (int) o_data->buf[origin + (x * num * 2) + i];
      val /= (13655 * 2);
      oscil_p[x].x = x * o_data->scale_x;
      oscil_p[x].y = middle + val;
   }
   XDrawLines(disp, o_data->win, oscil_fg, oscil_p, 48, CoordModeOrigin);
   XFlush(disp);
   o_data->num++;
   if (o_data->num >= o_data->bufnum)
      o_data->num = 0;
}

void do_analysis(char *buffer, int size)
{
   int temp, place;

   temp = o_data->bufsize * 4 - o_data->place;
   place = o_data->num * o_data->bufsize * 2;
   if (size != o_data->bufsize * 4) {
      if (temp == size) {
	 memcpy((char *) &o_data->buf[place] + o_data->place, buffer, size);
	 o_data->place = 0;
	 oscil();
	 return;
      }
      if (size < temp) {
	 memcpy((char *) &o_data->buf[place] + o_data->place, buffer, size);
	 o_data->place += size;
	 return;
      }
      memcpy((char *) &o_data->buf[place] + o_data->place, buffer, temp);
      o_data->place = 0;
      oscil();
      do_analysis(buffer + temp, size - temp);
      return;
   }
   memcpy((char *) &o_data->buf[place] + o_data->place, buffer, size);
   o_data->place = 0;
   oscil();
}

int init_analysis(Window win, int w, int h)
{
   int size;
   int num;

   o_data = Emalloc(sizeof(OscilData));
   o_data->w = w;
   o_data->h = h;
   o_data->win = win;
   o_data->fps = 37;
   o_data->bufsize = size = ((44100 / 48) / o_data->fps) * 48;
   o_data->scale_x = (double) o_data->w / 48.0;
   o_data->lag = (10 * 1200) / size;
   num = o_data->lag + 2;
   o_data->bufnum = num;
   o_data->buf = (short *) Emalloc((size * num * 4 + 40) * sizeof(short));
   memset(o_data->buf, 0, (size * num * 4 + 40) * sizeof(short));

   o_data->num = 0;
   o_data->place = 0;
   return o_data->bufsize * 4;
}

void close_analysis(void)
{
   if (o_data->buf)
      Efree(o_data->buf);
   if (o_data)
      Efree(o_data);
   o_data = NULL;
}

void version_info(char *id, char *version, char *copyright)
{
   strcpy(id, "oscil");
   strcpy(version, "0.2");
   strcpy(copyright, "1996-1998 Carsten Haitzler");
}

void config_analysis(char *left, char *right)
{
   XGCValues gcv;
   int n, r, g, b;

   if (!strncmp("BEGIN", left, 5)) {
      oscil_fg = XCreateGC(disp, root, 0, &gcv);
      XSetForeground(disp, oscil_fg, WhitePixel(disp, screen));
   }
   else if (!strncasecmp("COLOR", left, 5)) {
      n = sscanf(right, "%i %i %i", &r, &g, &b);
      if (n != 3) {
	 fprintf(stderr, "Malformed color in oscil's config..\n");
	 r = g = b = 0;
      }
      XSetForeground(disp, oscil_fg, Imlib_best_color_match(imlib, &r, &g, &b));
   }
}
