"""
  conv_text.py - convert Doc to/from text
  $Id: conv_text.py,v 1.4 1998/09/09 11:55:30 rob Exp $

  Copyright 1998 Rob Tillotson <rob@io.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License, version 2,
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.


"""

__version__ = '$Id: conv_text.py,v 1.4 1998/09/09 11:55:30 rob Exp $'


import sys, os, string, formatter, re

from PDA.Palm.App import Doc

import DocWriter

class TextParser:
    def __init__(self, w, options):
	self.writer = w
	self.options = options
	self.do_markup = 0
	self.tag_regex = ''
	self.case_fold_tags = 0
	self.tag_prefix = None
	
    def __call__(self, fd):
	self.fd = fd
	w = self.writer
	self.verbatim = w.has_option('verbatim')
	if self.do_markup: self.do_markup = not w.has_option('no-tags')

	if self.do_markup:
	    if self.tag_prefix:
		rx_markup = re.compile(self.tag_regex %
				       re.escape(w.get_option('tag-prefix',
							      self.tag_prefix)))
	    else:
		rx_markup = re.compile(self.tag_regex)

	self.formatter = formatter.AbstractFormatter(w)
	self.in_para = 0
	
	while 1:
	    l = self.fd.readline()
	    if not l: break
	    if self.do_markup:
		m = rx_markup.match(string.rstrip(l))
		if m:
		    tag, arg = m.group('tag','arg')
		    if self.case_fold_tags: tag = string.lower(tag)
		    meth = 'tag_' + tag
		    if hasattr(self, meth):
			apply(getattr(self, meth), (arg,))
			continue
		    elif hasattr(self, 'tag'):
			if not self.tag(tag, arg):
			    continue
			
	    if self.verbatim:
		self.formatter.add_literal_data(l)
	    else:
		if not string.strip(l):
		    if self.in_para:
			in_para = 0
			self.formatter.end_paragraph(1)
		else:
		    self.in_para = 1
		    self.formatter.add_flowing_data(l)

class TextWithTagsParser(TextParser):
    def __init__(self, *a, **kw):
	apply(TextParser.__init__, (self,)+a, kw)
	self.do_markup = 1
	self.tag_regex = "^%s\s*(?P<tag>[a-zA-Z0-9/_]+)(?:\s*(?P<arg>.*)\s*)?"
	self.case_fold_tags = 0
	self.tag_prefix = '.'
    def tag_TITLE(self, arg):
	if not self.writer.has_title(): self.writer.set_title(arg)
    def tag_BOOKMARK(self, arg):
	self.writer.set_bookmark(arg)
    tag_BM = tag_BOOKMARK
    def tag_H1(self, arg):
	self.formatter.end_paragraph(1)
	self.writer.send_heading(arg, 1)
    def tag_H2(self, arg):
	self.formatter.end_paragraph(1)
	self.writer.send_heading(arg, 2)
    def tag_H3(self, arg):
	self.formatter.end_paragraph(1)
	self.writer.send_heading(arg, 3)
    def tag_H4(self, arg):
	self.formatter.end_paragraph(1)
	self.writer.send_heading(arg, 4)
    def tag_H5(self, arg):
	self.formatter.end_paragraph(1)
	self.writer.send_heading(arg, 5)
    def tag_H6(self, arg):
	self.formatter.end_paragraph(1)
	self.writer.send_heading(arg, 6)
    def tag_PRE(self, arg):
	self.verbatim = 1
    def tag(self, tag, arg):
	if tag == '/PRE': self.verbatim = 0
	else:
	    return 1
    def tag_HR(self, arg):
	self.writer.send_hor_rule()


parsers = {
    'none': TextParser,
    'default': TextWithTagsParser,
    }

# The input-type option is not yet supported
def text_to_doc(fd, w, title=None, options=None, default_title='Untitled'):
    p = parsers.get(w.get_option('input-type','default'),
		       TextParser)(w, options)

    p(fd)

    if not w.has_title():
	w.set_title(default_title)
	    

def doc_to_text(docname, fd, dlp=None):
    if dlp:
	doc = Doc.openDocRemote(dlp, docname, 'r')
    else:
	doc = Doc.openDoc(docname, 'r')

    while 1:
	l = doc.readline()
	if not l: break
	fd.write(l)

    doc.close()


# really need to flesh this out :)
def totext_main(argv):
    for fn in argv[1:]:
	doc_to_text(fn, sys.stdout)


def todoc_main(argv):
    from cmdproc import CmdLine
    c = CmdLine('text',
		[('verbatim', 'direct conversion; do not process text'),
		 ('no-tags',  'do not process embedded tags'),
		 ('tag-prefix', 'string that marks embedded tags')])
    c.process_options(argv)
    c.process_files(text_to_doc)
    
