/*  VER 101  TAB P   $Id: server.c,v 1.11 1998/09/09 07:32:13 src Exp $
 *
 *  NNTP server interface
 *
 *  copyright 1996, 1997 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 *
 *  $Log: server.c,v $
 *  Revision 1.11  1998/09/09 07:32:13  src
 *  Version 1.1
 *
 *  Revision 1.10  1998/09/03 02:19:39  src
 *  Fixed noaction error exit
 *
 *  Revision 1.9  1998/09/02 06:50:31  src
 *  newsx version 1.0
 *
 *  Revision 1.8  1998/09/02 06:34:41  src
 *  Support @-syntax in newsfeeds, and support AUTHINFO GENERIC
 */

#include "common.h"
#include "proto.h"
#include "options.h"
#include "statistics.h"
#include "nntp.h"

#include <errno.h>

/*
 *  currently open socket pair, for read and write
 */
SOCKET_D nntp_sock;

/* trivial function: let people get at the socket if they need to.
 * This is used in AUTHINFO GENERIC: we handle authentication via
 * a child process, which needs the file descriptors of the socket
 * so it can talk to the server.        -- PMM 08/1998
 */
SOCKET_D *current_socket()
{
    return &nntp_sock;
}

/*
 *  open an NNTP server connection
 *  returns servers initial response code  
 *  if it is -1, try to give up as soon as possible
 */
int 
open_server(char *host,char *port)
{
    int sts;
    char line[NNTP_STRLEN];
    char *endptr;

    /* first try and make the connection */
    if (via_exec) {
	progtitle("connecting pgm");

	program_open(via_exec, &nntp_sock);
    } else {
	progtitle("connecting");

	if ((socket_open(host, port, &nntp_sock)) < 0)
	    return -1;
	log_msg(L_INFO,"connecting to %s server at %s", port, host);
    }

    if (connect_exec) {
	/* execute command when initiating */
	progtitle("exec cmd");
						
	log_msg(L_DEBUGMORE,"running \"%s\"", connect_exec);
	fflush(nntp_sock.w_str);                       
	if ((sts = script(connect_exec,        
		       /* in */  fileno(nntp_sock.r_str),
		       /* out */ fileno(nntp_sock.w_str))) != 0) {
	    /* connect failed */
	    log_msg(L_ERR,"connect script failed, status is %d",sts);
	    exit_cleanup(11);
	}
	log_msg(L_DEBUG,"connect script finished");
    }

    progtitle("await greeting");
    /* flush possible garbage */
    do {
	/* greeting */
	if (!get_server_nntp(line,sizeof (line))) {
	    /* timeout */
	    exit_cleanup(9);
	}
	
    } while (!isdigit(line[0]));

    /* banner code */
    return strtoul(line,&endptr,10); 
}

/*
 *  close NNTP connection
 *  false if server timeout etc.
 */
int
close_server(int urgent)
{
    char line[NNTP_STRLEN];

    if (urgent) {
	progtitle("aborting server");
	timeout = URGENT_TIMEOUT;
    } else {
	progtitle("closing server");
    }
    sprintf(line, "QUIT%s", newline);
    if (!put_server(line)) return 0;
    if (!get_server_nntp(line,sizeof (line))) return 0;

    socket_close(&nntp_sock);
    return 1;
}

/*
 *  read a line from server
 *  return 0 on timeout and other severe problems
 */
int get_server_nntp(char *line, int size)
{
    int len;

    if (noaction_opt) {
	line[0] = '\0';
	return 1;
    }
    if (!get_socket(line, size, &nntp_sock)) {
	return 0;
    }
    len = strlen(line);
    gross_bytecount += len;
    log_msg(L_GET,"%s", line);

    /* no CRLF */
    while (len > 0 && (line[len-1]=='\r' || line[len-1]=='\n')) {
	line[--len] = '\0';
    }

    return 1;
}

/*
 *  read message part from server
 *  any CRLF will not be removed
 *  do not keep gross_bytecount up to date
 *  return 0 on timeout and other severe problems
 */
int 
get_server_msg(char *line, int size)
{
    if (noaction_opt) {
	line[0] = '\0';
	return 1;
    }
    if (!get_socket(line, size, &nntp_sock)) {
	return 0;
    }
    if (debug_opt >= 7) {
	log_msg(L_GET,"%s", line);
    }
    return 1;
}

/*
 *  write an NNTP command line to server
 *  with no debug log
 */
int
put_server_nolog(char *line)
{
    if (noaction_opt) return 1;

    gross_bytecount += strlen(line);
    return put_socket(line, &nntp_sock);
}

/*
 *  write an NNTP command line to server
 *  return nonzero if problems
 */
int
put_server(char *line)
{
    log_msg(L_PUT,"%s", line);
    return put_server_nolog(line);
}

/*
 *  write message part to server, 
 *  a newline may or may not be added
 *  return 0 on timeout and other problems
 */
int 
put_server_msg(char *line)
{
    if (debug_opt >= 7) {
	log_msg(L_PUT,"%s",line);
    }
    if (noaction_opt) return 1;

    gross_bytecount += strlen(line);
    return put_socket(line, &nntp_sock);
}
