/*  VER 110  TAB P   $Id: active.c,v 1.9 1998/09/09 07:32:10 src Exp $
 *
 *  handle the local active file
 *
 *  copyright 1996, 1997 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 *
 *  $Log: active.c,v $
 *  Revision 1.9  1998/09/09 07:32:10  src
 *  Version 1.1
 *
 *  Revision 1.8  1998/09/06 06:21:03  src
 *  Improved bad syntax message
 *
 *  Revision 1.7  1998/09/03 05:14:30  src
 *  Improved bad syntax messages
 *
 *  Revision 1.5  1998/09/03 02:49:29  src
 *  Fixed stuff detected by -Wall
 *
 *  Revision 1.4  1998/07/12 09:39:27  src
 *  newsx version 1.0
 */

#include "common.h"
#include "proto.h"
#include "options.h"
#include "news.h"

/* 
 *  globals for active 
 */
typedef struct active_grp {
    struct active_grp *next;
    char seen;
    char name[1]; /* extend as required... */
} ACTIVE_GRP;

#define ACTIVE_HASH 1023
ACTIVE_GRP *activegrp[ACTIVE_HASH] = { 0 };

/*
 *  find group on active list
 */
static ACTIVE_GRP *
find_active(char *group)
{
    ACTIVE_GRP *ap;
    long h = hashindex(group,ACTIVE_HASH);

    for (ap = activegrp[h]; ap; ap = ap->next) {
	if (strcmp(ap->name,group)==0) return ap;
    }
    return 0; /* not in list... */
}

/*
 *  add group to list of active groups
 */
static void
active_group(char *group)
{
    int n; 
    ACTIVE_GRP *ap;
    long h = hashindex(group,ACTIVE_HASH);

    if (!group[0] || !sys_allow(group)) return;

    /* BUG: check if already? */
    n = sizeof(ACTIVE_GRP) + strlen(group);

    if (!(ap = malloc(n))) {
	log_msg(L_ERRno,"out of memory");
	exit_cleanup(1);
    }
    /* add to list of active groups at that hashindex */
    ap->seen = 0;
    strcpy(ap->name,group);
    ap->next = activegrp[h];
    activegrp[h] = ap;
}

/*
 *  see if group is on active list
 */
int 
is_in_active(char *group)
{
    return find_active(group) ? 1 : 0;
}

/*
 *  see if group is on active list, and is not yet seen
 *  mark it as seen 
 */
int 
is_active(char *group)
{
    ACTIVE_GRP *ap;

    if (!(ap = find_active(group))) {
	return 0; /* not in list... */
    }
    if (ap->seen) return 0; /* seen already... */
    ap->seen = 1;
    return 1;
}

/*
 *  go through all groups in the active list that is not yet seen    
 *  NOTE: the in-core active list will be lost
 */
int 
unseen_active(char *group)
{
    int ok = 0;
    ACTIVE_GRP *ap;
    static int latest_h = 0;
    int h;

    for (h=latest_h; h<ACTIVE_HASH; ++h) {
	while ((ap = activegrp[h])) {
	    if (!ap->seen) {
		strcpy(group,ap->name);
		ok = 1;
	    }
	    activegrp[h] = ap->next;
	    free(ap);
	    if (ok) {
		latest_h = h;
		return 1;
	    }
	}
    }
    latest_h = 0;
    return 0;
}

/*
 *  load local active file
 *  assumes load_sys has been performed
 *  return true if more
 */
void
load_active(void)
{
    FILE *f;
    int n;
    char activename[PATH_MAX];
    char buf[BUFSIZ];
    char *p;
    char group[BUFSIZ];
    long a,b;
    char isact;
    int clean = 1;

    progtitle("read active");

    build_alt_filename(activename,news_home(),ACTIVE,active);

    if (!(f = fopen(activename,"r"))) {
	log_msg(L_ERRno,"can't open \"%s\"",activename);
	exit_cleanup(8);
    }
    log_msg(L_DEBUG,"reading %s",activename);

    /* load local active file */
    while (fgets(buf,BUFSIZ,f)) {
	p = buf;
	if (clean) {
	    while (isspace(*p)) ++p;
	    if (p[0] && p[0] != '#') {
		n = sscanf(p,"%[^ \n\t!:] %ld %ld %c",group,&a,&b,&isact);
		if (!bad_syntax(buf,n,4,activename)) {
		    if (isact == 'y' || isact == 'm') {
			/* group is active */
			active_group(group);
		    }
		}
	    }
	}
	/* see if line is excessively long */
	p += strlen(p);
	clean = (p > buf && *(p-1) == '\n');
    }
    fclose(f);
}

/*
 *  clear local active file
 *  NOTE: looses allocated memory
 */
void
clear_active(void)
{
    int h;

    for (h=0; h<ACTIVE_HASH; ++h) {
	activegrp[h] = 0;
    }
}


/*
 *  check if bad syntax
 */
int
bad_syntax(char *buf,int was,int expect,char *where)
{
    char *p;

    if (was == expect) return 0;

    /* there may be a trailing newline */
    if ((p=strchr(buf,'\n')) && p[1]=='\0') *p = '\0';
    else p = 0;

    log_msg(L_ERR,"bad syntax in %s (item %d of %d) \"%s\"",
					  where,was+1,expect,buf);
    if (p) *p = '\n';
    return 1;
}
