/*
Copyright (c) 1998 Peter Zelezny.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include <unistd.h>
#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <errno.h>
#include <ctype.h>


char *nocasestrstr(char *text, char *tofind)  // like strstr(), but nocase
{
   char *ret = text, *find = tofind;
   
   while(1)
   {
      if(*find == 0) return ret;
      if(*text == 0) return 0;
      if(toupper(*find) != toupper(*text))
      {
	ret = text+1;
	find = tofind;
      } else
	find++;
      text++;
   }
}

char *errorstring(int err)
{
   static char tbuf[16];
   switch(err)
   {
    case ECONNREFUSED: return("Connection refused");
    case EHOSTUNREACH: return("No route to host");
    case ETIMEDOUT: return("Connection timed out");
   }
   sprintf(tbuf, "%d", err);
   return(tbuf);
}

int waitline(int sok, char *buf, int bufsize)
{
   int i = 0;

   while(1)
   {
      if(read(sok, &buf[i], 1) < 1) return -1;
      if(buf[i] == '\n')
      {
	 buf[i] = 0;
	 return i;
      }
      i++;
      if(i == (bufsize-1)) return 0;
   }
}
