
# Command name: /filterkick
# Description:  All users with matching addresses will be kicked
#               from the channel.
#
# Date:         03.03.98
# Author:       Andreas Gelhausen, atte@gecko.north.de
#
# Changes:      03.03.98  Now this script can automatically be loaded
#                         from tkirc (~.tkirc/autoload/) and you
#                         don't need to change your tkircrc!
#
# Install:
#               1. copy this file to `~/.tkirc/autoload/filterkick.tcl'
#               2. reload your tkircrc or restart tkirc


proc on_command_filterkick {window arguments} {
  global chan win
  set len [lLength "$arguments"]
  if {$len < 2} {
    print2crap "+++ Usage: /filterkick <channel> <pattern>"
    return
  }

  set count 0
  set channel "[lIndex "$arguments" 0]"
  if {"$channel" == "*"} {
    set channel "$win($window,actual)"
  }
  set cnum [GetChannelNumber "$channel"]
  if {$cnum != -1} {
    set pattern "[lIndex "$arguments" 1]"
    set len [llength "$chan($cnum,nicks)"]
    for {set i 0} {$i < $len} {incr i} {
      if {[strmatch "$pattern" "[lindex "$chan($cnum,addresses)" $i]"]} { 
	send2irc "/kick $channel [lindex "$chan($cnum,nicks)" $i] kick pattern: $pattern"
	incr count
      }
    }
  }
  if {$count == 0} {
    print2crap "+++ No matching address found for pattern `$pattern'"
  } elseif {$count == 1} {
    print2crap "+++ One matching address found (kick was sent)"
  } else {
    print2crap "+++ $count matching addresses found (kicks were sent)"
  }
}
