/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996, 1997, 1998 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    bhor0533@lehr.chem.TU-Berlin.DE
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#ifdef FreeBSD
#include <sys/errno.h>
#endif
#if !defined HP_UX
#include <fcntl.h>
#endif
#include <sys/wait.h>
#include <sys/types.h>
#include <pwd.h>
#ifdef HAS_SHADOW_PASSWD
#include <shadow.h>
#endif
#include "connect.h"
#include "main.h"
#ifdef unicos
#define PFTP_THREAD_CAST (void *(*)(void *))
#else
#define PFTP_THREAD_CAST (void *)
#endif

extern void set_tty(int);
extern void accs(void);
extern void handler(int);
extern void server_filter_programm(void *);
extern int set_filter(short, short);
extern void receive_data(void *);
extern void free_memory(void);
extern int init_struct(void);
extern short get_var_from_pftprc(const char *, char *, short);
extern short check_login(int, int);

/*
 * Server--This is the server part of pftp.
 */
void Server(int portn)
{
   char hostname[64];
   FILE *fp=NULL;
   int ns=0, ws=0, setopt=1, optval=(*statstr)->bsize, size=0;
   struct hostent *hp;
   struct sockaddr_in sin, fsin;
   int sinlen, fsinlen=sizeof(fsin);
   int pid=0;
   int strnum=0;
#ifdef USE_POSIX_THREAD
   pthread_t thr;
   pthread_attr_t thrattr;

   pthread_attr_init(&thrattr);
   pthread_attr_setdetachstate(&thrattr, PTHREAD_CREATE_DETACHED);
#endif

   /*
    * Set signal SIGINT.
    */
   signal(SIGINT, handler);
   signal(SIGQUIT, handler);
   signal(SIGCHLD, SIG_IGN);

   /*
    * Set stderr.
    */
   if (!slfp) {
      char *slogname = NULL;
      if ((slogname = getenv("PFTPSLOG")));
      else {
         MEM_CHECK((slogname = (char *)calloc(SONAME, sizeof(char))));
         if (!get_var_from_pftprc("PFTPSLOG", slogname, 0)) {
            free(slogname);
            slogname = NULL;
         }
      }
      if (slogname) {
         if ((slfp = fopen(slogname, "a")) == NULL) {
            fprintf(stderr, "** %s: %s\n", slogname, _PFTP_ERROR_ARRAY_);
            exit(1);
         }
         chmod(slogname, 0600);
         if (!getenv("PFTPSLOG")) free(slogname);
      }
      if (!(*statstr)->OVERWRITE) (*statstr)->_SKIP_ = 1;
   }

   /*
    * Started by inetd.
    */
   if (((*statstr)->_PFTP_DAEMON_ & BIT_TWO)) {
      s = dup(0);
      dup2(ns, 0);
      dup2(ws, 2);
      close(1);
   }
   else {
      /*
       * Before we can do anything, we need to know
       * our hostname.
       */
      gethostname(hostname, sizeof(hostname));
      if (slfp) fprintf(slfp, "\n*** %s is waiting for %s on port %d ***\n\n", hostname, (*statstr)->_STANDARD_INPUT_ ? "a stream" : "file(s)", portn);

      /*
       * Set server filter if '-f' was given on cmdline.
       */
      set_filter(1, 0);

      /*
       * Now we look up our host to get
       * its network number.
       */
      if ((hp = (struct hostent *)gethostbyname(hostname)) != NULL) {
         memcpy(&sin.sin_addr, hp->h_addr, hp->h_length);
      }
      else if (!(sin.sin_addr.s_addr = inet_addr(hostname))) {
         if (slfp) fprintf(slfp, "%s: unknown host.\n", hostname);
         exit(1);
      }

      /*
       * Create the address we will be connected to.
       */
      sinlen = sizeof(sin);
      bzero((char *)&sin, sinlen);
      sin.sin_family = AF_INET;
      sin.sin_port = htons(portn);
      sin.sin_addr.s_addr = htonl(INADDR_ANY);

      /*
       * Get a socket and set options on it.
       */
      accs();
      if (setsockopt(s, SOL_SOCKET, SO_REUSEADDR, (char *)&setopt, sizeof(setopt)) < 0) {
            if (slfp) fprintf(slfp, "** setsockopt: %s\n", _PFTP_ERROR_ARRAY_);
            exit(1);
      }
      if (setsockopt(s, SOL_SOCKET, SO_RCVBUF, (char *)&optval, sizeof(optval)) < 0) {
            if (slfp) fprintf(slfp, "** setsockopt: %s\n", _PFTP_ERROR_ARRAY_);
            exit(1);
      }

      /*
       * Try to bind the address to the socket.
       */
      if (bind(s, (struct sockaddr *)&sin, sinlen) < 0) {
         if (slfp) fprintf(slfp, "** bind: %s\n", _PFTP_ERROR_ARRAY_);
         exit(1);
      }
   }

   while (s) {
      if ((*statstr)->OVERWRITE==1) (*statstr)->OVERWRITE=0;
      if (!((*statstr)->_PFTP_DAEMON_ & BIT_TWO)) {
         /*
          * Listen on the socket.
          */
         if (listen(s, (*statstr)->_STANDARD_INPUT_ ? 1: MAXCLIENTS) < 0) {
            if (slfp) fprintf(slfp, "** listen: %s\n", _PFTP_ERROR_ARRAY_);
            exit(1);
         }

         /*
          * Accept connections.  When we accept one, ns
          * will be connected to the client.
          */
         if ((ns = accept(s, (struct sockaddr *)&fsin, &fsinlen)) < 0) {
            if (slfp) fprintf(slfp, "** accept: %s\n", _PFTP_ERROR_ARRAY_);
            exit(1);
         }
         ws = ns;
      }
      else {
         if (getpeername(ns, (struct sockaddr *)&fsin, (int *)&fsinlen) < 0) {
            if (slfp) fprintf(slfp, "** getpeername: %s\n", _PFTP_ERROR_ARRAY_);
            exit(1);
         }
      }

      /*
       * Get client's host name.
       */
      if ((hp = gethostbyaddr((char *)&fsin.sin_addr, sizeof(fsin.sin_addr), AF_INET)) == 0) {
         size = 12;
         MEM_CHECK(((*statstr)->REMOTEHOSTNAME = (char *)calloc(size, sizeof(char))));
         strcpy((*statstr)->REMOTEHOSTNAME, ".unkown_host");
      }
      else {
         (*statstr)->size = size = strlen(hp->h_name) + 1;
         if ((*statstr)->REMOTEHOSTNAME) free((*statstr)->REMOTEHOSTNAME);
         MEM_CHECK(((*statstr)->REMOTEHOSTNAME = (char *)calloc(size, sizeof(char))));
         strcpy((*statstr)->REMOTEHOSTNAME, hp->h_name);
      }

      /*
       * Check if remote server has a valid host name.
       */
      if (*_CLIENTHOSTNAME_) {
         int i, loc=0, cl, isok=0, length = strlen((*statstr)->REMOTEHOSTNAME);

         for (cl=0; _CLIENTHOSTNAME_[cl] && !isok; cl++) {
            loc = strlen(*(_CLIENTHOSTNAME_+cl));

            if (length < loc) {
               continue;
            }
            else if (*_CLIENTHOSTNAME_[cl] == '.') {
               loc--;
               for (i=length-1; loc; loc--, i--) {
                  if (*(_CLIENTHOSTNAME_[cl]+loc) != tolower(*((*statstr)->REMOTEHOSTNAME+i))) break;
               }
               if (!loc) isok = 1;
            }
            else if (length == loc) {
               isok=1;
               for (i=0; i < length; i++) {
                  if (*(_CLIENTHOSTNAME_[cl]+i) != tolower(*((*statstr)->REMOTEHOSTNAME+i))) {
                     isok = 0;
                     break;
                  }
               }
            }
         }
         if (!isok) {
            if (slfp) fprintf(slfp, "** Connection to %s refused.\n", (*statstr)->REMOTEHOSTNAME);
            if (shutdown(ns, 2) < 0) {
               if (slfp) fprintf(slfp, "** shutdown: %s\n", _PFTP_ERROR_ARRAY_);
               exit(1);
            }
            if ((*statstr)->_STANDARD_INPUT_ || ((*statstr)->_PFTP_DAEMON_ & BIT_TWO)) {
               if (shutdown(s, 2) < 0) {
                  if (slfp) fprintf(slfp, "** shutdown: %s\n", _PFTP_ERROR_ARRAY_);
                  exit(1);
               }
               s = 0;
               break;
            }
            continue;
         }
      }
      if (*((*statstr)->REMOTEHOSTNAME) == '.') {
         *((*statstr)->REMOTEHOSTNAME) = ' ';
         *((*statstr)->REMOTEHOSTNAME+7) = ' ';
      }
      if (setsockopt(ns, SOL_SOCKET, SO_RCVBUF, (char *)&optval, sizeof(optval)) < 0) {
         if (slfp) fprintf(slfp, "** setsockopt: %s\n", _PFTP_ERROR_ARRAY_);
         exit(1);
      }
#if !defined HP_UX
      fcntl(ns, F_SETFL, FASYNC);
      fcntl(2, F_SETFL, FASYNC);
#endif
#ifdef USE_POSIX_THREAD
      strnum = init_struct();
      if (!strnum) {
         if (slfp) fprintf(slfp, "\n** Connection to %s refused.\n", (*statstr)->REMOTEHOSTNAME);
         if (shutdown(ns, 2) < 0) {
            if (slfp) fprintf(slfp, "** shutdown: %s\n", _PFTP_ERROR_ARRAY_);
            (*(statstr+strnum))->free = 1;
            exit(1);
         }
         if (((*statstr)->_PFTP_DAEMON_ & BIT_TWO)) s = 0;
         (*(statstr+strnum))->free = 1;
         continue;
      }
#else
      strnum = 0;
#endif
      (*(statstr+strnum))->ns = dup(ns);
      (*(statstr+strnum))->ws = dup(ws);
      if (write((*(statstr+strnum))->ws, "PFTP ", 6) < 0) {
         if (slfp) fprintf(slfp, "** write: %s\n", _PFTP_ERROR_ARRAY_);
      }
      if (write((*(statstr+strnum))->ws, VERSION, strlen(VERSION)) < 0) {
         if (slfp) fprintf(slfp, "** write: %s\n", _PFTP_ERROR_ARRAY_);
      }
      if (write((*(statstr+strnum))->ws, "\n", 1) < 0) {
         if (slfp) fprintf(slfp, "** write: %s\n", _PFTP_ERROR_ARRAY_);
      }

      /*
       * If running as a daemon or
       * server started by inetd...
       */
      if ((*statstr)->_PFTP_DAEMON_) {
         if (!check_login(ns, strnum)) {
            if ((*statstr)->_PFTP_DAEMON_ & BIT_TWO) {
               shutdown(s, 2);
               s = 0;
            }
            continue;
         }
      }
      else {
         /*
          * Send status to the client.
          */
         if (write((*(statstr+strnum))->ws, "STAT server\n", 13) < 0) {
            if (slfp) fprintf(slfp, "** write: %s\n", _PFTP_ERROR_ARRAY_);
         }
         MEM_CHECK(((*(statstr+strnum))->home = (char *)calloc(SONAME, sizeof(char))));
         strcpy((*(statstr+strnum))->home, getenv("HOME"));
         strcat((*(statstr+strnum))->home, PFTPRESOURCE);
      }
      if (slfp) fflush(slfp);

      if (*filter) {
         if (slfp && !(*statstr)->_PFTP_DAEMON_) fprintf(slfp, "\n* Filter is receiving data from %s ...\n", (*statstr)->REMOTEHOSTNAME);
         if (!(*statstr)->_STANDARD_INPUT_ && !((*statstr)->_PFTP_DAEMON_ & BIT_TWO)) {
            *((*(statstr+strnum))->REMOTEHOSTNAME+size) = '\0';
#ifdef USE_POSIX_THREAD
            /*
             * Create a new thread for the filter routine.
             */
            if ((pid = pthread_create(&thr, &thrattr, PFTP_THREAD_CAST &server_filter_programm, (void *)&strnum)) != 0) {
               if (slfp) fprintf(slfp, "** pthread_create: %s\n", _PFTP_ERROR_ARRAY_PID_);
               exit(1);
            }
#else
            /*
             * Spawn a new process for the filter routine.
             */
            if ((pid = fork()) < 0) {
               if (slfp) fprintf(slfp, "** fork: %s\n", _PFTP_ERROR_ARRAY_);
               exit(1);
            }

            /*
             * Here starts the filter process.
             */
            if (!pid) {
               server_filter_programm((void *)&strnum);
               s = 0;
            }
#endif /* USE_POSIX_THREAD */
         }
         /*
          * Filtered standard input/output or '-i' specified.
          */
         else {
            server_filter_programm((void *)&strnum);
            s = 0;
         }
      }
      else if (!((*statstr)->_STANDARD_INPUT_) && !((*statstr)->_PFTP_DAEMON_ & BIT_TWO)) {
#ifdef USE_POSIX_THREAD
         fp = fdopen(ns, "r");
         *((*(statstr+strnum))->REMOTEHOSTNAME+size) = '\0';
         (*(statstr+strnum))->fp = fp;
         if ((pid = pthread_create(&thr, &thrattr, PFTP_THREAD_CAST &receive_data, (void *)&strnum)) != 0) {
            if (slfp) fprintf(slfp, "** pthread_create: %s\n", _PFTP_ERROR_ARRAY_PID_);
            exit(1);
         }
#else
         if ((pid = fork()) < 0) {
            if (slfp) fprintf(slfp, "** fork: %s\n", _PFTP_ERROR_ARRAY_);
            exit(1);
         }

         if (!pid) {
            signal(SIGCHLD, SIG_DFL);
            signal(SIGINT, SIG_DFL);
            signal(SIGQUIT, SIG_DFL);
            fp = fdopen(ns, "r");
            *((*(statstr+strnum))->REMOTEHOSTNAME+size) = '\0';
            (*(statstr+strnum))->fp = fp;
            receive_data((void *)&strnum);
            fclose(fp);
            s = 0;
         }
#endif /* USE_POSIX_THREAD */
      }
      /*
       * Standard input/output or '-i' specified.
       */
      else {
         fp = fdopen(ns, "r");
         *((*(statstr+strnum))->REMOTEHOSTNAME+size) = '\0';
         if (!((*statstr)->_PFTP_DAEMON_ & BIT_TWO)) {
            setvbuf(fp, \
            (*statstr)->_STDIN_BUFFER_, \
            (*statstr)->_STDIN_BUFFER_ ?  _IOFBF : _IONBF, \
            (*statstr)->_SET_STDIN_BUF_ ? (*statstr)->_STDIN_BUFSIZ_: BUFSIZ);
         }
         (*(statstr+strnum))->fp = fp;
         receive_data((void *)&strnum);
         s = 0;
      }
   }
   shutdown(s, 2);
   free_memory();
   if (*statstr) free(*statstr);
   *statstr = NULL;

   exit(0);
}
