/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996, 1997, 1998 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    bhor0533@lehr.chem.TU-Berlin.DE
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#if defined Linux || defined NEXTSTEP
#include <sys/dir.h>
#endif
#include <errno.h>
#include <dirent.h>
#include <ctype.h>
#include <string.h>
#include "status.h"
#define MAXCLIENTS      5 /* see main.h */
struct status_type  *statstr[MAXCLIENTS+1]; /* status structure vector */
#ifdef USE_POSIX_THREAD
short CHILDNUM=0; /* number of children currently running */
int OUTPUT=0;
#endif
short pftpnoroot=1; /* let root login when running as daemon or from inetd */
int s=0; /* Socket */
FILE *slfp=stderr; /* pointer to stderr or server log file or NULL */
volatile short _WINROWS_; /* Number of rows on the screen */
volatile short _WINCOLS_; /* Number of columns on the screen */
char *pftplog=NULL;  /* holds the name of the log file if any */
#define MAXCLIENTHOSTS 100 /* see main.h */
char *_CLIENTHOSTNAME_[MAXCLIENTHOSTS]; /* specified client host names */
#define SONAME 256 /* see main.h */
char *filter[SONAME]; /* holds the name of the filter program and its arguments */
char *_STDOUT_BUFFER_; /* buffers stdout data */
char *client_destdir=NULL; /* Destination directory if sending to the daemon */
char *data_subject; /* subject of data sent */
char *data_info; /* subject of data sent */

#ifdef USE_POSIX_THREAD
pthread_mutex_t interactiv;
/* void pthread_sync(void *); */
#endif

extern void Server(int);
extern int argum(int, char **, int *);
extern void Client(int, struct client_type *);
extern void set_tty(int);
extern char **run_prog(char **, char *);
extern short set_prog(char **, char *);

int main(int argc, char **argv, char **environ)
{
   int portn=0, y;

   for (y=0; y < SONAME; y++) *(filter+y) = NULL;
   MEM_CHECK(((*statstr) = (struct status_type *)calloc(1, sizeof(struct status_type))));
   for (y=1; y <= MAXCLIENTS; y++) *(statstr+y) = NULL;
   (*statstr)->version          = NULL;
   (*statstr)->sstatus          = NULL;
   (*statstr)->_HOSTNAME_       = NULL;
   (*statstr)->REMOTEHOSTNAME   = NULL;
   (*statstr)->_STDIN_BUFFER_   = NULL;
   (*statstr)->rlogin           = NULL;
   (*statstr)->rpass            = NULL;
   (*statstr)->pw_passwd        = NULL;
   (*statstr)->pw_name          = NULL;
   (*statstr)->pw_dir           = NULL;
   (*statstr)->from             = NULL;
   _STDOUT_BUFFER_              = NULL;
   data_subject                 = NULL;
   data_info                    = NULL;
   (*statstr)->pid              = 0;
   (*statstr)->mul              = 0;
   (*statstr)->lognames         = 0;
   (*statstr)->_STDIN_BUFSIZ_   = 0;
   (*statstr)->_STANDARD_INPUT_ = 0;
   (*statstr)->_PFTP_DAEMON_    = 0;
   (*statstr)->_SET_STDIN_BUF_  = 0;
   (*statstr)->_BANDWIDTH_      = 0;

   /*
    * Get terminal modes if stderr is a terminal.
    */
   if (isatty(2)) set_tty(3);

#ifdef USE_POSIX_THREAD
   pthread_mutex_init(&interactiv, NULL);
#endif
   for (y=0; y < MAXCLIENTHOSTS; y++) _CLIENTHOSTNAME_[y] = NULL;

   /*
    * Get name of resource file.
    */
   MEM_CHECK(((*statstr)->home = (char *)calloc(SONAME, sizeof(char))));
   if (!getuid()) {
      strcpy((*statstr)->home, PFTPSYSTEMRC);
   }
   else {
      strcpy((*statstr)->home, getenv("HOME"));
      strcat((*statstr)->home, PFTPRESOURCE);
   }

   /*
    * Checking options.
    */
   y = argum(argc, argv, &portn);

   /*
    * Get Portnumber.
    */
   if (argc > 1) {
      if (!portn || (atoi(argv[1]) > 0 && strlen(argv[1]) < 6)) {
         portn = atoi(argv[1]);
      }
    }
   if (!((*statstr)->_PFTP_DAEMON_ & BIT_TWO) && portn < 1025) {
      fprintf(stderr, "** Portnumber has to be bigger then 1024.\n");
      exit(1);
   }
   else if (((*statstr)->_PFTP_DAEMON_ & BIT_TWO) && portn < 1) {
         if (slfp) fprintf(slfp, "**\n** The resource file contains no default portnumber.\n**\n");
         exit(1);
   }
#ifdef TIOCNOTTY
   else if (((*statstr)->_PFTP_DAEMON_ & BIT_ONE) && y) {
      /*
       * Clear the controlling terminal.
       */
#if !defined ULTRIX && !defined FreeBSD && !defined NEXTSTEP && !defined SunOS && !defined OpenBSD && !defined OSF1
      if (ioctl(1, TIOCNOTTY, (char *)NULL) < 0) {
         fprintf(stderr, "** ioctl: %s\n", _PFTP_ERROR_ARRAY_);
         exit(1);
      }
#endif
      close(2);
   }
#endif

   /*
    * Start the server.
    */
   if (y) {
      pid_t p_pid=0;

      if (!isatty(2) || slfp != stderr) {
         if (!(*statstr)->_SKIP_ && !(*statstr)->OVERWRITE) {
            (*statstr)->_SKIP_ = 1;
         }
      }
#ifdef USE_POSIX_THREAD
         CHILDNUM = 0;
#endif
      if ((*statstr)->_PFTP_DAEMON_) {
         /*
          * Start the daemon.
          */
         if (((*statstr)->_PFTP_DAEMON_ & BIT_ONE)) {
            if ((p_pid = fork()) < 0) {
               fprintf(stderr, "** fork: %s\n", _PFTP_ERROR_ARRAY_);
               exit(1);
            }
            if (p_pid) exit(0);
         }
         slfp = NULL;
      }
      else if ((*statstr)->_SET_STDIN_BUF_) {
            fflush(stdout);
            setvbuf(stdout, _STDOUT_BUFFER_, \
            _STDOUT_BUFFER_ ?  _IOFBF : _IONBF, \
            (*statstr)->_SET_STDIN_BUF_ ? (*statstr)->_STDIN_BUFSIZ_: BUFSIZ);
      }
      Server(portn);
   }
   /*
    * Start the client.
    */
   else {
      struct client_type *clientstr;
#ifdef NEXTSTEP
      if ((*statstr)->_RECURS_) {
         fprintf(stderr, "** Sorry, '-r' is not supported for the client on NEXTSTEP systems!\n");
         exit(1);
      }
#endif
      /*
       * Edit the info file if `-m' was given.
       */
      if ((*statstr)->from && data_info && !*data_info) {
         char *editor[SONAME], **tmp;
         if (!set_prog(editor, "PFTPEDITOR")) {
            MEM_CHECK((*editor = (char *)calloc(SONAME, sizeof(char))));
            strcpy(*editor, "vi");
            *(editor+1) = NULL;
         }
         sprintf(data_info, "pftp_info_file_%d", getpid());
         for (tmp=run_prog(editor, data_info); tmp != editor; tmp--) free(*tmp);
      }
      MEM_CHECK((clientstr = (struct client_type *)calloc(1, sizeof(struct client_type))));
#ifdef use_posix_thread
      childnum = -1;
#endif
      clientstr->argc = argc;
      clientstr->argv = argv;
      Client(portn, clientstr);   
   }

   exit(0);
}

#ifdef USE_POSIX_THREAD
int init_struct(void)
{
   int strnum=1;

   for (strnum=1; (*(statstr+strnum)) && (!(*(statstr+strnum))->free) \
         && strnum <= MAXCLIENTS; strnum++);
   if (strnum > MAXCLIENTS) return 0; /* Client will be denied */

   if (!*(statstr+strnum)) MEM_CHECK((*(statstr+strnum) = (struct status_type *)calloc(1, sizeof(struct status_type))));
   (*(statstr+strnum))->_STANDARD_INPUT_ = (*statstr)->_STANDARD_INPUT_;
   (*(statstr+strnum))->_PFTP_DAEMON_    = (*statstr)->_PFTP_DAEMON_;
   (*(statstr+strnum))->_RECURS_         = (*statstr)->_RECURS_;
   (*(statstr+strnum))->lol              = (*statstr)->lol;
   (*(statstr+strnum))->OVERWRITE        = (*statstr)->OVERWRITE;
   (*(statstr+strnum))->_SKIP_           = (*statstr)->_SKIP_;
   (*(statstr+strnum))->_OPTIONS_        = (*statstr)->_OPTIONS_;
   (*(statstr+strnum))->usefilter        = (*statstr)->usefilter;
   (*(statstr+strnum))->size             = (*statstr)->size;
   (*(statstr+strnum))->pid              = (*statstr)->pid;
   (*(statstr+strnum))->free             = 0;
   (*(statstr+strnum))->mul              = 0;
   (*(statstr+strnum))->pw_passwd        = NULL;
   (*(statstr+strnum))->pw_name          = NULL;
   (*(statstr+strnum))->pw_dir           = NULL;
   (*(statstr+strnum))->from             = NULL;
   if ((*statstr)->REMOTEHOSTNAME) {
      if ((*(statstr+strnum))->REMOTEHOSTNAME) free((*(statstr+strnum))->REMOTEHOSTNAME);
      MEM_CHECK(((*(statstr+strnum))->REMOTEHOSTNAME = (char *)calloc((*(statstr+strnum))->size, sizeof(char))));
      strcpy((*(statstr+strnum))->REMOTEHOSTNAME, (*statstr)->REMOTEHOSTNAME);
   }
   else (*(statstr+strnum))->REMOTEHOSTNAME = (char *)NULL;
   if (!CHILDNUM) OUTPUT=0;
      
   return strnum;
}
#endif
#define HUNAME               32767
#define LONAME               1024

long dir_size(char **name)
{
   char *sargv[HUNAME];
   DIR *ff;
   long size=0;
   int c=0;
   struct stat buf;
#if defined Linux || defined NEXSTEP
   struct direct *dir;
#else
   struct dirent *dir;
#endif

   for (; *name && !stat(*name, &buf); name++) {
      if ((buf.st_mode & S_IFREG)) {
         size += buf.st_size;
      }
      else if ((buf.st_mode & S_IFDIR)) {
         if ((ff = opendir(*name))) {
            size += buf.st_size;
            while ((dir = readdir(ff))) {
               if (dir->d_ino && strcmp(".", dir->d_name) && strcmp("..", dir->d_name)) {
                  MEM_CHECK((*(sargv+c) = (char *)calloc(LONAME, sizeof(char))));
                  strcpy(*(sargv+c), *name);
                  if (sargv[c][strlen(*(sargv+c))-1] != '/') strcat(*(sargv+c), "/");
                  strcat(*(sargv+c), dir->d_name);
                  c++;
               }
            }
            closedir(ff);
         }
         *(sargv+c) = NULL;
         size += dir_size(sargv);
         do {
            c--;
            if (sargv[c]) free(sargv[c]);
         } while (c);
      }
   }
   return size;
}


void display_pa(char **pa, char *first_line, char *second_line, int palines) {
   int j=0, num=0, last=1, height=_WINROWS_ - 4, plength=0, mnum=0;
   int scrollup=0, scrolldown=0;
   short update_lastline=0;
   char c='\0', *pattern=NULL, *str=NULL, *blankline=NULL;
   char **tmp, *ctmp=NULL, *lastline=NULL, *endline=NULL;
   
   MEM_CHECK((str = (char *)calloc(SONAME, sizeof(char))));
   MEM_CHECK((pattern = (char *)calloc(SONAME, sizeof(char))));
   *pattern = '\0';
   MEM_CHECK((lastline = (char *)calloc(SONAME, sizeof(char))));
   sprintf(lastline, "[%dH     <q> quit, </> search, < > more, <b> back, <UP> up, <DOWN> down ***", _WINROWS_);
   for (j=0, ctmp=lastline; *ctmp != 'H'; ctmp++, j++);
   for (ctmp=lastline; *ctmp; ctmp++);
   for (; ctmp - lastline < _WINCOLS_+j; ctmp++) *ctmp = '*';
   *ctmp='\r';
   *++ctmp='\0';
   MEM_CHECK((endline = (char *)calloc(SONAME, sizeof(char))));
   sprintf(endline, "[%dH     <q> quit, </> search, < > quit, <b> back, <UP> up ***", _WINROWS_);
   for (j=0, ctmp=endline; *ctmp != 'H'; ctmp++, j++);
   for (ctmp=endline; *ctmp; ctmp++);
   for (; ctmp - endline < _WINCOLS_+j; ctmp++) *ctmp = '*';
   *ctmp='\r';
   *++ctmp='\0';
   MEM_CHECK((blankline = (char *)calloc(SONAME, sizeof(char))));
   for (ctmp=blankline; ctmp - blankline < _WINCOLS_; ctmp++) *ctmp = ' ';
   *ctmp='\r';
   *++ctmp='\0';

   /*
    * Clear screen.
    */
   fprintf(stdout, "[H[J");

   do {
      if (palines - num < height) {
         num = palines - height + 1;
         scrollup = 0;
      }
      if (num < 0) {
         num = 0;
         scrolldown = 0;
      }
      if (last != num || c == '') {
         if ((!scrollup && !scrolldown) || ((scrollup || scrolldown) && update_lastline)) {
            if (num <= palines - height) {
               fprintf(stdout, lastline);
            }
            else {
               fprintf(stdout, endline);
            }
            update_lastline = 0;
         }
         if (scrollup) {
            fprintf(stdout, "[3;%dr[%dH", _WINROWS_-1, scrollup+4);
         }
         else if (scrolldown) {
            fprintf(stdout, "[3;%dr[3HM[3H", _WINROWS_-2);
         }
         else {
            fprintf(stdout, "[1;%dr[%dH%s", _WINROWS_, _WINROWS_-1, blankline);
            fprintf(stdout, "[H%s", first_line);
            fprintf(stdout, "[2H%s[%dH", second_line, scrollup+3);
         }
         for (last=j=num+scrollup; j < height + num - scrolldown && j <= palines; j++) {
            fprintf(stdout, "%s%s", mnum == j ? ">": " ", *(pa+j));
         }
         if (scrollup) fprintf(stdout, "[3H>");
         scrollup = scrolldown = 0;
         update_lastline = 0;
      }
      fflush(stdout);
      fprintf(stdout, "[%dH%3d%%", _WINROWS_, height <= palines ? ((num+height-1)*100)/palines: 100);
      while ((c = fgetc(stdin)) == '' || c == '[');
      switch(c) {
         case ' ': case '6':
            if (palines - num < height) c = 'q';
            else num += height;
            break;
         case 'd':
            if (palines - num < height) c = 'q';
            else num += height/2;
            break;
         case 'b': case '5':
            num -= height;
            break;
         case 'u':
            num -= height/2;
            break;
         case '': case '': case 'A':
            if (num) {
               if (num + height > palines && !update_lastline) fprintf(stdout, "[%dH%s", _WINROWS_, lastline);
               num--;
               fprintf(stdout, "[%dH \n", mnum-num+2);
               scrolldown = height - 1;
            }
            break;
         case '\n': case 'B':
            if (palines - num >= height) {
               scrollup = height - 1;
               num++;
            }
            break;
         case 'D': case 'h':
            c = 'q';
            break;
         case '':
            fprintf(stdout, "[H[J");
            break;
         case 'g':
            num = 0;
            break;
         case 'G':
            num = palines - height + 1;
            break;
         case 'N':
            plength = 1;
            if (*pattern && (plength = strlen(pattern))) {
               mnum--;
               for (tmp=pa+mnum; tmp+1 != pa && plength; tmp--) {
                  for (ctmp=*tmp; *(ctmp+1); ctmp++) {
                     if (!strncmp(pattern, ctmp, plength)) {
                        mnum = num = tmp - pa;
                        plength = 0;
                        last--;
                     }
                  }
               }
               if (!num) last = palines;
            }
            else {
               fprintf(stderr, "[%dH%s", _WINROWS_, blankline);
               fprintf(stderr, "     No search pattern.");
               plength = 0;
               update_lastline = 1;
            }
            if (plength) {
               mnum++;
               fprintf(stderr, "[%dH%s", _WINROWS_, blankline);
               fprintf(stderr, "     `%s' not found.", pattern);
               update_lastline = 1;
            }
            break;
         case 'n':
            plength = 1;
            if (*pattern && (plength = strlen(pattern))) {
               mnum++;
               for (tmp=pa+mnum; tmp - pa <= palines && plength; tmp++) {
                  for (ctmp=*tmp; *(ctmp+1); ctmp++) {
                     if (!strncmp(pattern, ctmp, plength)) {
                        mnum = num = tmp - pa;
                        plength = 0;
                        last--;
                     }
                  }
               }
            }
            else {
               fprintf(stderr, "[%dH%s", _WINROWS_, blankline);
               fprintf(stderr, "     No search pattern.");
               last = num;
               plength = 0;
               update_lastline = 1;
            }
            if (plength) {
               mnum--;
               fprintf(stderr, "[%dH%s", _WINROWS_, blankline);
               fprintf(stderr, "     `%s' not found.", pattern);
               last = num;
               update_lastline = 1;
            }
            break;
         case '/':
            fprintf(stdout, "[%dH%s", _WINROWS_, blankline);
            fprintf(stdout, "[?25h\r[%s]: ", pattern);
            plength = 0;
            ctmp = str;
            *ctmp = '\0';
            do {
               c = fgetc(stdin);
               switch(c) {
                  case '\n':
                     *ctmp = '\0';
                     c = '\0';
                     break;
                  case '':
                     *str = '\0';
                     plength = -1;
                     break;
                  case '': case '':
                     if (ctmp > str) {
                        fprintf(stderr, "\b \b");
                        *--ctmp = '\0';
                     }
                     plength--;
                     break;
                  default:
                     if (isprint(c)) {
                        *ctmp++ = c;
                        fprintf(stderr, "%c", c);
                        plength++;
                     }
                     break;
               }
            } while (c && plength >= 0);
            if ((!*pattern && !plength) || plength < 0) {
               last--;
               fprintf(stdout, "[?25l\r");
               break;
            }
            if ((plength = strlen(str))) strcpy(pattern, str);
            if ((plength = strlen(pattern))) {
               mnum++;
               for (tmp=pa+mnum; tmp - pa <= palines && plength; tmp++) {
                  for (ctmp=*tmp; *(ctmp+1); ctmp++) {
                     if (!strncmp(pattern, ctmp, plength)) {
                        num = tmp - pa;
                        plength = 0;
                        last--;
                     }
                  }
               }
            }
            if (plength) {
               fprintf(stderr, "[%dH                                                                       \r", _WINROWS_);
               fprintf(stderr, "     `%s' not found.", pattern);
               last = num;
               update_lastline = 1;
            }
            fprintf(stdout, "[?25l\r");
      }
      if (c != '' && c != 'n' && c != 'N' && c != '/') {
         mnum = num;
         if (mnum < 0) mnum = 0;
         if (c == ' ' && mnum > palines - height + 1) mnum = palines - height + 1;
      }
   } while (c != 'q');
   fprintf(stdout, "[1;%dr[%dH%s", _WINROWS_, _WINROWS_, blankline);
   if (endline) free(endline);
   if (lastline) free(lastline);
   if (blankline) free(blankline);
   if (pattern) free(pattern);
   if (str) free(str);
}


#ifdef NEXTSTEP
int putenv(const char *str)
{
   extern char **environ;
   char **envi=environ;
   
   for (envi=environ; *envi; envi++) {
      if (strncmp(*envi, str, strlen(str))) {
	 MEM_CHECK((*envi = (char *)calloc(SONAME, sizeof(char))));
         strcpy(*envi, str);
         break;
      }
   }
   if (!*envi) {
      MEM_CHECK((*envi = (char *)calloc(SONAME, sizeof(char))));
      strcpy(*envi, str);
      *++envi=NULL;
   }
   return 0;
}
#endif
