.COMMENT SCCS_data: @(#) XmpTable.man 1.4 92/10/28 07:50:44
.TH "XmpTable" 3 "1 March 1992"
.SH NAME
XmpTable \- Motif Public Table Widget
.SH SYNOPSIS
.ta 1.5i 2.5i
.nf
.ft B
In C++ or C:

#include <X11/Intrinsic.h>
#include <X11/Xmp/Table.h>

Widget newTable = XtCreateWidget( name, xmpTableWidgetClass, pw, ... );
Widget another = XmpCreateTable( pw, name, arglist, argcount );
.fi
.ft R
.SH LINK BY
.nf
.ft B
example% ld -o prog prog.o -lXmp -lXm <WclOption> -lXmu -lXt -lX11
.ft R
.fi
.LP 
.I XmpTable
does not require the use of Wcl, but the author obviously
encourages its use ;^).  See 
.I Wcl(3)
for usage and linking of Wcl.
.SH DESCRIPTION
.LP
.I XmpTable
is a manager widget which allows widgets to be arranged in a tabular
form.  The
.I XmpTable
widget has a 
.B layout
resource which is used to specify the column and row position of each
child.  Children can span rows and/or columns.  Layout options
are available to control the initial sizes, justification, and dynamic resizing
of children.
.LP
Amazing as this may sound,
.I XmpTable
is internally fully object-oriented, but all methods and members of internal
objects are in fact accessible to client applications.  Rather than
being pedantic about "information hiding", the author tries to follow
the principle that
.I XmpTable
is going to be used by programmers, and programmers sometimes need to
do things the author did not foresee.  The structures and methods of
the
.I XmpTable
and all of its component objects are declared in the
.B TableP.h
include file.  Some methods which some may find useful are
.B XmpTableLocFindPosition()
and
.B XmpTableLocFind()
which clients can use to find the location information for widgets at
some specific location in an
.I XmpTable,
or for some specific widget in an
.I XmpTable.
.sp 1
.SS "Classes"
.I XmpTable
inherits behavior and resources from \fBCore\fP, \fBComposite\fP,
\fBConstraint\fP, \fBXmManager\fP, and \fBXmBulletinBoard\fP classes.
.PP
The class pointer is \fBxmpTableWidgetClass\fP.
.PP
The class name is \fBXmpTable\fP.
.sp 1
.SS "New Resources"
The following table defines a set of widget resources used by the programmer
to specify data.  The programmer can also set the resource values for the
inherited classes to set attributes for this widget.  To reference a
resource by name or by class in an application defaults file, remove the
\fBXtN\fP or \fBXtC\fP prefix and use the remaining letters. 

The codes in the access column indicate if the given resource can be
set at creation time (\fBC\fP),
set by using \fBXtSetValues\fP (\fBS\fP),
retrieved by using \fBXtGetValues\fP (\fBG\fP),
or is not applicable (\fBN/A\fP).
.nf

XmpTable Resource Set
Name              Class             Type         Default Access

XtNlayout         XtCLayout         XmpTableLoc  NULL    CSG
XtNdefaultOptions XtCDefaultOptions XmpTableOpts NULL    CSG
XtNshrinkSimple   XtCShrinkSimple   Boolean      True    CSG
XtNforceShrink    XtCForceShrink    Boolean      True    CSG
XtNcolumnSpacing  XtCSpacing        int          0       CSG
XtNrowSpacing     XtCSpacing        int          0       CSG
.fi
.IP "\fBXtNlayout\fP"
Specifies the column, row, column span, row span, and options for each
child.  The options field is optional, and takes the identical form of
the \fBXtNdefaultOptions\fP resource discussed below.  If no options
are specified for a child, that childs options will be the value of the
\fBXtNdefaultOptions\fP resource when the child is first managed.
Children which are not named in the layout specification are positioned
in column 0, row 0, with colum and row spans of 1, and using the
default options.  If the layout is changed after the
.I XmpTable
is created, then a complete re-layout is performed.  The internal type
\fBXmpTableLoc\fP which must be passed to \fBXtCreateWidget()\fP or to
\fBXtSetValues()\fP is obtained by passing a string representation of
the layout specification to \fBXmpTableLocParse()\fP which will be
discussed below.  A layout resource consists of one layout
specification per named child, with each layout specification being
separated (or terminated) by a ";" and with each layout specification
of the form:
.RS
.RS
.sp 2
.nf
\fB<name> <col> <row> [<opts>]\fP
.fi
.RE
.RE
.IP "\fBXtNdefaultOptions\fP"
Specifies the layout options which apply to all children which do not
have specific layout options in the child's layout specification.  The
layout options allow a child widget to be justified within the table
cell, and allow the initial size and dynamic resizing of children to be
constrained.  Combinations of options can be used: \fBtr\fP means top
and right, or north-east justification.  Note that the justification
does not do anything special with labels of XmLabel widgets, or text in
XmText widgets: it simply sets the positioning of the entire child
widget within the cell of the
.I XmpTable.
The layout options consist of a series of adjacent case sensitive
letters, each of which sets a layout option:
.RS
.RS
.IP \fBl\fP
left justify child in table cell.
.IP \fBr\fP
right justify child in table cell.
.IP \fBt\fP
top  justify child in table cell.
.IP \fBb\fP
bottom justify child in table cell.
.IP \fBw\fP
do not stretch width of column in which child is
positioned during resizing.  Column width will remain wide enough to
contain the widest child in the column.
.IP \fBh\fP
do not stretch height of row in which child is positioned
during resizing.  Row height will remain high enough to contain the
tallest child in the row.
.IP \fBW\fP
do not stretch width of child during resizing.  The width
of the column may grow (unless constrained by \fBw\fP), and the child
will be justified according to its layout options.
.IP \fBH\fP
do not stretch height of child during resizing.  The height
of the row  may grow (unless constrained by \fBh\fP), and the child
will be justified according to its layout options.
.RE
.RE
.IP "\fBXtNshrinkSimple\fP"
Specifies if simple widgets (widgets which have NULL
\fBquery_geometry\fP methods) should be forced smaller when the table
widget is made smaller.  Such simple widgets will be forced to their
original preferred sizes, but not smaller.  Widgets suffering from this
malady in the \fBMotif\fP widget set include \fBXmArrowButton\fP,
\fBXmArrowButtonGadget\fP, \fBXmDrawnButton\fP, \fBXmScale\fP,
\fBXmScrollBar\fP, \fBXmSeparator\fP.  By default, this is \fBTrue\fP.
Older versions of XmpTable did not provide this feature, and so setting
this resource \fBFalse\fP will give the old behavior, which the author
found obnoxious.
.IP "\fBXtNforceShrink\fP"
Specifies if widgets should be made smaller than their "preferred" sizes.
The XmpTable widget tries to respect the preferred geometries of its children.
This virtually always works when the table is initially created, but after
widgets are managed, many
widgets simply respond with their current sizes: this means when the Table is
made larger, some children will claim they do not want to be made smaller.
The difficulty arises because the vocabulary of the query geometry prototcol
is somewhat limited.  Widgets which are locked using options including any of
"whWH" will continue to be excluded from stretching, but others will be
stretched and then can be shrunk back to their initial preferred sizes from
the time they were last managed.  When the table is shrunk further, all
children are shrunk an equal number of pixels until they are of size 1 
(the smallest legal size of a Widget).
By default, this resource is \fBTrue\fP.
Older versions of XmpTable did not provide this feature, and so setting
this resource \fBFalse\fP will give the old behavior, which the author
found obnoxious.
.IP "\fBXtNcolumnSpacing\fP"
Specifies the number of pixels between columns.
.IP "\fBXtNrowSpacing\fP"
Specifies the number of pixels between rows.
.sp 1
.SS "Inherited Resources"
.I XmpTable
inherits behavior and resources from the following
superclasses.  For a complete description of each resource, refer to the
man page for that superclass.
.nf

XmBulletinBoard Resource Set
Name                Class              Type           Default      Access

XmNallowOverlap     XmCAllowOverlap    Boolean        True         CSG
XmNautoUnmanage     XmCAutoUnmanage    Boolean        True         CG
XmNbuttonFontList   XmCButtonFontList  XmFontList     dynamic      CSG
XmNcancelButton     XmCWidget          Window         NULL         SG
XmNdefaultButton    XmCWidget          Window         NULL         SG
XmNdefaultPosition  XmCDefaultPosition Boolean        True         CSG
XmNdialogStyle      XmCDialogStyle     unsigned char  dynamic      CSG
XmNdialogTitle      XmCDialogTitle     XmString       NULL         CSG
XmNfocusCallback    XmCCallback        XtCallbackList NULL         C
XmNlabelFontList    XmCLabelFontList   XmFontList     dynamic      CSG
XmNmapCallback      XmCCallback        XtCallbackList NULL         C
XmNmarginHeight     XmCMarginHeight    Dimension      10           CSG
XmNmarginWidth      XmCMarginWidth     Dimension      10           CSG
XmNnoResize         XmCNoResize        Boolean        False        CSG
XmNresizePolicy     XmCResizePolicy    unsigned char  XmRESIZE_ANY CSG
XmNshadowType       XmCShadowType      unsigned char  XmSHADOW_OUT CSG
XmNtextFontList     XmCTextFontList    XmFontList     dynamic      CSG
XmNtextTranslations XmCTranslations    XtTranslations NULL         C
XmNunmapCallback    XmCCallback        XtCallbackList NULL         C
.fi
.nf

XmManager Resource Set
Name                  Class                 Type              Default Access

XmNbottomShadowColor  XmCBottomShadowColor  Pixel             dynamic CSG
XmNbottomShadowPixmap XmCBottomShadowPixmap Pixmap XmUNSPECIFIED_PIXMAP CSG
XmNforeground         XmCForeground         Pixel             dynamic CSG
XmNhelpCallback       XmCCallback           XtCallbackList    NULL    C
XmNhighlightColor     XmCHighlightColor     Pixel             dynamic CSG
XmNhighlightPixmap    XmCHighlightPixmap    Pixmap            dynamic CSG
XmNnavigationType     XmCNavigationType     XmNavigationType XmTAB_GROUP CSG
XmNshadowThickness    XmCShadowThickness    Dimension         dynamic CSG
XmNstringDirection    XmCStringDirection    XmStringDirection dynamic CG
XmNtopShadowColor     XmCBackgroundTopShadowColor Pixel       dynamic CSG
XmNtopShadowPixmap    XmCTopShadowPixmap    Pixmap            dynamic CSG
XmNtraversalOn        XmCTraversalOn        Boolean           True    CSG
XmNuserData           XmCUserData           Pointer           NULL    CSG
.fi
.nf

Composite Resource Set
Name              Class              Type        Default Access

XmNchildren       XmCReadOnly        WidgetList  NULL    G
XmNinsertPosition XmCInsertPosition  (*)()       NULL    CSG
XmNnumChildren    XmCReadOnly        Cardinal    0       G
.fi
.nf

Core Resource Set
Name                 Class                Type           Default Access

XmNaccelerators      XmCAccelerators      XtAccelerators NULL    CSG
XmNancestorSensitive XmCSensitive         Boolean        dynamic G
XmNbackground        XmCBackground        Pixel          dynamic CSG
XmNbackgroundPixmap  XmCPixmap            Pixmap  XmUNSPECIFIED_PIXMAP CSG
XmNborderColor       XmCBorderColor       Pixel   XtDefaultForeground  CSG
XmNborderPixmap      XmCPixmap            Pixmap  XmUNSPECIFIED_PIXMAP CSG
XmNborderWidth       XmCBorderWidth       Dimension      0       CSG
XmNcolormap          XmCColormap          Colormap       dynamic CG
XmNdepth             XmCDepth             int            dynamic CG
XmNdestroyCallback   XmCCallback          XtCallbackList NULL    C
XmNheight            XmCHeight            Dimension      dynamic CSG
XmNmappedWhenManaged XmCMappedWhenManaged Boolean        True    CSG
XmNscreen            XmCScreen            Screen*        dynamic CG
XmNsensitive         XmCSensitive         Boolean        True    CSG
XmNtranslations      XmCTranslations      XtTranslations NULL    CSG
XmNwidth             XmCWidth             Dimension      dynamic CSG
XmNx                 XmCPosition          Position       0       CSG
XmNy                 XmCPosition          Position       0       CSG
.fi
.SH SUPPORT PROCEDURES
.LP
.I XmpTable
provides the following procedures and functions which can be used
to create and manipulate 
.I XmpTables
and the children of
.I XmpTables:
.nf
.ft B

XmpTableLoc XmpTableLocParse( char* layout );
void XmpTableLocFree( XmpTableLoc toFree );
XmpTableOpts XmpTableOptsParse( char* options );
void XmpTableChildPosition( Widget child, int col, int row );
void XmpTableChildResize( Widget child, int col_span, int row_span );
void XmpTableChildOptions( Widget child, XmpTableOpts opts );
void XmpTableChildConfig( Widget child,
                          int col, int row, int col_span, int row_span,
                          XmpTableOpts opts );
Widget XmpCreateTable( Widget, char*, ArgList, Cardinal );
Widget XmpCreateTableDialog( Widget, char*, ArgList, Cardinal );
Widget XmpCreateTableTransient( Widget, char*, ArgList, Cardinal );
.ft R
.fi
.LP
Each of these routines can also be invoked from resource files, as the
.B Xmp
library procedure
.B XmpRegisterMotif()
registers the names of each of these procedures as both actions and
callbacks with the
.B Wcl
string-to-callback converter and with the \fBXt Translation Manager\fP.
These routines are discussed in more detail below.
.IP "XmpTableLoc XmpTableLocParse( char* layout );"
This function takes a string which specifies a layout resource for and
.I XmpTable
widget and returns an
.B XmpTableLoc,
a pointer to an opaque type, which can then passed to
.B XtCreateWidget(),
any of the
.B XmpCreateTable
constructors, or to
.B XtSetValues().  The
.I XmpTable
copies the storage, and so the
.B XmpTableLoc
storage must be released by the client when no longer needed (often
immediately after use) by passing the
.B XmpTableLoc
to
.B XmpTableLocFree().
.IP "void XmpTableLocFree( XmpTableLoc toFree );"
This procedure releases the storage pointed to by the 
.B XmpTableLoc
opaque pointer.
.IP "XmpTableOpts XmpTableOptsParse( char* options );"
This function parses the options specifier string into an
.B XmpTableOpts
which can then be passed to .B XtCreateWidget(),
any of the
.B XmpCreateTable
constructors, or to
.B XtSetValues().
.B XmpTableOpts
is typedef'd to a standard machine data type (currently an int),
and so does not need to be free'd.
.IP "void XmpTableChildPosition( Widget child, int col, int row );"
This procedure allows a child of an
.I XmpTable
widget to be moved to a different cell.  If the child spans multiple
columns and/or rows, the column and row indicates the upper left corner
of the child widget.  The defaultLayout resource of the
.I XmpTable
is actually changed by this procedure, so the new location of the child
will be remembered even if the child is unmanaged and re-managed.  The
layout of the
.I XmpTable
is recomputed, which means all issues involved in the positioning and
sizes of all children of the
.I XmpTable
are also re-analyzed.  For example, if the child widget has the option
\fBW\fP specified, then the column to which the child widget is moved will
then be prevented from becoming wider, and the column from which the
child widget came may be enabled to be made wider.
.IP "void XmpTableChildResize( Widget, int col_span, int row_span );"
This procedure allows a child of an
.I XmpTable
widget to be resized so the child spans a different number of columns
or rows.  Again, the layout of the
.I XmpTable
is recomputed, which means all issues involved in the positioning and
sizes of all children of the
.I XmpTable
are re-analyzed.  For example, if the child widget has the option
\fBW\fP specified, then all of the columns which the child widget spans
will be prevented from becoming wider.
.IP "void XmpTableChildOptions( Widget child, XmpTableOpts opts );"
This procedure allows a child of an
.I XmpTable
widget to have its layout options changed.  Again, the layout of the
.I XmpTable
is recomputed, which means all issues involved in the positioning and
sizes of all children of the
.I XmpTable
are re-analyzed.  For example, if the child widget has the option
\fBW\fP specified, then all of the columns which the child widget spans
will be prevented from becoming wider.
.LP
.nf
void XmpTableChildConfig( Widget child,
                          int col, int row,
                          int col_span, int row_span,
                          XmpTableOpts opts );
.fi
.IP
This procedure allows a child of an
.I XmpTable
widget to have all of its layout specifications changed at once.
.IP "Widget XmpCreateTable( Widget, char*, ArgList, Cardinal );"
This function creates a new
.I XmpTable
widget.  The \fIWidget\fP argument specifies the parent widget ID, the
\fIchar*\fP argument specifies the name of the created widget, the
\fIArgList\fP argument specifies the argument list, and the
\fICardinal\fP argument specifies the number of attribute/value pairs
in the argument list.
.IP "Widget XmpCreateTableDialog(Widget,char*,ArgList,Cardinal);"
This function creates a new
.I XmpTable
widget as a child of a new
.I XmDialogShell.
The name of the new
.I XmDialogShell
has the same name as the new
.I XmpTable
but with the characters "_popup" concatenated to the end.  The
\fIWidget\fP argument specifies the parent widget ID, the \fIchar*\fP
argument specifies the name of the created \fIXmpTable\fP widget, the
\fIArgList\fP argument specifies the argument list, and the
\fICardinal\fP argument specifies the number of attribute/value pairs
in the argument list.
.IP "Widget XmpCreateTableTransient(Widget,char*,ArgList,Cardinal);"
This is almost identical to \fIXmpCreateTableDialog()\fP except the
shell widget is an \fIXtTransientShell\fP, with the \fIXtNtransientFor\fP
resource set if it is available (after R4) and the related bug
is fixed (still broken in early releases of R5).
.SH TRANSLATIONS
.LP
.I XmpTable
inherits translations from
.B XmBulletinBoard.
.SH ACTIONS AND CALLBACKS
.LP
The Xmp library provides the following callbacks and actions
for manipulating children of
XmpTable widgets:
.LP
.nf
.ft B
XmpTableChildConfig( widget col row [h_span [v_span [opts]]] )
XmpTableChildPosition( widget col row )
XmpTableChildResize( widget h_span v_span )
XmpTableChildOptions( widget options )
.ft R
.fi
.LP
Each callback procedure can also be named in resource files as
the name of the procedure followed by CB: i.e, XmpTableChildConfig()
can also be invoked as a callback by giving the name XmpTableChildConfigCB()
for a callback resource value.  Also, each action procedure can also
be named by appending ACT to the procedure name.  Normally, I just use the
procedure name, so it is less trouble to change behavior from callbacks
to actions triggered by translations or accelerators, and vice versa.
The CB and ACT endings are maintained for backward compatibility, and
because some people like to be more explicit.  It is all a matter of taste.
.LP
Arguments to the procedures are provided as strings, the characters
between the parenthesis following the procedure name.  If no parenthesis
follow the procedure name, then a NULL string is passed to the procedure.
Some procedures require arguments, some provide reasonable defaults when
no arguments are given.  For example:
.RS
.LP
.nf
*foo.activateCallback:       XmpTableChildPosition( this 2 4 )
.fi
.RE
.LP
Each
.I XmpTable
callback and action procedure is discussed in detail below.
.IP "XmpTableChildConfig( w col row [h_span [v_span [opts]]] )"
This allows a child of an XmpTable to be moved to a new row or
column, to be given a different horizontal or vertical span, and
to change the justification and re-size options of the child.
.IP "XmpTableChildPosition( w col row )"
This allows a child of an XmpTable to be moved to a new row or 
column.
.IP "XmpTableChildResize( w h_span v_span )"
This allows a child of an XmpTable to be given a different horizontal
or vertical span.
.IP "XmpTableChildOptions( w options )"
This allows a child of an XmpTable to be given new
justification and re-size options.
.SH "SEE ALSO"
Xmp (3), Mri (1), Wcl (3), X (1), Core (3X), Composite (3X), 
Constraint (3X), XmBulletinBoard (3X).
.SH BUGS
.LP
The geometry management of XmScrolledWindow is still broken in Motif
1.1, and so a hack has been made to XmpTable to work around the
XmScrolledWindow bug.  This hack is controlled by a Boolean resource
named XtNbrokenXmScrolledWindow, with class XtCBrokenXmScrolledWindow.
By default, this resource is True.  You should only set the resource False
if you have a fixed version of XmScrolledWindow.
.LP
The bug in XmScrolledWindow is rarely noticable, but when it is, it is
obnoxious.  The manifestation is multiple redundant resizes of
XmScrolledWindows inside XmpTables.
.SH AUTHORS
David E. Smyth (David.Smyth@sniap.mchp.sni.de) at Siemens Nixdorf
Informationssysteme AG, Munich Germany.  The original Table widget
on which the external interface and many concepts of the
.I XmpTable
were derived was written by David Harrison in 1989 while he was
at the University of California, Berkeley.
