/* 
       hint.c - HINT shared library for BitchX (by panasync)
       
       	Written by |MaRe| 
       	
*/
#define HINT_VERSION "0.01"

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "irc.h"
#include "struct.h"
#include "ircaux.h"
#include "status.h"
#include "screen.h"
#include "vars.h"
#include "misc.h"
#include "output.h"
#include "module.h"

#define HINT_LOADED "*** %W<%GHINT shared libarary loaded%W>"
#define getrandom(min, max) ((rand() % (int)(((max)+1) - (min))) + (min))

int max_hints;
char hint_buf[128]; /* max length of one hint */
char hint_file[128];

char *cp(char *fmt) { return (convert_output_format(fmt, NULL, NULL)); }

char *Hint_Version(IrcCommandDll **interp)
{
	return HINT_VERSION;
}

void show_hint(int num)
{
  FILE *fp;
  int i;
  char *converted;

  fp = fopen(hint_file, "r");
  for (i=0;i<=num;i++) fgets(hint_buf, 128, fp);
  hint_buf[strlen(hint_buf)-1]='\0';
  converted = cp(hint_buf);
  put_it("%s", converted);
    
  fclose(fp);
}

void shint _((IrcCommandDll *interp, char *command, char *args, char *subargs))
{
  int number;
  if (max_hints <= 0)
  {
    put_it("%s", cp("*** %W<%Ghint%W>%n No hints avaible."));
    return;
  }
  
  number = atoi(args);
  
  if (word_count(args)==0) number=-1;  /* hehe, this is malicious..:=) */
  if (number >= 0 && number <= max_hints) 
    show_hint(number); else
    {
      put_it("%s Specify number from 0-%d", cp("*** %W<%Ghint%W>%n"), max_hints);
      return;
    }
}

void hint _((IrcCommandDll *interp, char *command, char *args, char *subargs))
{
  int hint_no;
  
  if (max_hints <= 0)
  {
    put_it("%s", cp("*** %W<%Ghint%W>%n No hints avaible."));
    return;
  }
  
  hint_no = getrandom(0, max_hints);
  show_hint(hint_no);
}

void rehint _((IrcCommandDll *interp, char *command, char *args, char *subargs))
{
  FILE *fp;
  char *home = getenv("HOME");
  char file[128];
 
  sprintf(hint_file, "%s/.BitchX/BitchX.hints", home);
  max_hints=0;
  fp = fopen(hint_file, "r");
  if (fp!=NULL)
  {
    while (fgets(hint_buf, 128, fp)!=NULL) max_hints++;
    fclose(fp);
    put_it("%s (using %d hints)", cp("*** %W<%Ghint%W> Reloaded%n"), max_hints);
    max_hints--;
  } else
    put_it("%s (%s)", cp("*** %W<%Ghint%W>%n: Hint file not found"), hint_file);
    
}

void hhelp _((IrcCommandDll *interp, char *command, char *args, char *subargs))
{
  put_it("%s", cp("*** %W<%Ghint%W> %GHINT%n (version %W0.1b%n by %Y|MaRe|%n) %GHELP%n"));
  if (word_count(args)==0)
  {
    put_it("%s", cp("*** %W<%Ghint%W>%n Commands avaible:"));
    put_it("%s", cp("*** %W<%Ghint%W>%n  HINT    SHINT"));
    put_it("%s", cp("*** %W<%Ghint%W>%n  REHINT  HELP"));
    put_it("%s", cp("*** %W<%Ghint%W>%n More help with %W/HHELP %Y<command>%n"));
  } else
  {
    if (!strcmp(upper(args), "HINT"))
    {
     put_it("%s", cp("*** %W<%Ghint%W>%n Usage: %W/HINT%n"));
     put_it("%s", cp("*** %W<%Ghint%W>%n %YHINT%n: this will print you randomly")); 
     put_it("%s", cp("*** %W<%Ghint%W>%n %YHINT%n: chosen hint from the hint database."));      
    }
    
    if (!strcmp(upper(args), "SHINT"))
    {
     put_it("%s", cp("*** %W<%Ghint%W>%n Usage: %W/SHINT%n %Y<number>%n"));
     put_it("%s", cp("*** %W<%Ghint%W>%n %YSHINT%n: this will print the Xth")); 
     put_it("%s", cp("*** %W<%Ghint%W>%n %YSHINT%n: hint from the hint database."));      
    }
    
    if (!strcmp(upper(args), "REHINT"))
    {
     put_it("%s", cp("*** %W<%Ghint%W>%n Usage: %W/REHINT%n"));
     put_it("%s", cp("*** %W<%Ghint%W>%n %YREHINT%n: this will reload the")); 
     put_it("%s", cp("*** %W<%Ghint%W>%n %YREHINT%n: hint database."));      
    }
  }
}

int Hint_Init(IrcCommandDll **interp)
{
  IrcCommandDll *new;
  FILE *fp;
  char *home = getenv("HOME");
  char file[128];
 
  /* add /HINT */ 
  add_module_proc(COMMAND_PROC, "hint", "hint", NULL, 0, 0, hint, NULL);
  
  /* add /SHINT */
  add_module_proc(COMMAND_PROC, "hint", "shint", NULL, 0, 0, shint, NULL);

  /* add /REHINT */
  add_module_proc(COMMAND_PROC, "hint", "rehint", NULL, 0, 0, rehint, NULL);
  
  /* add /HHELP */
  add_module_proc(COMMAND_PROC, "hint", "hhelp", NULL, 0, 0, hhelp, NULL);
  
  srand(time(NULL));
  put_it("%s", cp(HINT_LOADED));
  
  sprintf(hint_file, "%s/.BitchX/BitchX.hints", home);
  max_hints=0;
  fp = fopen(hint_file, "r");
  if (fp!=NULL)
  {
    while (fgets(hint_buf, 128, fp)!=NULL) max_hints++;
    fclose(fp);
    put_it("%s (using %d hints)", cp("*** %W<%Ghint%W>%n"), max_hints);
    put_it("%s", cp("*** %W<%Ghint%W>%n try %W/HHELP%n."));
    max_hints--;
  } else
    put_it("%s (%s)", cp("*** %W<%Ghint%W>%n Hint file not found"), hint_file);
    
  return 0;
}

