/*
 * IRC - Internet Relay Chat, include/hash.h
 * Copyright (C) 1991 Darren Reed
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef HASH_H
#define HASH_H

/*=============================================================================
 * general defines
 */

#define _HASHSIZE		26669	/* prime number ~ 4/3 x 20,000 */
#define _CHANNELHASHSIZE	16001	/* prime number ~ 4/3 x 12,000 */
#ifndef DEBUGMODE
#define HASHSIZE _HASHSIZE
#define CHANNELHASHSIZE _CHANNELHASHSIZE
#else
extern unsigned int HASHSIZE;
extern unsigned int CHANNELHASHSIZE;
#endif

/*=============================================================================
 * Structures
 */

struct hashentry {
  void *list;
#ifdef DEBUGMODE
  unsigned int hits;
  unsigned int links;
#endif
};

/*=============================================================================
 * Proto types
 */

extern aChannel *hash_find_channel(char *name, aChannel *chptr);
extern int add_to_channel_hash_table(char *name, aChannel *chptr);
extern int del_from_channel_hash_table(char *name, aChannel *chptr);
extern unsigned int hash_nick_name(char *nname);
extern void clear_client_hash_table(void);
extern void clear_channel_hash_table(void);
extern int add_to_client_hash_table(char *name, aClient *cptr);
extern int del_from_client_hash_table(char *name, aClient *cptr);
extern aClient *hash_find_client(char *name, aClient *cptr);
extern aClient *hash_find_nickserver(char *name, aClient *cptr);
extern aClient *hash_find_server(char *server, aClient *cptr);
extern int m_hash(aClient *cptr, aClient *sptr, int parc, char *parv[]);

#endif /* HASH_H */
