/***

ifaces.c - routine that determines whether a given interface is supported
		by IPTraf
		
Copyright (c) Gerard Paul Java 1998

This software is open source; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License in the included COPYING file for
details.

***/

#include <string.h>
#include "error.h"

#define NUM_SUPPORTED_IFACES 6

char ifaces[NUM_SUPPORTED_IFACES][6] =
{ "lo", "eth", "sl", "ppp", "ippp", "fddi" };

/*
 * Determine if supplied interface is supported.
 */

int iface_supported(char *iface)
{
    int i;

    for (i = 0; i <= NUM_SUPPORTED_IFACES - 1; i++) {
	if (strncmp(ifaces[i], iface, strlen(ifaces[i])) == 0)
	    return 1;
    }

    return 0;
}

void err_iface_unsupported(void)
{
    int resp;
    
    errbox("Specified interface not supported",
           "Press a key to abort", &resp);
}
