
/*
 * CFINGERD
 * RFC1413 implementation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
#include "tcplog.h"
extern char *hostlookup(__u32);

void    rfc1413_alarm(int signal)
{
	if (signal == SIGALRM)
		ident_user = "unknown@alarm.signal";
}

/* Self contained RFC1413 implementation.  Thanks to Joel Katz for parts of
 * the implementation.  Completely rewritten by yours truly to be self-
 * contained in a single program.  Simple, easy to use.
 */
char   *get_rfc1413_data(int remote_port, int local_port, __u32 remote_addr, char *local_addr)
{
	int     i, j;
	struct sockaddr_in sin;
	char    buffer[1024], buf[256], uname[64], *bleah;

	bleah = (char *) malloc(256);
	bzero(bleah, 256);
#ifdef DEBUG
	fprintf(stderr, "Made it to get_rfc1413_data()\n");
	fprintf(stderr, "Remote host is: %s\n", hostlookup(remote_addr));
#endif

	j = socket(AF_INET, SOCK_STREAM, 0);
	if (j < 0) {
		sprintf(bleah, "unknown@%s", hostlookup(remote_addr));
		/* syslog(LOG_ERR, "rfc1413-socket: %s", strerror(errno)); */
		return (bleah);
	}
	sin.sin_family = AF_INET;
	sin.sin_port = getservbyname("auth", "tcp")->s_port;
#ifdef DEBUG
	fprintf(stderr, "Made it to assignment of s_addr\n");
#endif
	sin.sin_addr.s_addr = remote_addr;
#ifdef DEBUG
	fprintf(stderr, "Made past assignment of s_addr\n");
#endif

	signal(SIGALRM, rfc1413_alarm);
	alarm(5);

	i = connect(j, (struct sockaddr *) &sin, sizeof(sin));
	if (i < 0) {
		/* syslog(LOG_ERR, "rfc1413-connect: %s @%s", strerror(errno), hostlookup(remote_addr)); */
		close(j);
		sprintf(bleah, "unknown@%s", hostlookup(remote_addr));
		alarm(0);
		return (bleah);
	}
	sprintf(buffer, "%d,%d\n", remote_port, local_port);
	write(j, buffer, strlen(buffer));

	if (read(j, buf, 256) <= 0) {
		sprintf(bleah, "unknown@%s", hostlookup(remote_addr));
	} else {
		sscanf(buf, "%*d , %*d : %*[^ \t\n\r:] : %*[^\t\n\r:] : %[^\n\r]", uname);

		sprintf(bleah, "%s@%s", uname, hostlookup(remote_addr));
	}

	alarm(0);
	close(j);
	return (bleah);
}
