/**************************************************************************
 * LPRng IFHP Filter
 * Copyright 1994-1997 Patrick Powell, San Diego, CA <papowell@astart.com>
 *
 * Based on the CTI printer filters.
 *  See COPYRIGHT for details.
 *
 * cleanup.c,v 3.2 1998/03/19 14:21:33 papowell Exp
 */

#include "portable.h"
#include "common.h"
#include "hp4.h"

static int exitval;

void cleanup(sig)
int sig;
{
	log(4,"Signal %s received-entering cleanup", Sigstr(sig) );

	if( monitpid > 0 ) {
        log(3,"Father murders %d", monitpid);
        kill(monitpid,SIGTERM);
        kill(monitpid,SIGCONT);
	}
	if( accntpid > 0 ) {
        log(3,"Father murders %d", accntpid);
        kill(accntpid,SIGTERM);
        kill(accntpid,SIGCONT);
	}
	if( exitval ){
		fexit(exitval);
	} else if( getpid() != filterpid ){
		/* we are the child */
		exit(0);
    }
	exitval = FILTRETRY;
	log(3,"Job Interrupted");
	exit(exitval);
}
