/* Bezerk
 * Copyright (C) 1998 Tony Gale.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */
 
#include <gtk/gtk.h>
#include <strings.h>
#include <glib.h>

#include "callback.h"
#include "menu.h"

/* this is the GtkMenuEntry structure used to create new menus.  The
 * first member is the menu definition string.  The second, the
 * default accelerator key used to access this menu function with
 * the keyboard.  The third is the callback function to call when
 * this menu item is selected (by the accelerator key, or with the
 * mouse.) The last member is the data to pass to your callback function.
 */

static GtkMenuEntry menu_items[] =
{
/*   {"<Main>/File/Connect", "NULL", file_connect_callback, NULL}, */
/*   {"<Main>/File/Disconnect", "NULL", file_disconnect_callback, NULL}, */
  {"<Main>/File/Save log", NULL, NULL, NULL},
  {"<Main>/File/<separator>", NULL, NULL, NULL},
  {"<Main>/File/Quit", NULL, file_quit_callback, "OK, I'll quit"},
  {"<Main>/Settings/User...", NULL, settings_user_callback, NULL},
  {"<Main>/Settings/Fonts...", NULL, settings_fonts_callback, NULL},
  {"<Main>/Settings/Toolbar/Text", NULL, NULL, NULL},
  {"<Main>/Settings/Toolbar/Icons", NULL, NULL, NULL},
  {"<Main>/Settings/Toolbar/Both", NULL, NULL, NULL},
  {"<Main>/Settings/<separator>", NULL, NULL, NULL},
  {"<Main>/Settings/Options...", NULL, settings_options_callback, NULL},
  {"<Main>/Settings/<separator>", NULL, NULL, NULL},
  {"<Main>/Settings/Aliases...", NULL, settings_aliases_callback, NULL},
  {"<Main>/Help/About...", NULL, help_about_callback, NULL}
};

/* calculate the number of menu_item's */
static int nmenu_items = sizeof(menu_items) / sizeof(menu_items[0]);

MenuBar *menubar_create()
{  
  return( menus_create(menu_items, nmenu_items) );
}

void menus_init(MenuBar *menu_bar)
{
  menu_bar->factory = gtk_menu_factory_new(GTK_MENU_FACTORY_MENU_BAR);
  menu_bar->subfactory[0] = gtk_menu_factory_new(GTK_MENU_FACTORY_MENU_BAR);
  
  gtk_menu_factory_add_subfactory(menu_bar->factory, menu_bar->subfactory[0], "<Main>");
}

MenuBar *menus_create(GtkMenuEntry *entries, int nmenu_entries)
{
  MenuBar *menu_bar;
/*   char *accelerator; */
/*   int i; */
  
  menu_bar = g_malloc(sizeof(MenuBar));
  menus_init(menu_bar);

/*   if (menu_bar->entry_ht) */
/*     for (i = 0; i < nmenu_entries; i++) { */
/*       accelerator = g_hash_table_lookup(menu_bar->entry_ht, entries[i].path); */
/*       if (accelerator) { */
/* 	if (accelerator[0] == '\0') */
/* 	  entries[i].accelerator = NULL; */
/* 	else */
/* 	  entries[i].accelerator = accelerator; */
/*       } */
/*     } */
  gtk_menu_factory_add_entries(menu_bar->factory, entries, nmenu_entries);
  
/*   for (i = 0; i < nmenu_entries; i++) */
/*     if (entries[i].widget) { */
/*       gtk_signal_connect(GTK_OBJECT(entries[i].widget), "install_accelerator", */
/* 			 (GtkSignalFunc) menus_install_accel, */
/* 			 entries[i].path); */
/*       gtk_signal_connect(GTK_OBJECT(entries[i].widget), "remove_accelerator", */
/* 			 (GtkSignalFunc) menus_remove_accel, */
/* 			 entries[i].path); */
/*     } */

  return(menu_bar);
}

/* static gint menus_install_accel(GtkWidget * widget, gchar * signal_name, gchar key, gchar modifiers, gchar * path) */
/* { */
/*   char accel[64]; */
/*   char *t1, t2[2]; */
  
/*   accel[0] = '\0'; */
/*   if (modifiers & GDK_CONTROL_MASK) */
/*     strcat(accel, "<control>"); */
/*   if (modifiers & GDK_SHIFT_MASK) */
/*     strcat(accel, "<shift>"); */
/*   if (modifiers & GDK_MOD1_MASK) */
/*     strcat(accel, "<alt>"); */
  
/*   t2[0] = key; */
/*   t2[1] = '\0'; */
/*   strcat(accel, t2); */
  
/*   if (entry_ht) { */
/*     t1 = g_hash_table_lookup(entry_ht, path); */
/*     g_free(t1); */
/*   } else */
/*     entry_ht = g_hash_table_new(g_str_hash, g_str_equal); */
  
/*   g_hash_table_insert(entry_ht, path, g_strdup(accel)); */
  
/*   return TRUE; */
/* } */

/* static void menus_remove_accel(GtkWidget * widget, gchar * signal_name, gchar * path) */
/* { */
/*   char *t; */
  
/*   if (entry_ht) { */
/*     t = g_hash_table_lookup(entry_ht, path); */
/*     g_free(t); */
    
/*     g_hash_table_insert(entry_ht, path, g_strdup("")); */
/*   } */
/* } */

void menus_set_sensitive(MenuBar *menu_bar, char *path, int sensitive)
{
  GtkMenuPath *menu_path;
  
  menu_path = gtk_menu_factory_find(menu_bar->factory, path);
  if (menu_path)
    gtk_widget_set_sensitive(menu_path->widget, sensitive);
  else
    g_warning("Unable to set sensitivity for menu which doesn't exist: %s", path);
}

void menu_set_right_justify(MenuBar *menu_bar, char *path)
{
  GtkMenuPath *menu_path;
           
  menu_path = gtk_menu_factory_find(menu_bar->factory, path);

  if (menu_path)
    gtk_menu_item_right_justify(GTK_MENU_ITEM(menu_path->widget));

  return;
}
