/*
 * Header file for TimeTracker 
 */
/*
 * Declares the variables/routines that are shared between the project list
 * editor and the main program 
 */
/*
 * Commonly used include files 
 */
/*
 * OS definitions - ought to be avoidable by dilligent use of X,
 * but don't see how 
 */
#include <stdio.h>
#include <errno.h>
/*
 * needed on Ultrix v 4.0, must be before sys/stat.h - David Raz 
 */
#include <sys/types.h>
/*
 * Some systems (HP-UX and Ultrix 4.0) have fopen constants in this file 
 */
#include <sys/stat.h>
/*
 * Some systems (eg, NeXT) don't define some Posix constants/macros 
 */
#ifndef S_IRUSR
#define S_IRUSR S_IREAD
#define S_IWUSR S_IWRITE
#define S_IXUSR S_IEXEC
#endif
#ifndef S_ISDIR
#define S_ISDIR(m)      (((m)&S_IFMT) == S_IFDIR)
#endif
/*
 * Needed for catching die signals 
 */
#include <signal.h>
/*
 * If we want getenv prototyped, we want this 
 */
#include <stdlib.h>
/*
 * Needed for MAXPATHLEN 
 */
#include <sys/param.h>
/*
 * Some systems (ie Dolphin 88K) do not define MAXPATHLEN even here 
 */
#ifndef MAXPATHLEN
#define MAXPATHLEN 1024
#endif
/*
 * X11 definitions 
 */
#include <X11/Xos.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
/*
 * Athena Widgets definitions 
 */
#include <X11/Xaw/List.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/Dialog.h>

/*
 * ------------ LOCAL DEFINITIONS ---------------- 
 */
#define LISTSIZE 30
#define TICKSPERSECOND 1000
#define SECONDSPERMINUTE 60
#define SAVEINTERVALMINUTES 10
#define TIMESTRINGLEN 5		/*
				 * * * * * * maxlen of hh:mm formatted times 
				 */
#define TICKPERIOD TICKSPERSECOND * SECONDSPERMINUTE
#define SAVEPERIOD TICKSPERSECOND * SECONDSPERMINUTE * SAVEINTERVALMINUTES
#define MINSPERDAY 60*24
/*
 * Filenames should be legal, and all legal ones should be allowed 
 */
#define PREFIXLEN (MAXPATHLEN-20)


/*
 * All variables are in the main program 
 */
extern String  *nameList;
extern String  *timeList;
extern int     *timeUsed;
extern Widget   toplevel;
extern Widget   list_widget;
extern Widget   timelist_widget;
extern Widget   commandBox;
extern char     TimeTrackerdirectory[MAXPATHLEN];

extern int      incPlus;
extern int      incMinus;

extern XtAppContext appContext;

/*
 * Cross-referred routines 
 */
/*
 * from TimeTracker.c 
 */
extern char    *filenameprefix();
extern void     save();
extern int      currentProject();

/*
 * from projectlist.c 
 */
extern Widget   addButton();
extern int      makethelist();
extern void     initprojectlisteditor();
extern void     addDeadProject();
extern void     MessageBox();
extern void     initMessageBox();
extern Widget   messageOkButton;
