/* GtkSQL -- an interactive graphical query tool for PostgreSQL
 * Copyright (C) 1998  Lionel ULMER
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __DB_CONN_H__
#define __DB_CONN_H__

#include <gtk/gtk.h>

typedef struct db_conn DBConnection;

#include "queries.h"

#define DB_QUERY_ERROR      0
#define DB_QUERY_EMPTY      1
#define DB_QUERY_COMMAND_OK 2
#define DB_QUERY_RECORDS_OK 3
#define DB_QUERY_OTHER      4

/* Field Definition */

typedef struct {
  char *name;
  char *type;
  char *length;
} DBFieldDef ;

/* Table Definition */

typedef struct {
  char *name;

  int field_num;
  DBFieldDef *field_def;
} DBTableDef;

/* Connection structure */

struct db_conn {
  /****
    Low-level SQL functions
   ****/
  
  /* Connection and status functions */
  int (*DBdisconnect)(struct db_conn *) ;

  /* Information functions */
  char *(*DBget_error_message)(struct db_conn *) ;
  char *(*DBget_db_name)(struct db_conn *) ;

  /* Queries functions */
  void *(*DBexecute_query)(struct db_conn *, char *) ;
  int (*DBget_query_status)(struct db_conn *, void *) ;
  int (*DBget_record_number)(struct db_conn *, void *) ;
  int (*DBget_field_number)(struct db_conn *, void *) ;
  char *(*DBget_field_name)(struct db_conn *, void *, int field) ;
  char *(*DBget_field_value)(struct db_conn *, void *, int record, int field) ;
  void (*DBclear_query)(struct db_conn *, void *) ;

  /****
    Keywords for autocompletion
   ****/
  Keyword *keylist;
  
  /****
    Tables functions (definitions, ...)
   ****/
  int (*DBget_table_def)(struct db_conn *) ;
  void (*DBfree_table_def)(struct db_conn *) ;
  int (*DBget_table_num)(struct db_conn *) ;
  DBTableDef *(*DBget_table)(struct db_conn *, int) ;
};

/* How to connect */

typedef struct {
  /* Memory location where the connection function stores the widgets it
     will have to "parse" when the user clicks on OK */
  void *data;
  /* Callback function that parses the dialog and opens the connection */
  DBConnection *(*connect_callback)(void *) ;
} DBConnector;

typedef DBConnector *(*register_func)(GtkWidget **notebook_pane,
				      GtkWidget **notebook_label,
				      void (*error_dialog)(char *, char *)) ;

#endif  __DB_CONN_H__


