#!/usr/local/bin/perl
#  fetch-latest.pl - Fetch and (possibly) install the latest version of CBB
#                    Requires use of the "ftp" command
#
#  Written by Curtis Olson.  Started October 4, 1996.
#
#  Copyright (C) 1996 - 1999  Curtis L. Olson  - curt@me.umn.edu
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# $Id: fetch-latest.pl,v 1.2 2000/01/05 13:01:17 curt Exp $
# (Log is kept at end of this file)


#----------------------------------------------------------------------------
# Global variables
#----------------------------------------------------------------------------

$file = "cbb-latest.tar.gz";
$cbbhost = "ftp.me.umn.edu";
$account = "anonymous";

# get user name                                                        
$user = (getpwuid($<))[0] || $ENV{LOGNAME} || "Luser";
$host = `hostname`; chop($host);

$passwd = "$user\@";
$dir = "/pub/finance";

$temp = "/var/tmp";
$dest = "$temp/$file";


#----------------------------------------------------------------------------
# Fetch the latest version
#----------------------------------------------------------------------------

print "Fetching CBB from ftp://$cbbhost$dir\n\n";

chdir($temp);
$command = 
    "echo \"open $cbbhost\n" .
    "user $account $passwd\n" .
    "bin\n".
    "hash\n".
    "cd $dir\n" .
    "get $file\n" .
    "quit\n\"";

# print "$command\n";

#open(FTP, "|ftp -n -i -v -d");
open(FTP, "|ftp -n -i -d");
print FTP "open $cbbhost\n";
print FTP "user $account $passwd\n";
print FTP "bin\n";
print FTP "hash\n";
print FTP "cd $dir\n";
print FTP "get $file\n";
print FTP "quit\n";
close(FTP);


#----------------------------------------------------------------------------
# Extract ...
#----------------------------------------------------------------------------

print "\nExtracting in $temp\n\n";
open( TAR, "tar xvzf $temp/$file|" );

while ( <TAR> ) {
    # print "    $_";

    @files = split(/\//, $_);
	
    $cbbver = @files[0];
}

close( TAR );

print "CBB version is $cbbver\n";


#----------------------------------------------------------------------------
# Determine current prefix ...
#----------------------------------------------------------------------------

# return the directory of a file name 
sub file_dirname {
    my($file) = @_;
    my($pos);

    $pos = rindex($file, "/");
    if ( $pos >= 0 ) {
        return substr($file, 0, ($pos + 1));
    } else {
        return "./";
    }
}


open(PRE, "which cbb|");
while ( <PRE> ) {
    $prefix = &file_dirname($_);
    chop($prefix);
    print "prefix = $prefix\n";
}


#----------------------------------------------------------------------------
# Install ...
#----------------------------------------------------------------------------

print "\nInstalling ...\n\n";

chdir("$temp/$cbbver");
system("./configure --prefix=$prefix");
system("make install");


#----------------------------------------------------------------------------
# Cleanup
#----------------------------------------------------------------------------

chdir("/");
unlink("$temp/$file");

if ( $cbbver =~ m/^cbb/ ) {
    # if the untar succeeded
    system("rm -rf $temp/$cbbver");
}

print "\nRetreival and Installation finished.\n";
print "If the installation succeeded, you should immediately exit and and rerun CBB.\n";
print "This script is called \"fetch-latest.pl\" and can be run\n";
print "independently.  It is located in the contrib directory.\n\n";
print "Press return to exit:  ";
$junk = <>;


#----------------------------------------------------------------------------
# $Log: fetch-latest.pl,v $
# Revision 1.2  2000/01/05 13:01:17  curt
# Updated to run configure before running make install.
#
# Revision 1.1.1.1  1999/12/18 02:06:02  curt
# Start of 0.8 branch
#
# Revision 1.1  1999/12/17 19:21:02  curt
# Added to repository.
#
# Revision 1.5  1999/11/21 00:48:02  curt
# Tweaks to copyright dates and email address.
#
# Revision 1.4  1998/10/07 20:30:02  curt
# Patches from Philippe Troin <phil@fifi.org>
#
# Revision 1.3  1997/06/13 14:42:58  curt
# Fetch the latest debian package instead if you are running on a debian system.
#
# Revision 1.2  1996/10/04 19:48:28  curt
# Added a script to automatically fetch and install the latest version of CBB.
#
# Revision 1.1  1996/10/04 19:22:09  curt
# Initial revision.
#
