/*  CommandLineSettings  Settings from command line.
    Last modified 1998-05-08

    Copyright (C) 1998  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "common.hh"

CommandLineSettings::CommandLineSettings (int argc, char **argv) {
  {
    for (int i=0; i<argc; i++)
      if (!strcmp (argv[i], "-v")) {
        Dstr line;
        version_string (line);
        cerr << line << endl;
        exit (0);
      }
  }
  {
    int a;
    for (a=0; a<numcolors; a++) {
      Dstr aname ("-");
      aname += colorarg[a];
      colors[a] = findarg (aname.aschar(), argc, argv);
    }
  }

  el = findarg("-el",argc,argv);
  u = findarg("-u",argc,argv);
  z = findarg("-z",argc,argv);
  df = findarg("-df",argc,argv);
  hf = findarg("-hf",argc,argv);
  tf = findarg("-tf",argc,argv);
  tl = findarg("-tl",argc,argv);
  nf = findarg("-nf",argc,argv);

  b = findarg("-b",argc,argv);
  e = findarg("-e",argc,argv);
  f = findarg("-f",argc,argv);
  m = findarg("-m",argc,argv);
  s = findarg("-s",argc,argv);
  o = findarg("-o",argc,argv);

  l_len = 0;
  {
    struct lnode *templ, *last;
    l = last = NULL;
    for (int i=0; i<argc-1; i++) {
      if (!strcmp (argv[i], "-l")) {
        l_len++;
	templ = new lnode;
	templ->name = argv[i+1];
	templ->next = NULL;
        if (last) {
          last->next = templ;
          last = templ;
        } else {
  	  l = last = templ;
        }
      }
    }
  }

  char *t;
  if ((t = findarg ("-ga", argc, argv))) {
    ga_isnull = 0;
    ga = getposdouble (t);
  }
  if ((t = findarg ("-gl", argc, argv))) {
    gl_isnull = 0;
    gl = getgldouble (t);
  }
  if ((t = findarg ("-lw", argc, argv))) {
    lw_isnull = 0;
    lw = getposdouble (t);
  }
  if ((t = findarg ("-gh", argc, argv))) {
    gh_isnull = 0;
    gh = max (mingheight, getposint (t));
  }
  if ((t = findarg ("-gw", argc, argv))) {
    gw_isnull = 0;
    gw = max (mingwidth, getposint (t));
  }
  if ((t = findarg ("-th", argc, argv))) {
    th_isnull = 0;
    th = max (minttyheight, getposint (t));
  }
  if ((t = findarg ("-tw", argc, argv))) {
    tw_isnull = 0;
    tw = max (minttywidth, getposint (t));
  }
  if ((t = findarg ("-cw", argc, argv))) {
    cw_isnull = 0;
    cw = max (mingwidth, getposint (t));
  }

  ml_isnull = 1;
  if ((t = findarg ("-ml", argc, argv))) {
    double v;
    Dstr uts;
    ml_isnull = 0;
    int i;
    for (i=0; i<strlen(t); i++) {
      char c = t[i];
      if (!((c >= '0' && c <= '9') || c == '+' || c == '-' || c == '.'
      || c == 'e' || c == 'E'))
        break;
    }
    uts = t + i;
    if (sscanf (t, "%lf", &v) != 1) {
      Dstr details ("The offending input was '");
      details += t;
      details += "'.";
      barf (NOT_A_NUMBER, details);
    }
    ml = PredictionValue (PredictionValue::Unit (uts), v);
  }
}

CommandLineSettings::~CommandLineSettings () {
  while (l) {
    struct lnode *templ = l;
    l = l->next;
    delete templ;
  }
}

char *
CommandLineSettings::findarg (char *arg, int argc, char **argv) {
  for (int i=0; i<argc-1; i++)
    if (!strcmp (argv[i], arg))
      return argv[i+1];
  return NULL;
}

char
*CommandLineSettings::settingsid() {
  return "command line";
}
