/* $Id: api.h,v 1.71 1997/01/14 23:08:41 johan Exp johan $ */

/* Vis5D version 4.2 */

/*
Vis5D system for visualizing five dimensional gridded data sets
Copyright (C) 1990 - 1996 Bill Hibbard, Brian Paul, Dave Santek,
and Andre Battaiola.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef API_H
#define API_H


#include <X11/Xlib.h>
#ifdef SGI_GL
#  include "gl/glws.h"
#endif
#ifdef OPENGL
#  include "GL/glx.h"
#endif

/*
 * Including v5d.h here may seem like a kludge but the v5d.h file
 * actually defines a programmer's API too.
 */
#include "v5d.h"



/* Max number of simultaneous Vis5D API contexts: */
#define VIS5D_MAX_CONTEXTS 6


/* error codes for "vis5d_..." API functions */
#define VIS5D_BAD_CONTEXT       -1
#define VIS5D_BAD_CONSTANT      -2
#define VIS5D_BAD_MODE          -3
#define VIS5D_BAD_VALUE         -4
#define VIS5D_BAD_VAR_NUMBER    -5
#define VIS5D_BAD_TIME_STEP     -6
#define VIS5D_FAIL              -7
#define VIS5D_OUT_OF_MEMORY     -8


/*** Constants ***/
#define VIS5D_ISOSURF           0
#define VIS5D_HSLICE            1
#define VIS5D_VSLICE            2
#define VIS5D_CHSLICE           3
#define VIS5D_CVSLICE           4
#define VIS5D_VOLUME            5
#define VIS5D_HWIND             6
#define VIS5D_VWIND             7
#define VIS5D_TRAJ              8
#define VIS5D_TOPO              9
#define VIS5D_BOX              10
#define VIS5D_BACKGROUND       11
#define VIS5D_LABEL            12
#define VIS5D_CLOCK            13
#define VIS5D_MAP              14
#define VIS5D_PERSPECTIVE      15
#define VIS5D_CONTOUR_NUMBERS  16
#define VIS5D_GRID_COORDS      17
#define VIS5D_PRETTY           18
#define VIS5D_INFO             20
#define VIS5D_PROBE            21
#define VIS5D_CURSOR           22
#define VIS5D_ANIMRECORD       23
#define VIS5D_NORTH            24
#define VIS5D_SOUTH            25
#define VIS5D_EAST             26
#define VIS5D_WEST             27
#define VIS5D_TOP              28
#define VIS5D_BOTTOM           29
#define VIS5D_TEXTURE          30
#define VIS5D_DEPTHCUE         31
#define VIS5D_HSTREAM          32
#define VIS5D_VSTREAM          33
#define VIS5D_LEGENDS          34
#define VIS5D_JULIAN           35
#define VIS5D_BARBS            36
#define VIS5D_RIGHT            37
#define VIS5D_LEFT             38
#define VIS5D_SOUND            39
#define VIS5D_SND_THTA         40
#define VIS5D_SND_THTE         41
#define VIS5D_SND_W            42
#define VIS5D_SND_TICKS        43
#define VIS5D_REVERSE          44

/* Variable types: */
#define VIS5D_REGULAR         90
#define VIS5D_CLONE           91
#define VIS5D_EXT_FUNC        92
#define VIS5D_EXPRESSION      93
#define VIS5D_PUT             94


/* modes for vis5d_graphics_mode */
#define VIS5D_OFF           0
#define VIS5D_ON            1
#define VIS5D_TOGGLE        2
#define VIS5D_GET           3


/* Map projections and vertical coordinate systems: */
#define PROJ_GENERIC          0  /* No specific units */
#define PROJ_LINEAR           1  /* Cylindrical-Equidistant (old vis5d) */
#define PROJ_LAMBERT          2  /* Lambert conformal */
#define PROJ_STEREO           3  /* Stereographic */
#define PROJ_ROTATED          4  /* Rotated equidistant */
#define PROJ_CYLINDRICAL     20  /* Cylindrical projection of cyl-equid. */
#define PROJ_SPHERICAL       21  /* Spherical projection of cyl-equid. */

#define VERT_GENERIC          0 /* No specific units */
#define VERT_EQUAL_KM         1 /* Equally spaced in kilometers */
#define VERT_NONEQUAL_KM      2 /* Non-equally spaced in kilometers */
#define VERT_NONEQUAL_MB      3 /* Non-equally spaced in millibars */


/* Image save formats: */
#define VIS5D_RGB       1
#define VIS5D_GIF       2
#define VIS5D_XWD       4
#define VIS5D_PS        8
#define VIS5D_COLOR_PS 16


/* Number of trajectory sets */
#define VIS5D_TRAJ_SETS   8

/* Number of wind slices and streams */
#define VIS5D_WIND_SLICES 2


/* Color table parameters */
#define DEFAULT_CURVE     1.4
#define DEFAULT_BIAS      1.0
#define DEFAULT_ALPHAPOW  2.0

  /* **** These values must match the ones in lui/colorbar.h !!!! **** */
#define CURVE    0
#define BIAS     1
#define ALPHAPOW 2
#define ALPHAVAL 3
#define DRAWFLAG 4
#define MINALPHA 5
#define MAXALPHA 6
#define MAX_TABLE 1000


/*
 * Initialization functions
 */


extern int vis5d_initialize( int cavemode );

extern int vis5d_terminate( int close_window );

extern int vis5d_workers( int nworkers );

extern int vis5d_get_image_formats( void );




extern int vis5d_alloc_context( void );

extern int vis5d_destroy_context( int index, int close_window );

extern int vis5d_init_begin( int index );

extern int vis5d_init_end( int index );


extern int vis5d_init_window( int index, char *title,
                                     int x, int y, int width, int height );

extern int vis5d_init_sndwindow( int index, char *title,
                                     int x, int y, int width, int height,
                                     Window scw, char *wdpy_name );
extern int vis5d_map_sndwindow( int index, int show);


#ifdef SGI_GL
extern int vis5d_init_gl_window( int index, Display *dpy, Window window,
                                       long winid );

extern int vis5d_init_glx_window( int index, Display *dpy,
                                        Window window, GLXconfig *ctx );
#endif


#ifdef OPENGL
extern int vis5d_init_opengl_window( int index, Display *dpy,
                                           Window window, GLXContext ctx );
#endif


extern int vis5d_init_map( int index, char *mapname );

extern int vis5d_init_topo( int index, char *toponame,
                                   int highres_flag );

extern int vis5d_init_texture( int index, char *texturename );

extern int vis5d_init_firstarea( int index, int area );

extern int vis5d_init_sequence( int index, char *sequencename );



extern int vis5d_init_log( int index, float scale, float exponent );

extern int vis5d_init_samescale( int index );

extern int vis5d_init_box( int index, float alon,
                                  float alat, float ahgt );

extern int vis5d_init_projection( int index, int projection,
                                         float *projargs );

extern int vis5d_init_vertical( int index, int vertical,
                                       float *vertargs );



extern int vis5d_init_memory( int index, int mbs );

extern int vis5d_init_path( int index, char *pathname );

extern int vis5d_get_v5dfilename( int index, char *name );

extern int vis5d_query_gridfile( char *name, v5dstruct *v);

extern int vis5d_open_gridfile( int index, char *name, int read_flag );



/*
 * Post-initialization functions
 */

/* Time functions */

extern int vis5d_get_numtimes( int index, int *numtimes );

extern int vis5d_get_time_stamp( int index, int timestep,
                                        int *day, int *time );

extern int vis5d_set_time_stamp( int index, int timestep,
                                        int day, int time );

extern int vis5d_set_timestep( int index, int curtime );

extern int vis5d_get_timestep( int index, int *curtime);


/* Variable functions */

extern int vis5d_get_numvars( int index, int *numvars );

extern int vis5d_find_var( int index, char *name );

extern int vis5d_get_var_name( int index, int var, char *name );

extern int vis5d_get_var_units( int index, int var, char *units );

extern int vis5d_get_var_type( int index, int var, int *type );

extern int vis5d_get_var_info( int index, int var, void *info );

extern int vis5d_get_var_range( int index, int var,
                                       float *min, float *max );

extern int vis5d_set_var_range( int index, int var,
                                       float min, float max );

extern int vis5d_set_sound_vars( int index, int temp, int dewpt, int uwind, int vwind,
                                 int var1, int var2, int var3);

extern int vis5d_get_sound_vars( int index, int *temp, int *dewpt,
                                            int *uwind, int*vwind,
                                 int *var1, int *var2, int *var3);

extern int vis5d_get_wind_vars( int index,
                                       int *uvar, int *vvar, int *wvar,
                                       int *u2var, int *v2var, int *w2var,
                                       int *traju, int *trajv, int *trajw );

extern int vis5d_set_wind_vars( int index,
                                int Uvar, int Vvar, int Wvar,
                                int Uvar2, int Vvar2, int Wvar2,
                                int TrajU, int TrajV, int TrajW );


extern int vis5d_reset_var_graphics( int index, int var );


/* Grid functions */

extern int vis5d_get_size( int index, int *nr, int *nc, int nl[],
                                  int lowlev[], int *maxnl, int *maxnlvar,
                                  int *windnl, int *windlow );

extern int vis5d_get_grid( int index, int time, int var, float *data );

extern int vis5d_put_grid( int index, int time, int var, float *data );

extern int vis5d_get_grid_value( int index, int var,
                                 float row, float column, float level,
                                 float *value );


extern int vis5d_verylarge_mode( int index, int mode );

/* Map projection and VCS functions */

extern int vis5d_get_projection( int index, int *projection,
                                        float *projargs );

extern int vis5d_get_vertical( int index, int *vertical,
                                      float *vertargs );

extern int vis5d_get_curved( int index, int *curved );


/* Topograhy, map and texture functions */

extern int vis5d_check_topo( int index, int *topoflag );

extern int vis5d_check_map( int index, int *mapflag );

extern int vis5d_check_texture( int index, int *textureflag );

extern int vis5d_get_topo_range( int index, float *min, float *max );

extern int vis5d_reset_topo_colors( int index );

extern int vis5d_texture_image( int index, int timestep,
                                int width, int height, int components,
                                void *image );

extern int vis5d_set_topo_color_var( int index, int colorvar );

extern int vis5d_get_topo_color_var( int index, int *colorvar );


/* Cloning, Ext funcs, and expression functions */

extern int vis5d_make_clone_variable( int index, int var_to_clone,
                                             char *newname, int *newvar );

extern int vis5d_compute_ext_func( int index, char *funcname,
                                          int *newvar );

extern int vis5d_compute_expression( int index, char *expression,
                                            char *newname, int *newvar,
                                            int *recompute, char *mess );

extern int vis5d_make_expr_var( int index, char *expression,
                                       char *newname, char *mess,
                                       int *newvar, int *recompute );

extern int vis5d_make_new_var( int index, char *newname, int nl,
                                       int lowlev, int *newvar );


/* Rendering functions */

extern int vis5d_signal_redraw( int index, int count );

extern int vis5d_check_redraw( int index, int *redraw );

extern int vis5d_draw_frame( int index, int animflag );

extern int vis5d_draw_3d_only( int index, int animflag );

extern int vis5d_draw_2d_only( int index );

extern int vis5d_draw_sounding_only( int index, int pixmapflag);

extern int vis5d_swap_frame( int index );

extern int vis5d_invalidate_frames( int index );

extern int vis5d_set_pointer( int index, int x, int y );

extern int vis5d_set_sounding_graphics_mode( int index, int smode, int onoroff);

extern int vis5d_get_sounding_graphics_mode( int index, int smode, int *onoroff);

extern int vis5d_graphics_mode( int index, int type, int mode );

extern int vis5d_enable_graphics( int index, int type, int number,
                                         int mode );

extern int vis5d_check_volume( int index, int *volflag );

extern int vis5d_set_volume( int index, int current_volume );

extern int vis5d_get_volume( int index, int *current_voluem );

extern int vis5d_get_graphics_color_address( int index, int type,
                                       int number, unsigned int **color );

extern int vis5d_set_color( int index, int type, int number,
                                   float red, float green, float blue,
                                   float alpha );

extern int vis5d_get_color( int index, int type, int number,
                     float *red, float *green, float *blue, float *alpha );

extern int vis5d_get_color_table_address( int index, int type,
                                      int number, unsigned int **color );

extern int vis5d_set_cursor_color( int index, int traj_set );


extern int vis5d_get_color_table_params( int index, int graphic, int var,
                                         float **params );

extern int vis5d_load_color_table( int index, int graphic, int var,
                            int table_size, char *filename);


extern int vis5d_set_color_table_params( int index, int graphic, int var,
                                         float params[] );


extern int vis5d_color_table_init_params( float params[],
                                          int rgb_flag, int alpha_flag );


extern int vis5d_color_table_recompute( unsigned int table[], int size,
                                        float params[],
                                        int rgb_flag, int alpha_flag );


extern int vis5d_color_table_set_alpha( float params[], float alpha );



extern int vis5d_alpha_mode( int index, int mode );

extern int vis5d_font( int index, char *fontname, int size );

extern int vis5d_linewidth( int index, float width );

extern int vis5d_gl_setup( int index, long win_id,
                                  int width, int height );



/* 3-D view functions */

extern int vis5d_set_matrix( int index, float ctm[4][4] );

extern int vis5d_get_matrix( int index, float ctm[4][4] );

extern int vis5d_set_ortho_view( int index, int view );

extern int vis5d_set_view( int index,
                                  float xrot, float yrot, float zrot,
                                  float scale,
                                  float xtrans, float ytrans, float ztrans );

extern int vis5d_get_view( int index,
                                 float *xrot, float *yrot, float *zrot,
                                 float *scale,
                                 float *xtrans, float *ytrans, float *ztrans );

extern int vis5d_set_camera( int index, int perspec, float front, float zoom );

extern int vis5d_get_camera( int index, int *perspec, float *front,
                            float *zoom );


extern int vis5d_get_box_bounds( int index, float *xmin, float *xmax,
                          float *ymin, float *ymax, float *zmin, float *zmax );



/* Isosurface, slice and trajectory functions */

extern int vis5d_make_isosurface( int index, int time, int var,
                                         int urgent );

extern int vis5d_set_isosurface( int index, int var, float isolevel );

extern int vis5d_get_isosurface( int index, int var, float *isolevel );

extern int vis5d_set_isosurface_color_var( int index, int iso_var,
                                           int colorvar );

extern int vis5d_get_isosurface_color_var( int index, int iso_var,
                                           int *colorvar );


extern int vis5d_make_hslice( int index, int time, int var,
                                     int urgent );

extern int vis5d_set_hslice( int index, int var, float interval,
                                    float low, float high, float level );

extern int vis5d_get_hslice( int index, int var, float *interval,
                                    float *low, float *high, float *level );

extern int vis5d_make_vslice( int index, int time, int var,
                                     int urgent );

extern int vis5d_set_vslice( int index, int var,
                                    float interval, float low,
                                    float high, float row0, float col0,
                                    float row1, float col1 );

extern int vis5d_get_vslice( int index, int var,
                                    float *interval, float *low,
                                    float *high, float *row0, float *col0,
                                    float *row1, float *col1 );

extern int vis5d_make_chslice( int index, int time, int var,
                                      int urgent );

extern int vis5d_set_chslice( int index, int var, float level );

extern int vis5d_get_chslice( int index, int var, float *level );

extern int vis5d_make_cvslice( int index, int time, int var,
                                      int urgent );

extern int vis5d_set_cvslice( int index, int var,
                                     float row0, float col0,
                                     float row1, float col1 );

extern int vis5d_get_cvslice( int index, int var,
                                     float *row0, float *col0,
                                     float *row1, float *col1 );

extern int vis5d_make_hwindslice( int index, int time, int slice,
                                         int urgent );

extern int vis5d_set_hwindslice( int index, int slice, float density,
                                        float scale, float level );

extern int vis5d_get_hwindslice( int index, int slice, float *density,
                                        float *scale, float *level );

extern int vis5d_make_vwindslice( int index, int time, int slicee,
                                         int urgent );

extern int vis5d_set_vwindslice( int index, int slice, float density,
                                        float scale, float row0, float col0,
                                        float row1, float col1 );

extern int vis5d_get_vwindslice( int index, int slice, float *density,
                                        float *scale, float *row0, float *col0,
                                        float *row1, float *col1 );

extern int vis5d_make_hstreamslice( int index, int time, int slice,
                                         int urgent );

extern int vis5d_set_hstreamslice( int index, int slice, float density,
                                        float level );

extern int vis5d_get_hstreamslice( int index, int slice, float *density,
                                        float *level );

extern int vis5d_make_vstreamslice( int index, int time, int slice,
                                         int urgent );

extern int vis5d_set_vstreamslice( int index, int slice, float density,
                                   float row0, float col0,
                                   float row1, float col1 );

extern int vis5d_get_vstreamslice( int index, int slice, float *density,
                                   float *row0, float *col0,
                                   float *row1, float *col1 );

extern int vis5d_print_traj( int index, int traj_num, float lat[],
                      float lon[], float hgt[], float traj_value[]);

extern int vis5d_make_traj( int index, float row, float col, float lev,
                                   int time, int set );

extern int vis5d_set_traj( int index, float step, float length,
                                  int ribbon_flag );

extern int vis5d_get_traj( int index, float *step, float *length,
                                  int *ribbon_flag );

extern int vis5d_set_trajectory_color_var( int index, int traj_var,
                                           int colorvar );

extern int vis5d_get_trajectory_color_var( int index, int traj_var,
                                           int *colorvar );

extern int vis5d_delete_last_traj( int index );

extern int vis5d_delete_traj_set( int index, int set );

extern int vis5d_get_num_traj( int index );

extern int vis5d_get_traj_info( int index, int trajnum,
                                float *row, float *column, float *level,
                                int *timestep, float *step, float *length,
                                int *group, int *ribbon );


extern int vis5d_make_timestep_graphics( int index, int time );

extern int vis5d_free_graphics( int index );



/* Text label functions */

extern int vis5d_make_label( int index, int x, int y, char *text );

extern int vis5d_new_label( int index, int x, int y, int *label_id );

extern int vis5d_edit_label( int index, char chr );

extern int vis5d_find_label( int index, int *x, int *y, int *label_id );

extern int vis5d_move_label( int index, int label_id, int x, int y );

extern int vis5d_delete_label( int index, int label_id );

extern int vis5d_get_label( int index, int n,
                                   int *x, int *y, char *label );



/* 3-D cursor functions */

extern int vis5d_set_cursor( int index, float x, float y, float z );

extern int vis5d_get_cursor( int index, float *x, float *y, float *z );


/*** Color Legend Function */

extern int vis5d_set_legends( int index, int position, int size );


/*  Sounding  Functions */

extern int vis5d_get_sounding_window( int index, Window *window, int *width, int *height);

extern int vis5d_set_sounding_window( int index, Window window, int width, int height );


/* 3-D viewing window functions */

extern int vis5d_get_window( int index, Window *window,
                                    int *width, int *height );

extern int vis5d_resize_3d_window( int index, int width, int height );

extern int vis5d_resize_sounding_window( int index, int width, int height,
                                          int x, int y );

extern int vis5d_save_window( int index, char *filename, int format );

extern int vis5d_save_snd_window( int index, char *filename, int format );

extern int vis5d_print_window( int index );

extern int vis5d_print_snd_window( int index );


/* Coordinate conversion functions */

extern int vis5d_project( int index, float p[3],
                                 float *winx, float *winy );

extern int vis5d_unproject( int index, float winx, float winy,
                                   float point[3], float dir[3] );

extern int vis5d_grid_level_to_height( int index, int level, float *height);

extern int vis5d_xyz_to_grid( int index, int time, int var,
                                    float x, float y, float z,
                                    float *row, float *column, float *level );

extern int vis5d_grid_to_xyz( int index, int time, int var,
                                     float row, float column, float level,
                                     float *x, float *y, float *z );

extern int vis5d_xyz_to_geo( int index, int time, int var,
                                    float x, float y, float z,
                                    float *lat, float *lon, float *hgt );

extern int vis5d_geo_to_xyz( int index, int time, int var,
                                    float lat, float lon, float hgt,
                                    float *x, float *y, float *z );


/* Save and restore functions */

extern int vis5d_restore( int index, char *filename );



/*
 * Miscellaneous functions
 */

extern int vis5d_do_work( void );

extern int vis5d_check_work( int *pending_flag );

extern int vis5d_finish_work( void );



#endif  /*API_H*/
