#----------------------------------------------------------------------
# Created by: SrA Jeremie L Collins
# Date: 30 Jul 98
#----------------------------------------------------------------------
# File Name: mm5_t_sfc_new.tcl
# Product Name: Surface Winds/Temp (F)
#----------------------------------------------------------------------
# Data Design:
# Surface Winds (contour horizontal slice)
# Surface Temp (color horizontal slice)
#----------------------------------------------------------------------
# Labels:
# Surface Winds (KTS)/Temperature (deg F)
#----------------------------------------------------------------------

#start Surface Winds / Temperature
set start 0
source ./mm5_t_sfc_new_init.tcl

#source /appl/vis5d/mm5/bin/mm5_matrix.tcl

vis5d_enable_graphics $ctx VIS5D_CHSLICE "SFC_TMP" VIS5D_ON
vis5d_enable_graphics $ctx VIS5D_HWIND 0 VIS5D_ON

set type "SFCWDT"
set base "johan" 
set zero "0"
set format VIS5D_GIF
set ext ".gif"
set numtimes [ vis5d_get_numtimes $ctx ]
set offset 2
set timestep 3

for {set time $start} {$time<$numtimes} {set time [expr $time+1]} {
  vis5d_set_timestep $ctx [expr $time]
  vis5d_make_chslice $ctx $time "SFC_TMP" 1
  vis5d_make_hwindslice $ctx $time 0 1
  vis5d_draw_frame $ctx  
  vis5d_do_work $ctx
  set ftime [expr ($time+$offset)*$timestep]
  if {$ftime < 100} {
    if {$ftime < 10} {
      set ftime $zero$ftime
    }
    set ftime $zero$ftime
  }
  set name $base$time$ext
  vis5d_save_window $ctx $name $format
}
