#    Copyright (C) 1998  Dennis Roddeman
#    email: dennis.roddeman@uibk.ac.at
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
# 
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#   
#   
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software Foundation
#    59 Temple Place, Suite 330, Boston, MA, 02111-1307, USA

proc run { task mode } {

  global tnpath
  source $tnpath/vtn/global.tcl

  cd $directory_start
  if { $task == "user_run" } {

    set delete_list "vtn.out vtn.ukn vtn.vtk vtn.dbs plotmtv* gmv*"
    foreach file $delete_list {
      if       { $platform == "unix"} {
        catch {exec rm $file}
      } elseif { $platform == "windows"} {
        catch {exec del $file}
      }
    }
    file_write vtn.dat initia_and_data
    if { $switch } { puts "running with file vtn.dat" }
    if { $mode=="foreground" } {
      exec $tnpath/src/tochnog vtn.dat > vtn.out
      set fileid [open vtn.out a]
      puts $fileid "running is ready"
      close $fileid
      puts "\a"
      viewfile vtn.out
    } else {
      exec $tnpath/src/tochnog vtn.dat > vtn.out &
    }

  } else {

    file_write vtn_tmp.dat only_initia
    if { $switch } { puts "running with file vtn_tmp.dat" }
    exec $tnpath/src/tochnog vtn_tmp.dat

  }

}
