
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/AsciiText.h>
#include "Textentry.h"

#define ABORT	0
#define	DONE	1
#define	WAITING	2
#define INIT	3

static Widget pshell, dialog, dialogLabel, dialogText,
	dialogCancel, dialogDone;

static int status = INIT;
int input_warp_pointer = 1;

static void DialogDone(Widget w, XtPointer client_data, XtPointer call_data)
{
	XtPopdown(pshell);
	status = DONE;
}

static void DialogAbort(Widget w, XtPointer client_data, XtPointer call_data)
{
	XtPopdown(pshell);
	status = ABORT;
}

static void DialogCancelAction(Widget w, XEvent * event,
		String * params, Cardinal * n)
{
	XtPopdown(pshell);
	status = ABORT;
}

static void DialogDoneAction(Widget w, XEvent * event,
		String * params, Cardinal * n)
{
	XtPopdown(pshell);
	status = DONE;
}

static XtActionsRec actions[] = {
	{"dialog-done", DialogDoneAction},
	{"dialog-cancel", DialogCancelAction},
};

static void init_input(Widget topLevel)
{
	XtAppContext app_context = XtWidgetToApplicationContext(topLevel);
	XtAppAddActions(app_context, actions, XtNumber(actions));

	pshell = XtVaCreatePopupShell("pshell",
		transientShellWidgetClass, topLevel, (char *)0);
	dialog = XtVaCreateManagedWidget("dialog",
		formWidgetClass, pshell, (char *)0);
	dialogLabel = XtVaCreateManagedWidget("dialogLabel",
		labelWidgetClass, dialog, (char *)0);
	dialogText = XtVaCreateManagedWidget("dialogText",
		textentryWidgetClass, dialog,
		XtNeditType, XawtextEdit, (char *)0);
	dialogDone = XtVaCreateManagedWidget("dialogDone",
		commandWidgetClass, dialog, (char *)0);
	dialogCancel = XtVaCreateManagedWidget("dialogCancel",
		commandWidgetClass, dialog, (char *)0);

	XtAddCallback(dialogDone, XtNcallback, DialogDone, NULL);
	XtAddCallback(dialogCancel, XtNcallback, DialogAbort, NULL);
}

int dialog_input(Widget pw, char *prompt, char *buffr, int (*comp)(char *))
{
	XtAppContext app_context = XtWidgetToApplicationContext(pw);
	Position x, y;
	Dimension width, height, w1, h1;
	String string;

	if (status == INIT) init_input(pw);

	status = WAITING;

	XtVaGetValues(pw,
		XtNwidth, &width,
		XtNheight, &height, (char *)0);
	XtVaGetValues(pshell,
		XtNwidth, &w1,
		XtNheight, &h1, (char *)0);
	XtTranslateCoords(pw,
	       (Position) (width - w1) / 2, (Position) (height - h1) / 2,
		&x, &y);
	XtVaSetValues(pshell,
		XtNx, x,
		XtNy, y, (char *)0);
	XtVaSetValues(dialogLabel,
		XtNlabel, prompt,
		XtNwidth, w1-10, (char *)0);
	XtVaSetValues(dialogText,
		XtNstring, buffr,
		XtNinsertPosition, strlen(buffr), (char *)0);
	XtPopup(pshell, XtGrabNonexclusive);
	if (input_warp_pointer)
		XWarpPointer(XtDisplay(pshell), None, XtWindow(pshell),
				0, 0, 0, 0, 0, 0);
	XtSetKeyboardFocus(pshell, dialogText);

	/* This sucks big time. We don't want to return until the
	   user has done something, but that also means that
	   we won't return to XtAppMainLoop, so no events will
	   be processed. The only way to avoid deadlock is to
	   make this ugly busy-wait implement the XtAppMainLoop
	   functionality. That's what you get from squeezing
	   Xlib applications into an Xt framework: doesn't fit.
	 */
	while (status == WAITING) {
		XEvent event_return;

		XtAppNextEvent(app_context, &event_return);
		XtDispatchEvent(&event_return);
	}

	XtVaGetValues(dialogText,
		XtNstring, &string, (char *)0);
	strcpy(buffr, string);
	return status;
}

