/*
   Copyright (C) 1996, 1997  Ulric Eriksson <ulric@edu.stockholm.se>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the Licence, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.
 */

#ifndef s_HsepP_h
#define s_HsepP_h

#include "Hsep.h"
/* include superclass private header file */
#include <X11/CoreP.h>

/* define unique representation types not found in <X11/StringDefs.h> */

#define XtRHsepResource "HsepResource"

typedef struct {
    int empty;
} HsepClassPart;

typedef struct s_HsepClassRec {
    CoreClassPart	core_class;
    HsepClassPart	hsep_class;
} HsepClassRec;

extern HsepClassRec hsepClassRec;

typedef struct {
    /* resources */
	Pixel highlight;
	Pixel shadow;
    /* private state */
	GC highlight_gc;
	GC shadow_gc;
} HsepPart;

typedef struct s_HsepRec {
    CorePart		core;
    HsepPart	hsep;
} HsepRec;

#endif /* s_HsepP_h */
